/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.timestreamwrite.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.timestreamwrite.model.Dimension;
import software.amazon.awssdk.services.timestreamwrite.model.DimensionsCopier;
import software.amazon.awssdk.services.timestreamwrite.model.MeasureValue;
import software.amazon.awssdk.services.timestreamwrite.model.MeasureValueType;
import software.amazon.awssdk.services.timestreamwrite.model.MeasureValuesCopier;
import software.amazon.awssdk.services.timestreamwrite.model.TimeUnit;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Record
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Record> {
    private static final SdkField<List<Dimension>> DIMENSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Dimensions").getter(Record.getter(Record::dimensions)).setter(Record.setter(Builder::dimensions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dimensions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Dimension::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MEASURE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MeasureName").getter(Record.getter(Record::measureName)).setter(Record.setter(Builder::measureName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MeasureName").build()}).build();
    private static final SdkField<String> MEASURE_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MeasureValue").getter(Record.getter(Record::measureValue)).setter(Record.setter(Builder::measureValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MeasureValue").build()}).build();
    private static final SdkField<String> MEASURE_VALUE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MeasureValueType").getter(Record.getter(Record::measureValueTypeAsString)).setter(Record.setter(Builder::measureValueType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MeasureValueType").build()}).build();
    private static final SdkField<String> TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Time").getter(Record.getter(Record::time)).setter(Record.setter(Builder::time)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Time").build()}).build();
    private static final SdkField<String> TIME_UNIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TimeUnit").getter(Record.getter(Record::timeUnitAsString)).setter(Record.setter(Builder::timeUnit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeUnit").build()}).build();
    private static final SdkField<Long> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("Version").getter(Record.getter(Record::version)).setter(Record.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()}).build();
    private static final SdkField<List<MeasureValue>> MEASURE_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MeasureValues").getter(Record.getter(Record::measureValues)).setter(Record.setter(Builder::measureValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MeasureValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MeasureValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIMENSIONS_FIELD, MEASURE_NAME_FIELD, MEASURE_VALUE_FIELD, MEASURE_VALUE_TYPE_FIELD, TIME_FIELD, TIME_UNIT_FIELD, VERSION_FIELD, MEASURE_VALUES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Record.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<Dimension> dimensions;
    private final String measureName;
    private final String measureValue;
    private final String measureValueType;
    private final String time;
    private final String timeUnit;
    private final Long version;
    private final List<MeasureValue> measureValues;

    private Record(BuilderImpl builder) {
        this.dimensions = builder.dimensions;
        this.measureName = builder.measureName;
        this.measureValue = builder.measureValue;
        this.measureValueType = builder.measureValueType;
        this.time = builder.time;
        this.timeUnit = builder.timeUnit;
        this.version = builder.version;
        this.measureValues = builder.measureValues;
    }

    public final boolean hasDimensions() {
        return this.dimensions != null && !(this.dimensions instanceof SdkAutoConstructList);
    }

    public final List<Dimension> dimensions() {
        return this.dimensions;
    }

    public final String measureName() {
        return this.measureName;
    }

    public final String measureValue() {
        return this.measureValue;
    }

    public final MeasureValueType measureValueType() {
        return MeasureValueType.fromValue(this.measureValueType);
    }

    public final String measureValueTypeAsString() {
        return this.measureValueType;
    }

    public final String time() {
        return this.time;
    }

    public final TimeUnit timeUnit() {
        return TimeUnit.fromValue(this.timeUnit);
    }

    public final String timeUnitAsString() {
        return this.timeUnit;
    }

    public final Long version() {
        return this.version;
    }

    public final boolean hasMeasureValues() {
        return this.measureValues != null && !(this.measureValues instanceof SdkAutoConstructList);
    }

    public final List<MeasureValue> measureValues() {
        return this.measureValues;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDimensions() ? this.dimensions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.measureName());
        hashCode = 31 * hashCode + Objects.hashCode(this.measureValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.measureValueTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.time());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeUnitAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMeasureValues() ? this.measureValues() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Record)) {
            return false;
        }
        Record other = (Record)obj;
        return this.hasDimensions() == other.hasDimensions() && Objects.equals(this.dimensions(), other.dimensions()) && Objects.equals(this.measureName(), other.measureName()) && Objects.equals(this.measureValue(), other.measureValue()) && Objects.equals(this.measureValueTypeAsString(), other.measureValueTypeAsString()) && Objects.equals(this.time(), other.time()) && Objects.equals(this.timeUnitAsString(), other.timeUnitAsString()) && Objects.equals(this.version(), other.version()) && this.hasMeasureValues() == other.hasMeasureValues() && Objects.equals(this.measureValues(), other.measureValues());
    }

    public final String toString() {
        return ToString.builder((String)"Record").add("Dimensions", this.hasDimensions() ? this.dimensions() : null).add("MeasureName", (Object)this.measureName()).add("MeasureValue", (Object)this.measureValue()).add("MeasureValueType", (Object)this.measureValueTypeAsString()).add("Time", (Object)this.time()).add("TimeUnit", (Object)this.timeUnitAsString()).add("Version", (Object)this.version()).add("MeasureValues", this.hasMeasureValues() ? this.measureValues() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Dimensions": {
                return Optional.ofNullable(clazz.cast(this.dimensions()));
            }
            case "MeasureName": {
                return Optional.ofNullable(clazz.cast(this.measureName()));
            }
            case "MeasureValue": {
                return Optional.ofNullable(clazz.cast(this.measureValue()));
            }
            case "MeasureValueType": {
                return Optional.ofNullable(clazz.cast(this.measureValueTypeAsString()));
            }
            case "Time": {
                return Optional.ofNullable(clazz.cast(this.time()));
            }
            case "TimeUnit": {
                return Optional.ofNullable(clazz.cast(this.timeUnitAsString()));
            }
            case "Version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "MeasureValues": {
                return Optional.ofNullable(clazz.cast(this.measureValues()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Dimensions", DIMENSIONS_FIELD);
        map.put("MeasureName", MEASURE_NAME_FIELD);
        map.put("MeasureValue", MEASURE_VALUE_FIELD);
        map.put("MeasureValueType", MEASURE_VALUE_TYPE_FIELD);
        map.put("Time", TIME_FIELD);
        map.put("TimeUnit", TIME_UNIT_FIELD);
        map.put("Version", VERSION_FIELD);
        map.put("MeasureValues", MEASURE_VALUES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Record, T> g) {
        return obj -> g.apply((Record)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Dimension> dimensions = DefaultSdkAutoConstructList.getInstance();
        private String measureName;
        private String measureValue;
        private String measureValueType;
        private String time;
        private String timeUnit;
        private Long version;
        private List<MeasureValue> measureValues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Record model) {
            this.dimensions(model.dimensions);
            this.measureName(model.measureName);
            this.measureValue(model.measureValue);
            this.measureValueType(model.measureValueType);
            this.time(model.time);
            this.timeUnit(model.timeUnit);
            this.version(model.version);
            this.measureValues(model.measureValues);
        }

        public final List<Dimension.Builder> getDimensions() {
            List<Dimension.Builder> result = DimensionsCopier.copyToBuilder(this.dimensions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDimensions(Collection<Dimension.BuilderImpl> dimensions) {
            this.dimensions = DimensionsCopier.copyFromBuilder(dimensions);
        }

        @Override
        public final Builder dimensions(Collection<Dimension> dimensions) {
            this.dimensions = DimensionsCopier.copy(dimensions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensions(Dimension ... dimensions) {
            this.dimensions(Arrays.asList(dimensions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensions(Consumer<Dimension.Builder> ... dimensions) {
            this.dimensions(Stream.of(dimensions).map(c -> (Dimension)((Dimension.Builder)Dimension.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getMeasureName() {
            return this.measureName;
        }

        public final void setMeasureName(String measureName) {
            this.measureName = measureName;
        }

        @Override
        public final Builder measureName(String measureName) {
            this.measureName = measureName;
            return this;
        }

        public final String getMeasureValue() {
            return this.measureValue;
        }

        public final void setMeasureValue(String measureValue) {
            this.measureValue = measureValue;
        }

        @Override
        public final Builder measureValue(String measureValue) {
            this.measureValue = measureValue;
            return this;
        }

        public final String getMeasureValueType() {
            return this.measureValueType;
        }

        public final void setMeasureValueType(String measureValueType) {
            this.measureValueType = measureValueType;
        }

        @Override
        public final Builder measureValueType(String measureValueType) {
            this.measureValueType = measureValueType;
            return this;
        }

        @Override
        public final Builder measureValueType(MeasureValueType measureValueType) {
            this.measureValueType(measureValueType == null ? null : measureValueType.toString());
            return this;
        }

        public final String getTime() {
            return this.time;
        }

        public final void setTime(String time) {
            this.time = time;
        }

        @Override
        public final Builder time(String time) {
            this.time = time;
            return this;
        }

        public final String getTimeUnit() {
            return this.timeUnit;
        }

        public final void setTimeUnit(String timeUnit) {
            this.timeUnit = timeUnit;
        }

        @Override
        public final Builder timeUnit(String timeUnit) {
            this.timeUnit = timeUnit;
            return this;
        }

        @Override
        public final Builder timeUnit(TimeUnit timeUnit) {
            this.timeUnit(timeUnit == null ? null : timeUnit.toString());
            return this;
        }

        public final Long getVersion() {
            return this.version;
        }

        public final void setVersion(Long version) {
            this.version = version;
        }

        @Override
        public final Builder version(Long version) {
            this.version = version;
            return this;
        }

        public final List<MeasureValue.Builder> getMeasureValues() {
            List<MeasureValue.Builder> result = MeasureValuesCopier.copyToBuilder(this.measureValues);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMeasureValues(Collection<MeasureValue.BuilderImpl> measureValues) {
            this.measureValues = MeasureValuesCopier.copyFromBuilder(measureValues);
        }

        @Override
        public final Builder measureValues(Collection<MeasureValue> measureValues) {
            this.measureValues = MeasureValuesCopier.copy(measureValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder measureValues(MeasureValue ... measureValues) {
            this.measureValues(Arrays.asList(measureValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder measureValues(Consumer<MeasureValue.Builder> ... measureValues) {
            this.measureValues(Stream.of(measureValues).map(c -> (MeasureValue)((MeasureValue.Builder)MeasureValue.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public Record build() {
            return new Record(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Record> {
        public Builder dimensions(Collection<Dimension> var1);

        public Builder dimensions(Dimension ... var1);

        public Builder dimensions(Consumer<Dimension.Builder> ... var1);

        public Builder measureName(String var1);

        public Builder measureValue(String var1);

        public Builder measureValueType(String var1);

        public Builder measureValueType(MeasureValueType var1);

        public Builder time(String var1);

        public Builder timeUnit(String var1);

        public Builder timeUnit(TimeUnit var1);

        public Builder version(Long var1);

        public Builder measureValues(Collection<MeasureValue> var1);

        public Builder measureValues(MeasureValue ... var1);

        public Builder measureValues(Consumer<MeasureValue.Builder> ... var1);
    }
}

