/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribe.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CallAnalyticsFeature {
    GENERATIVE_SUMMARIZATION("GENERATIVE_SUMMARIZATION"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CallAnalyticsFeature> VALUE_MAP;
    private final String value;

    private CallAnalyticsFeature(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CallAnalyticsFeature fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CallAnalyticsFeature> knownValues() {
        EnumSet<CallAnalyticsFeature> knownValues = EnumSet.allOf(CallAnalyticsFeature.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CallAnalyticsFeature.class, CallAnalyticsFeature::toString);
    }
}

