/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribe.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.transcribe.TranscribeAsyncClient;
import software.amazon.awssdk.services.transcribe.internal.UserAgentUtils;
import software.amazon.awssdk.services.transcribe.model.ListMedicalVocabulariesRequest;
import software.amazon.awssdk.services.transcribe.model.ListMedicalVocabulariesResponse;

public class ListMedicalVocabulariesPublisher
implements SdkPublisher<ListMedicalVocabulariesResponse> {
    private final TranscribeAsyncClient client;
    private final ListMedicalVocabulariesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListMedicalVocabulariesPublisher(TranscribeAsyncClient client, ListMedicalVocabulariesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListMedicalVocabulariesPublisher(TranscribeAsyncClient client, ListMedicalVocabulariesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListMedicalVocabulariesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListMedicalVocabulariesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListMedicalVocabulariesResponseFetcher
    implements AsyncPageFetcher<ListMedicalVocabulariesResponse> {
        private ListMedicalVocabulariesResponseFetcher() {
        }

        public boolean hasNextPage(ListMedicalVocabulariesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListMedicalVocabulariesResponse> nextPage(ListMedicalVocabulariesResponse previousPage) {
            if (previousPage == null) {
                return ListMedicalVocabulariesPublisher.this.client.listMedicalVocabularies(ListMedicalVocabulariesPublisher.this.firstRequest);
            }
            return ListMedicalVocabulariesPublisher.this.client.listMedicalVocabularies((ListMedicalVocabulariesRequest)((Object)ListMedicalVocabulariesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

