/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribe.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.transcribe.TranscribeClient;
import software.amazon.awssdk.services.transcribe.internal.UserAgentUtils;
import software.amazon.awssdk.services.transcribe.model.ListVocabulariesRequest;
import software.amazon.awssdk.services.transcribe.model.ListVocabulariesResponse;

public class ListVocabulariesIterable
implements SdkIterable<ListVocabulariesResponse> {
    private final TranscribeClient client;
    private final ListVocabulariesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListVocabulariesIterable(TranscribeClient client, ListVocabulariesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListVocabulariesResponseFetcher();
    }

    public Iterator<ListVocabulariesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListVocabulariesResponseFetcher
    implements SyncPageFetcher<ListVocabulariesResponse> {
        private ListVocabulariesResponseFetcher() {
        }

        public boolean hasNextPage(ListVocabulariesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListVocabulariesResponse nextPage(ListVocabulariesResponse previousPage) {
            if (previousPage == null) {
                return ListVocabulariesIterable.this.client.listVocabularies(ListVocabulariesIterable.this.firstRequest);
            }
            return ListVocabulariesIterable.this.client.listVocabularies((ListVocabulariesRequest)((Object)ListVocabulariesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

