/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribe.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.transcribe.TranscribeAsyncClient;
import software.amazon.awssdk.services.transcribe.internal.UserAgentUtils;
import software.amazon.awssdk.services.transcribe.model.ListVocabulariesRequest;
import software.amazon.awssdk.services.transcribe.model.ListVocabulariesResponse;

public class ListVocabulariesPublisher
implements SdkPublisher<ListVocabulariesResponse> {
    private final TranscribeAsyncClient client;
    private final ListVocabulariesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListVocabulariesPublisher(TranscribeAsyncClient client, ListVocabulariesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListVocabulariesPublisher(TranscribeAsyncClient client, ListVocabulariesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListVocabulariesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListVocabulariesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListVocabulariesResponseFetcher
    implements AsyncPageFetcher<ListVocabulariesResponse> {
        private ListVocabulariesResponseFetcher() {
        }

        public boolean hasNextPage(ListVocabulariesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListVocabulariesResponse> nextPage(ListVocabulariesResponse previousPage) {
            if (previousPage == null) {
                return ListVocabulariesPublisher.this.client.listVocabularies(ListVocabulariesPublisher.this.firstRequest);
            }
            return ListVocabulariesPublisher.this.client.listVocabularies((ListVocabulariesRequest)((Object)ListVocabulariesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

