/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribe.auth.scheme.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.http.auth.spi.scheme.AuthSchemeOption;
import software.amazon.awssdk.services.transcribe.auth.scheme.TranscribeAuthSchemeParams;
import software.amazon.awssdk.services.transcribe.auth.scheme.TranscribeAuthSchemeProvider;
import software.amazon.awssdk.utils.CollectionUtils;

@SdkInternalApi
public final class PreferredTranscribeAuthSchemeProvider
implements TranscribeAuthSchemeProvider {
    private final TranscribeAuthSchemeProvider delegate;
    private final List<String> authSchemePreference;

    public PreferredTranscribeAuthSchemeProvider(TranscribeAuthSchemeProvider delegate, List<String> authSchemePreference) {
        this.delegate = delegate;
        this.authSchemePreference = authSchemePreference != null ? authSchemePreference : Collections.emptyList();
    }

    @Override
    public List<AuthSchemeOption> resolveAuthScheme(TranscribeAuthSchemeParams params) {
        List<AuthSchemeOption> candidateAuthSchemes = this.delegate.resolveAuthScheme(params);
        if (CollectionUtils.isNullOrEmpty(this.authSchemePreference)) {
            return candidateAuthSchemes;
        }
        ArrayList<AuthSchemeOption> authSchemes = new ArrayList<AuthSchemeOption>();
        this.authSchemePreference.forEach(preferredSchemeId -> candidateAuthSchemes.stream().filter(candidate -> {
            String candidateSchemeName = candidate.schemeId().contains("#") ? candidate.schemeId().split("#")[1] : candidate.schemeId();
            return candidateSchemeName.equals(preferredSchemeId);
        }).findFirst().ifPresent(authSchemes::add));
        candidateAuthSchemes.forEach(candidate -> {
            if (!authSchemes.contains(candidate)) {
                authSchemes.add((AuthSchemeOption)candidate);
            }
        });
        return authSchemes;
    }
}

