/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribe.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.transcribe.TranscribeAsyncClient;
import software.amazon.awssdk.services.transcribe.internal.UserAgentUtils;
import software.amazon.awssdk.services.transcribe.model.ListMedicalTranscriptionJobsRequest;
import software.amazon.awssdk.services.transcribe.model.ListMedicalTranscriptionJobsResponse;

public class ListMedicalTranscriptionJobsPublisher
implements SdkPublisher<ListMedicalTranscriptionJobsResponse> {
    private final TranscribeAsyncClient client;
    private final ListMedicalTranscriptionJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListMedicalTranscriptionJobsPublisher(TranscribeAsyncClient client, ListMedicalTranscriptionJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListMedicalTranscriptionJobsPublisher(TranscribeAsyncClient client, ListMedicalTranscriptionJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListMedicalTranscriptionJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListMedicalTranscriptionJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListMedicalTranscriptionJobsResponseFetcher
    implements AsyncPageFetcher<ListMedicalTranscriptionJobsResponse> {
        private ListMedicalTranscriptionJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListMedicalTranscriptionJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListMedicalTranscriptionJobsResponse> nextPage(ListMedicalTranscriptionJobsResponse previousPage) {
            if (previousPage == null) {
                return ListMedicalTranscriptionJobsPublisher.this.client.listMedicalTranscriptionJobs(ListMedicalTranscriptionJobsPublisher.this.firstRequest);
            }
            return ListMedicalTranscriptionJobsPublisher.this.client.listMedicalTranscriptionJobs((ListMedicalTranscriptionJobsRequest)((Object)ListMedicalTranscriptionJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

