/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transfer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.transfer.model.ListedAgreement;
import software.amazon.awssdk.services.transfer.model.ListedAgreementsCopier;
import software.amazon.awssdk.services.transfer.model.TransferResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAgreementsResponse
extends TransferResponse
implements ToCopyableBuilder<Builder, ListAgreementsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListAgreementsResponse.getter(ListAgreementsResponse::nextToken)).setter(ListAgreementsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<ListedAgreement>> AGREEMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Agreements").getter(ListAgreementsResponse.getter(ListAgreementsResponse::agreements)).setter(ListAgreementsResponse.setter(Builder::agreements)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Agreements").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ListedAgreement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, AGREEMENTS_FIELD));
    private final String nextToken;
    private final List<ListedAgreement> agreements;

    private ListAgreementsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.agreements = builder.agreements;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasAgreements() {
        return this.agreements != null && !(this.agreements instanceof SdkAutoConstructList);
    }

    public final List<ListedAgreement> agreements() {
        return this.agreements;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAgreements() ? this.agreements() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAgreementsResponse)) {
            return false;
        }
        ListAgreementsResponse other = (ListAgreementsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasAgreements() == other.hasAgreements() && Objects.equals(this.agreements(), other.agreements());
    }

    public final String toString() {
        return ToString.builder((String)"ListAgreementsResponse").add("NextToken", (Object)this.nextToken()).add("Agreements", this.hasAgreements() ? this.agreements() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Agreements": {
                return Optional.ofNullable(clazz.cast(this.agreements()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAgreementsResponse, T> g) {
        return obj -> g.apply((ListAgreementsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TransferResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ListedAgreement> agreements = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListAgreementsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.agreements(model.agreements);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ListedAgreement.Builder> getAgreements() {
            List<ListedAgreement.Builder> result = ListedAgreementsCopier.copyToBuilder(this.agreements);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAgreements(Collection<ListedAgreement.BuilderImpl> agreements) {
            this.agreements = ListedAgreementsCopier.copyFromBuilder(agreements);
        }

        @Override
        public final Builder agreements(Collection<ListedAgreement> agreements) {
            this.agreements = ListedAgreementsCopier.copy(agreements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder agreements(ListedAgreement ... agreements) {
            this.agreements(Arrays.asList(agreements));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder agreements(Consumer<ListedAgreement.Builder> ... agreements) {
            this.agreements(Stream.of(agreements).map(c -> (ListedAgreement)((ListedAgreement.Builder)ListedAgreement.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListAgreementsResponse build() {
            return new ListAgreementsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends TransferResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAgreementsResponse> {
        public Builder nextToken(String var1);

        public Builder agreements(Collection<ListedAgreement> var1);

        public Builder agreements(ListedAgreement ... var1);

        public Builder agreements(Consumer<ListedAgreement.Builder> ... var1);
    }
}

