/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.xray.model.Trace;
import software.amazon.awssdk.services.xray.model.TraceListCopier;
import software.amazon.awssdk.services.xray.model.UnprocessedTraceIdListCopier;
import software.amazon.awssdk.services.xray.model.XRayResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetTracesResponse
extends XRayResponse
implements ToCopyableBuilder<Builder, BatchGetTracesResponse> {
    private static final SdkField<List<Trace>> TRACES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Traces").getter(BatchGetTracesResponse.getter(BatchGetTracesResponse::traces)).setter(BatchGetTracesResponse.setter(Builder::traces)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Traces").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Trace::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> UNPROCESSED_TRACE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UnprocessedTraceIds").getter(BatchGetTracesResponse.getter(BatchGetTracesResponse::unprocessedTraceIds)).setter(BatchGetTracesResponse.setter(Builder::unprocessedTraceIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnprocessedTraceIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(BatchGetTracesResponse.getter(BatchGetTracesResponse::nextToken)).setter(BatchGetTracesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRACES_FIELD, UNPROCESSED_TRACE_IDS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchGetTracesResponse.memberNameToFieldInitializer();
    private final List<Trace> traces;
    private final List<String> unprocessedTraceIds;
    private final String nextToken;

    private BatchGetTracesResponse(BuilderImpl builder) {
        super(builder);
        this.traces = builder.traces;
        this.unprocessedTraceIds = builder.unprocessedTraceIds;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasTraces() {
        return this.traces != null && !(this.traces instanceof SdkAutoConstructList);
    }

    public final List<Trace> traces() {
        return this.traces;
    }

    public final boolean hasUnprocessedTraceIds() {
        return this.unprocessedTraceIds != null && !(this.unprocessedTraceIds instanceof SdkAutoConstructList);
    }

    public final List<String> unprocessedTraceIds() {
        return this.unprocessedTraceIds;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTraces() ? this.traces() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUnprocessedTraceIds() ? this.unprocessedTraceIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetTracesResponse)) {
            return false;
        }
        BatchGetTracesResponse other = (BatchGetTracesResponse)((Object)obj);
        return this.hasTraces() == other.hasTraces() && Objects.equals(this.traces(), other.traces()) && this.hasUnprocessedTraceIds() == other.hasUnprocessedTraceIds() && Objects.equals(this.unprocessedTraceIds(), other.unprocessedTraceIds()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetTracesResponse").add("Traces", this.hasTraces() ? this.traces() : null).add("UnprocessedTraceIds", this.hasUnprocessedTraceIds() ? this.unprocessedTraceIds() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Traces": {
                return Optional.ofNullable(clazz.cast(this.traces()));
            }
            case "UnprocessedTraceIds": {
                return Optional.ofNullable(clazz.cast(this.unprocessedTraceIds()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Traces", TRACES_FIELD);
        map.put("UnprocessedTraceIds", UNPROCESSED_TRACE_IDS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetTracesResponse, T> g) {
        return obj -> g.apply((BatchGetTracesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends XRayResponse.BuilderImpl
    implements Builder {
        private List<Trace> traces = DefaultSdkAutoConstructList.getInstance();
        private List<String> unprocessedTraceIds = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetTracesResponse model) {
            super(model);
            this.traces(model.traces);
            this.unprocessedTraceIds(model.unprocessedTraceIds);
            this.nextToken(model.nextToken);
        }

        public final List<Trace.Builder> getTraces() {
            List<Trace.Builder> result = TraceListCopier.copyToBuilder(this.traces);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTraces(Collection<Trace.BuilderImpl> traces) {
            this.traces = TraceListCopier.copyFromBuilder(traces);
        }

        @Override
        public final Builder traces(Collection<Trace> traces) {
            this.traces = TraceListCopier.copy(traces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder traces(Trace ... traces) {
            this.traces(Arrays.asList(traces));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder traces(Consumer<Trace.Builder> ... traces) {
            this.traces(Stream.of(traces).map(c -> (Trace)((Trace.Builder)Trace.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getUnprocessedTraceIds() {
            if (this.unprocessedTraceIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.unprocessedTraceIds;
        }

        public final void setUnprocessedTraceIds(Collection<String> unprocessedTraceIds) {
            this.unprocessedTraceIds = UnprocessedTraceIdListCopier.copy(unprocessedTraceIds);
        }

        @Override
        public final Builder unprocessedTraceIds(Collection<String> unprocessedTraceIds) {
            this.unprocessedTraceIds = UnprocessedTraceIdListCopier.copy(unprocessedTraceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedTraceIds(String ... unprocessedTraceIds) {
            this.unprocessedTraceIds(Arrays.asList(unprocessedTraceIds));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public BatchGetTracesResponse build() {
            return new BatchGetTracesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends XRayResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetTracesResponse> {
        public Builder traces(Collection<Trace> var1);

        public Builder traces(Trace ... var1);

        public Builder traces(Consumer<Trace.Builder> ... var1);

        public Builder unprocessedTraceIds(Collection<String> var1);

        public Builder unprocessedTraceIds(String ... var1);

        public Builder nextToken(String var1);
    }
}

