/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.xray.XRayClient;
import software.amazon.awssdk.services.xray.internal.UserAgentUtils;
import software.amazon.awssdk.services.xray.model.BatchGetTracesRequest;
import software.amazon.awssdk.services.xray.model.BatchGetTracesResponse;
import software.amazon.awssdk.services.xray.model.Trace;

public class BatchGetTracesIterable
implements SdkIterable<BatchGetTracesResponse> {
    private final XRayClient client;
    private final BatchGetTracesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public BatchGetTracesIterable(XRayClient client, BatchGetTracesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new BatchGetTracesResponseFetcher();
    }

    public Iterator<BatchGetTracesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Trace> traces() {
        Function<BatchGetTracesResponse, Iterator> getIterator = response -> {
            if (response != null && response.traces() != null) {
                return response.traces().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class BatchGetTracesResponseFetcher
    implements SyncPageFetcher<BatchGetTracesResponse> {
        private BatchGetTracesResponseFetcher() {
        }

        public boolean hasNextPage(BatchGetTracesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public BatchGetTracesResponse nextPage(BatchGetTracesResponse previousPage) {
            if (previousPage == null) {
                return BatchGetTracesIterable.this.client.batchGetTraces(BatchGetTracesIterable.this.firstRequest);
            }
            return BatchGetTracesIterable.this.client.batchGetTraces((BatchGetTracesRequest)((Object)BatchGetTracesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

