/*
 * Decompiled with CFR 0.152.
 */
package uk.co.lucasweb.aws.v4.signer.hash;

import java.nio.charset.Charset;
import java.security.MessageDigest;
import uk.co.lucasweb.aws.v4.signer.SigningException;
import uk.co.lucasweb.aws.v4.signer.functional.Throwables;

public final class Sha256 {
    private static final String SHA_256 = "SHA-256";
    private static final String ZERO = "0";
    private static final char[] hexDigits = "0123456789abcdef".toCharArray();

    private Sha256() {
    }

    public static String get(String value, Charset charset) {
        return Throwables.returnableInstance(() -> {
            MessageDigest md = MessageDigest.getInstance(SHA_256);
            byte[] bytes = value.getBytes(charset);
            md.update(bytes);
            int b = md.getDigestLength();
            return Sha256.bytesToHex(md.digest());
        }, SigningException::new);
    }

    private static String bytesToHex(byte[] bytes) {
        StringBuilder sb = new StringBuilder(2 * bytes.length);
        for (byte b : bytes) {
            sb.append(hexDigits[b >> 4 & 0xF]).append(hexDigits[b & 0xF]);
        }
        return sb.toString();
    }
}

