/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.tasks;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.NameScope;
import org.apache.commons.vfs.Selectors;
import org.apache.commons.vfs.tasks.VfsTask;
import org.apache.commons.vfs.util.Messages;
import org.apache.tools.ant.BuildException;

public abstract class AbstractSyncTask
extends VfsTask {
    private final ArrayList srcFiles = new ArrayList();
    private String destFileUrl;
    private String destDirUrl;
    private String srcDirUrl;
    private String filesList;

    public void setDestFile(String destFile) {
        this.destFileUrl = destFile;
    }

    public void setDestDir(String destDir) {
        this.destDirUrl = destDir;
    }

    public void setSrc(String srcFile) {
        SourceInfo src = new SourceInfo();
        src.setFile(srcFile);
        this.addConfiguredSrc(src);
    }

    public void setSrcDir(String srcDir) {
        this.srcDirUrl = srcDir;
    }

    public void setIncludes(String filesList) {
        this.filesList = filesList;
    }

    public void addConfiguredSrc(SourceInfo srcInfo) throws BuildException {
        if (srcInfo.file == null) {
            String message = Messages.getString("vfs.tasks/sync.no-source-file.error");
            throw new BuildException(message);
        }
        this.srcFiles.add(srcInfo);
    }

    public void execute() throws BuildException {
        if (this.destFileUrl == null && this.destDirUrl == null) {
            String message = Messages.getString("vfs.tasks/sync.no-destination.error");
            throw new BuildException(message);
        }
        if (this.destFileUrl != null && this.destDirUrl != null) {
            String message = Messages.getString("vfs.tasks/sync.too-many-destinations.error");
            throw new BuildException(message);
        }
        if (this.srcDirUrl != null && !this.srcDirUrl.equals(this.destDirUrl) && this.filesList != null && this.filesList.length() > 0) {
            if (!this.srcDirUrl.endsWith("/")) {
                this.srcDirUrl = this.srcDirUrl + "/";
            }
            StringTokenizer tok = new StringTokenizer(this.filesList, ", \t\n\r\f", false);
            while (tok.hasMoreTokens()) {
                String nextFile = tok.nextToken();
                if (nextFile.endsWith("/**")) {
                    nextFile = nextFile.substring(0, nextFile.length() - 2);
                }
                SourceInfo src = new SourceInfo();
                src.setFile(this.srcDirUrl + nextFile);
                this.addConfiguredSrc(src);
            }
        }
        if (this.srcFiles.size() == 0) {
            String message = Messages.getString("vfs.tasks/sync.no-source-files.warn");
            this.log(message, 1);
            return;
        }
        try {
            if (this.destFileUrl != null) {
                this.handleSingleFile();
            } else {
                this.handleFiles();
            }
        }
        catch (BuildException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BuildException(e.getMessage(), (Throwable)e);
        }
    }

    private void handleFiles() throws Exception {
        FileObject destFolder = this.resolveFile(this.destDirUrl);
        destFolder.createFolder();
        ArrayList<FileObject> srcs = new ArrayList<FileObject>();
        for (int i = 0; i < this.srcFiles.size(); ++i) {
            SourceInfo src = (SourceInfo)this.srcFiles.get(i);
            FileObject srcFile = this.resolveFile(src.file);
            if (!srcFile.exists()) {
                String message = Messages.getString("vfs.tasks/sync.src-file-no-exist.warn", srcFile);
                this.log(message, 1);
                continue;
            }
            srcs.add(srcFile);
        }
        HashSet destFiles = new HashSet();
        for (int i = 0; i < srcs.size(); ++i) {
            FileObject rootFile = (FileObject)srcs.get(i);
            FileName rootName = rootFile.getName();
            if (rootFile.getType() == FileType.FILE) {
                FileObject destFile = destFolder.resolveFile(rootName.getBaseName(), NameScope.DESCENDENT);
                this.handleFile(destFiles, rootFile, destFile);
                continue;
            }
            FileObject[] files = rootFile.findFiles(Selectors.SELECT_FILES);
            for (int j = 0; j < files.length; ++j) {
                FileObject srcFile = files[j];
                String relName = rootName.getRelativeName(srcFile.getName());
                FileObject destFile = destFolder.resolveFile(relName, NameScope.DESCENDENT);
                this.handleFile(destFiles, srcFile, destFile);
            }
        }
        if (this.detectMissingSourceFiles()) {
            FileObject[] allDestFiles = destFolder.findFiles(Selectors.SELECT_FILES);
            for (int i = 0; i < allDestFiles.length; ++i) {
                FileObject destFile = allDestFiles[i];
                if (destFiles.contains(destFile)) continue;
                this.handleMissingSourceFile(destFile);
            }
        }
    }

    private void handleFile(Set destFiles, FileObject srcFile, FileObject destFile) throws Exception {
        if (destFiles.contains(destFile)) {
            String message = Messages.getString("vfs.tasks/sync.duplicate-source-files.warn", destFile);
            this.log(message, 1);
        } else {
            destFiles.add(destFile);
        }
        this.handleFile(srcFile, destFile);
    }

    private void handleSingleFile() throws Exception {
        if (this.srcFiles.size() > 1) {
            String message = Messages.getString("vfs.tasks/sync.too-many-source-files.error");
            throw new BuildException(message);
        }
        SourceInfo src = (SourceInfo)this.srcFiles.get(0);
        FileObject srcFile = this.resolveFile(src.file);
        if (srcFile.getType() != FileType.FILE) {
            String message = Messages.getString("vfs.tasks/sync.source-not-file.error", srcFile);
            throw new BuildException(message);
        }
        FileObject destFile = this.resolveFile(this.destFileUrl);
        this.handleFile(srcFile, destFile);
    }

    private void handleFile(FileObject srcFile, FileObject destFile) throws Exception {
        if (!destFile.exists() || srcFile.getContent().getLastModifiedTime() > destFile.getContent().getLastModifiedTime()) {
            this.handleOutOfDateFile(srcFile, destFile);
        } else {
            this.handleUpToDateFile(srcFile, destFile);
        }
    }

    protected void handleOutOfDateFile(FileObject srcFile, FileObject destFile) throws Exception {
    }

    protected void handleUpToDateFile(FileObject srcFile, FileObject destFile) throws Exception {
    }

    protected void handleMissingSourceFile(FileObject destFile) throws Exception {
    }

    protected boolean detectMissingSourceFiles() {
        return false;
    }

    public static class SourceInfo {
        private String file;

        public void setFile(String file) {
            this.file = file;
        }
    }
}

