/*
 *
 * suco: Mini IoC framework a-la-guice style for GWT
 *
 * (c) 2009 The suco development team (see CREDITS for details)
 * This file is part of emite.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
package com.calclab.suco.client;

import com.calclab.suco.client.ioc.Container;
import com.calclab.suco.client.ioc.HashMapContainer;
import com.calclab.suco.client.log.Logger;

/**
 * A Factory to create containers. Usually you don't need to use this class (use
 * Suco instead)
 */
public class SucoFactory {
    /**
     * Create a new container. Usually you use don't need to call this method:
     * use the Suco.components container instead.
     * 
     * @param modules
     * @return
     */
    public static Container create() {
	Logger.debug("New container.");
	final HashMapContainer container = new HashMapContainer();
	new SucoCoreModule().onInstall(container);
	return container;
    }

}
