/*
 *
 * suco: Mini IoC framework a-la-guice style for GWT
 *
 * (c) 2009 The suco development team (see CREDITS for details)
 * This file is part of emite.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
package com.calclab.suco.client.log;

import java.util.Collection;

import com.allen_sauer.gwt.log.client.Log;

public class Logger {
    public static void debug(final String pattern, final Object... arguments) {
	if (Log.isDebugEnabled()) {
	    Log.debug(format(pattern, arguments));
	}
    }

    public static String format(String pattern, final Object... arguments) {
	final int total = arguments.length;
	for (int index = 0; index < total; index++) {
	    final Object arg = arguments[index];
	    final String value = arg == null ? "null" : arg.toString();
	    pattern = pattern.replace("{" + index + "}", value);
	}
	return pattern;
    }

    public static String toString(final Collection<?> objects) {
	final StringBuilder builder = new StringBuilder();

	for (final Object o : objects) {
	    builder.append(o.toString()).append(", ");
	}

	return builder.toString();
    }

}
