/*
 *
 * suco: Mini IoC framework a-la-guice style for GWT
 *
 * (c) 2009 The suco development team (see CREDITS for details)
 * This file is part of emite.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
package com.calclab.suco.examples;

import com.calclab.suco.client.Suco;
import com.calclab.suco.client.ioc.module.AbstractModule;
import com.google.gwt.core.client.EntryPoint;

/**
 * Its a good practice to install the Suco module when the GWT module loads. Its
 * really easy!
 */
public class AutoLoadModulesExample extends AbstractModule implements EntryPoint {

    /**
     * Overrides EntryPoint method: called when the module is loaded (you need
     * to specify in the .gwt.xml file)
     */
    public void onModuleLoad() {
	// install this instance when the gwt module is loaded
	Suco.install(this);
    }

    @Override
    protected void onInstall() {
	// register the components of this suco module
    }
}
