/*
 *
 * suco: Mini IoC framework a-la-guice style for GWT
 *
 * (c) 2009 The suco development team (see CREDITS for details)
 * This file is part of emite.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
package com.calclab.suco.examples;

import com.calclab.suco.client.events.Event;
import com.calclab.suco.client.events.Listener;
import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.core.client.GWT;

/**
 * This is the classical producer/observer pattern implemented with suco
 * 
 * @see http://code.google.com/p/suco/wiki/SucoEventsHowTo
 * 
 */
public class PublisherSubscriberExample implements EntryPoint {
    public void onModuleLoad() {
	final Publisher producer = new Publisher();
	new Subscriber(producer);
	new Subscriber(producer);
	producer.performSomeStuff();
    }
}

/**
 * The publisher use the Event as fields to help with the registration of
 * listeners and firing the events. Events can have params (there are different
 * Event classes for different number of params). The param of the event (a
 * string) is used for logging purposes.
 * 
 * Tipically the Publisher classes have a method to add listeners (we usually
 * use onXXX where XXX is the name of the event).
 */
class Publisher {
    private final Event<String> messageReceived = new Event<String>("messageReceived");

    public void onMessageReceived(final Listener<String> listener) {
	messageReceived.add(listener);
    }

    public void performSomeStuff() {
	// ... code ... and then we fire the event:
	messageReceived.fire("hello word!");
    }
}

/**
 * Subscribers usually attach listeners (anonymous classes implementing a
 * listener interface with the same number of params) to the publishers, using
 * the method(s) they provide.
 */
class Subscriber {
    public Subscriber(final Publisher producer) {
	producer.onMessageReceived(new Listener<String>() {
	    public void onEvent(final String message) {
		GWT.log("The message received was: " + message, null);
	    }
	});
    }
}
