/*
 *
 * suco: Mini IoC framework a-la-guice style for GWT
 *
 * (c) 2009 The suco development team (see CREDITS for details)
 * This file is part of emite.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
package com.calclab.suco.examples;

import com.calclab.suco.client.Suco;
import com.calclab.suco.client.ioc.decorator.NoDecoration;
import com.calclab.suco.client.ioc.decorator.Singleton;
import com.calclab.suco.client.ioc.module.AbstractModule;
import com.calclab.suco.client.ioc.module.Factory;
import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.core.client.GWT;

/**
 * Simple IoC usage example
 * 
 * @see http://code.google.com/p/suco/wiki/SucoIoCBasicHowTo
 * 
 */
public class SimpleIoCExample implements EntryPoint {
    public void onModuleLoad() {
	Suco.install(new SimpleModule());
	Suco.get(ComponentB.class);
	Suco.get(ComponentB.class);
    }
}

class ComponentA {
    private int counter = 0;

    public void doSomething() {
	counter++;
	GWT.log("Called " + counter + " times.", null);
    }
}

class ComponentB {
    public ComponentB(final ComponentA a) {
	a.doSomething();
    }
}

class SimpleModule extends AbstractModule {
    @Override
    protected void onInstall() {
	register(Singleton.class, new Factory<ComponentA>(ComponentA.class) {
	    @Override
	    public ComponentA create() {
		return new ComponentA();
	    }
	});

	register(NoDecoration.class, new Factory<ComponentB>(ComponentB.class) {
	    @Override
	    public ComponentB create() {
		return new ComponentB($(ComponentA.class));
	    }
	});
    }
}
