/*
 *
 * suco: Mini IoC framework a-la-guice style for GWT
 *
 * (c) 2009 The suco development team (see CREDITS for details)
 * This file is part of emite.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
package com.calclab.suco.examples.ioc;

import com.calclab.suco.client.ioc.Provider;
import com.calclab.suco.client.ioc.decorator.NoDecoration;
import com.calclab.suco.client.ioc.decorator.Singleton;
import com.calclab.suco.client.ioc.module.AbstractModule;
import com.calclab.suco.client.ioc.module.Factory;

public class ComponentRegistrationExample extends AbstractModule {

    public static class ComponentOne {
	public ComponentOne() {
	}
    }

    public static class ComponentTwo {
	public ComponentTwo(final ComponentOne one) {
	}
    }

    @Override
    protected void onInstall() {
	/**
	 * Register a component using NoDecoration (no scope) and providers
	 */
	register(NoDecoration.class, ComponentOne.class, new Provider<ComponentOne>() {
	    public ComponentOne get() {
		return new ComponentOne();
	    }
	});

	/**
	 * The same as above using factories
	 */
	register(NoDecoration.class, new Factory<ComponentOne>(ComponentOne.class) {
	    @Override
	    public ComponentOne create() {
		return new ComponentOne();
	    }
	});

	/**
	 * Apply the Singleton decorator (to reduce the scope) to more than one
	 * factory at once
	 */
	register(Singleton.class, new Factory<ComponentOne>(ComponentOne.class) {
	    @Override
	    public ComponentOne create() {
		return new ComponentOne();
	    }
	}, new Factory<ComponentTwo>(ComponentTwo.class) {
	    @Override
	    public ComponentTwo create() {
		return new ComponentTwo($(ComponentOne.class));
	    }
	});
    }

}
