/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.testing.AbstractIteratorTester;
import com.google.common.collect.testing.IteratorFeature;
import com.google.common.collect.testing.IteratorTester;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;

@GwtCompatible
public class IteratorTesterTest
extends TestCase {
    private static final int STEPS = 3;

    public void testCanCatchDifferentLengthOfIteration() {
        IteratorTester<Integer> tester = new IteratorTester<Integer>(4, (Iterable)IteratorFeature.MODIFIABLE, (Iterable)Lists.newArrayList((Object[])new Integer[]{1, 2, 3}), AbstractIteratorTester.KnownOrder.KNOWN_ORDER){

            protected Iterator<Integer> newTargetIterator() {
                return Lists.newArrayList((Object[])new Integer[]{1, 2, 3, 4}).iterator();
            }
        };
        IteratorTesterTest.assertFailure(tester);
    }

    public void testCanCatchDifferentContents() {
        IteratorTester<Integer> tester = new IteratorTester<Integer>(3, (Iterable)IteratorFeature.MODIFIABLE, (Iterable)Lists.newArrayList((Object[])new Integer[]{1, 2, 3}), AbstractIteratorTester.KnownOrder.KNOWN_ORDER){

            protected Iterator<Integer> newTargetIterator() {
                return Lists.newArrayList((Object[])new Integer[]{1, 3, 2}).iterator();
            }
        };
        IteratorTesterTest.assertFailure(tester);
    }

    public void testCanCatchDifferentRemoveBehaviour() {
        IteratorTester<Integer> tester = new IteratorTester<Integer>(3, (Iterable)IteratorFeature.MODIFIABLE, (Iterable)Lists.newArrayList((Object[])new Integer[]{1, 2}), AbstractIteratorTester.KnownOrder.KNOWN_ORDER){

            protected Iterator<Integer> newTargetIterator() {
                return ImmutableList.of((Object)1, (Object)2).iterator();
            }
        };
        IteratorTesterTest.assertFailure(tester);
    }

    public void testUnknownOrder() {
        new IteratorTester<Integer>(3, (Iterable)IteratorFeature.MODIFIABLE, (Iterable)Lists.newArrayList((Object[])new Integer[]{1, 2}), AbstractIteratorTester.KnownOrder.UNKNOWN_ORDER){

            protected Iterator<Integer> newTargetIterator() {
                return Lists.newArrayList((Object[])new Integer[]{2, 1}).iterator();
            }
        }.test();
    }

    public void testUnknownOrderUnrecognizedElement() {
        IteratorTester<Integer> tester = new IteratorTester<Integer>(3, (Iterable)IteratorFeature.MODIFIABLE, (Iterable)Lists.newArrayList((Object[])new Integer[]{1, 2, 50}), AbstractIteratorTester.KnownOrder.UNKNOWN_ORDER){

            protected Iterator<Integer> newTargetIterator() {
                return Lists.newArrayList((Object[])new Integer[]{2, 1, 3}).iterator();
            }
        };
        IteratorTesterTest.assertFailure(tester);
    }

    public void testCanCatchSunJavaBug6529795InTargetIterator() {
        try {
            new IteratorTester<Integer>(4, (Iterable)IteratorFeature.MODIFIABLE, (Iterable)Lists.newArrayList((Object[])new Integer[]{1, 2}), AbstractIteratorTester.KnownOrder.KNOWN_ORDER){

                protected Iterator<Integer> newTargetIterator() {
                    Iterator iterator = Lists.newArrayList((Object[])new Integer[]{1, 2}).iterator();
                    return new IteratorWithSunJavaBug6529795<Integer>(iterator);
                }
            }.test();
        }
        catch (AssertionFailedError e) {
            return;
        }
        IteratorTesterTest.fail((String)"Should have caught jdk6 bug in target iterator");
    }

    public void testVerifyGetsCalled() {
        TesterThatCountsCalls tester = new TesterThatCountsCalls();
        tester.test();
        IteratorTesterTest.assertEquals((String)"Should have verified once per stimulus executed", (int)tester.numCallsToVerify, (int)(tester.numCallsToNewTargetIterator * 3));
    }

    public void testVerifyCanThrowAssertionThatFailsTest() {
        String message = "Important info about why verify failed";
        IteratorTester<Integer> tester = new IteratorTester<Integer>(1, (Iterable)IteratorFeature.MODIFIABLE, (Iterable)Lists.newArrayList((Object[])new Integer[]{1, 2, 3}), AbstractIteratorTester.KnownOrder.KNOWN_ORDER){

            protected Iterator<Integer> newTargetIterator() {
                return Lists.newArrayList((Object[])new Integer[]{1, 2, 3}).iterator();
            }

            protected void verify(List<Integer> elements) {
                throw new AssertionFailedError("Important info about why verify failed");
            }
        };
        AssertionFailedError actual = null;
        try {
            tester.test();
        }
        catch (AssertionFailedError e) {
            actual = e;
        }
        IteratorTesterTest.assertNotNull((String)"verify() should be able to cause test failure", (Object)((Object)actual));
        IteratorTesterTest.assertTrue((String)"AssertionFailedError should have info about why test failed", (boolean)actual.getCause().getMessage().contains("Important info about why verify failed"));
    }

    public void testMissingException() {
        ArrayList emptyList = Lists.newArrayList();
        IteratorTester<Integer> tester = new IteratorTester<Integer>(1, (Iterable)IteratorFeature.MODIFIABLE, (Iterable)emptyList, AbstractIteratorTester.KnownOrder.KNOWN_ORDER){

            protected Iterator<Integer> newTargetIterator() {
                return new Iterator<Integer>(){

                    @Override
                    public void remove() {
                    }

                    @Override
                    public Integer next() {
                        return null;
                    }

                    @Override
                    public boolean hasNext() {
                        return false;
                    }
                };
            }
        };
        IteratorTesterTest.assertFailure(tester);
    }

    public void testUnexpectedException() {
        IteratorTester<Integer> tester = new IteratorTester<Integer>(1, (Iterable)IteratorFeature.MODIFIABLE, (Iterable)Lists.newArrayList((Object[])new Integer[]{1}), AbstractIteratorTester.KnownOrder.KNOWN_ORDER){

            protected Iterator<Integer> newTargetIterator() {
                return new ThrowingIterator<Integer>(new IllegalStateException());
            }
        };
        IteratorTesterTest.assertFailure(tester);
    }

    public void testSimilarException() {
        List emptyList = Collections.emptyList();
        IteratorTester<Integer> tester = new IteratorTester<Integer>(1, (Iterable)IteratorFeature.MODIFIABLE, emptyList, AbstractIteratorTester.KnownOrder.KNOWN_ORDER){

            protected Iterator<Integer> newTargetIterator() {
                return new Iterator<Integer>(){

                    @Override
                    public void remove() {
                        throw new IllegalStateException(){};
                    }

                    @Override
                    public Integer next() {
                        throw new NoSuchElementException(){};
                    }

                    @Override
                    public boolean hasNext() {
                        return false;
                    }
                };
            }
        };
        tester.test();
    }

    public void testMismatchedException() {
        List emptyList = Collections.emptyList();
        IteratorTester<Integer> tester = new IteratorTester<Integer>(1, (Iterable)IteratorFeature.MODIFIABLE, emptyList, AbstractIteratorTester.KnownOrder.KNOWN_ORDER){

            protected Iterator<Integer> newTargetIterator() {
                return new Iterator<Integer>(){

                    @Override
                    public void remove() {
                        throw new IllegalArgumentException();
                    }

                    @Override
                    public Integer next() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public boolean hasNext() {
                        return false;
                    }
                };
            }
        };
        IteratorTesterTest.assertFailure(tester);
    }

    private static void assertFailure(IteratorTester<?> tester) {
        try {
            tester.test();
            IteratorTesterTest.fail();
        }
        catch (AssertionFailedError assertionFailedError) {
            // empty catch block
        }
    }

    private static final class ThrowingIterator<E>
    implements Iterator<E> {
        private final RuntimeException ex;

        private ThrowingIterator(RuntimeException ex) {
            this.ex = ex;
        }

        @Override
        public boolean hasNext() {
            return true;
        }

        @Override
        public E next() {
            this.ex.fillInStackTrace();
            throw this.ex;
        }

        @Override
        public void remove() {
            this.ex.fillInStackTrace();
            throw this.ex;
        }
    }

    static class TesterThatCountsCalls
    extends IteratorTester<Integer> {
        int numCallsToNewTargetIterator;
        int numCallsToVerify;

        TesterThatCountsCalls() {
            super(3, (Iterable)IteratorFeature.MODIFIABLE, (Iterable)Lists.newArrayList((Object[])new Integer[]{1}), AbstractIteratorTester.KnownOrder.KNOWN_ORDER);
        }

        protected Iterator<Integer> newTargetIterator() {
            ++this.numCallsToNewTargetIterator;
            return Lists.newArrayList((Object[])new Integer[]{1}).iterator();
        }

        protected void verify(List<Integer> elements) {
            ++this.numCallsToVerify;
            super.verify(elements);
        }
    }

    static class IteratorWithSunJavaBug6529795<T>
    implements Iterator<T> {
        Iterator<T> iterator;
        boolean nextThrewException;

        IteratorWithSunJavaBug6529795(Iterator<T> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public T next() {
            try {
                return this.iterator.next();
            }
            catch (NoSuchElementException e) {
                this.nextThrewException = true;
                throw e;
            }
        }

        @Override
        public void remove() {
            if (this.nextThrewException) {
                throw new IllegalStateException();
            }
            this.iterator.remove();
        }
    }
}

