/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.testing.MapTestSuiteBuilder;
import com.google.common.collect.testing.TestMapGenerator;
import com.google.common.collect.testing.TestStringMapGenerator;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.Feature;
import com.google.common.collect.testing.features.MapFeature;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public final class MapTestSuiteBuilderTests
extends TestCase {
    private MapTestSuiteBuilderTests() {
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(MapTestSuiteBuilderTests.class.getSimpleName());
        suite.addTest(MapTestSuiteBuilderTests.testsForHashMapNullKeysForbidden());
        suite.addTest(MapTestSuiteBuilderTests.testsForHashMapNullValuesForbidden());
        return suite;
    }

    private static TestSuite wrappedHashMapTests(WrappedHashMapGenerator generator, String name, Feature<?> ... features) {
        ArrayList featuresList = Lists.newArrayList((Object[])features);
        Collections.addAll(featuresList, MapFeature.GENERAL_PURPOSE, CollectionFeature.SUPPORTS_ITERATOR_REMOVE, CollectionSize.ANY);
        return ((MapTestSuiteBuilder)((MapTestSuiteBuilder)MapTestSuiteBuilder.using((TestMapGenerator)generator).named(name)).withFeatures((Iterable)featuresList)).createTestSuite();
    }

    private static Test testsForHashMapNullKeysForbidden() {
        return MapTestSuiteBuilderTests.wrappedHashMapTests(new WrappedHashMapGenerator(){

            @Override
            Map<String, String> wrap(final HashMap<String, String> map) {
                if (map.containsKey(null)) {
                    throw new NullPointerException();
                }
                return new AbstractMap<String, String>(){

                    @Override
                    public Set<Map.Entry<String, String>> entrySet() {
                        return map.entrySet();
                    }

                    @Override
                    public String put(String key, String value) {
                        Preconditions.checkNotNull((Object)key);
                        return map.put(key, value);
                    }
                };
            }
        }, "HashMap w/out null keys", new Feature[]{MapFeature.ALLOWS_NULL_VALUES});
    }

    private static Test testsForHashMapNullValuesForbidden() {
        return MapTestSuiteBuilderTests.wrappedHashMapTests(new WrappedHashMapGenerator(){

            @Override
            Map<String, String> wrap(final HashMap<String, String> map) {
                if (map.containsValue(null)) {
                    throw new NullPointerException();
                }
                return new AbstractMap<String, String>(){

                    @Override
                    public Set<Map.Entry<String, String>> entrySet() {
                        return map.entrySet();
                    }

                    @Override
                    public String put(String key, String value) {
                        Preconditions.checkNotNull((Object)value);
                        return map.put(key, value);
                    }
                };
            }
        }, "HashMap w/out null values", new Feature[]{MapFeature.ALLOWS_NULL_KEYS});
    }

    private static abstract class WrappedHashMapGenerator
    extends TestStringMapGenerator {
        private WrappedHashMapGenerator() {
        }

        protected final Map<String, String> create(Map.Entry<String, String>[] entries) {
            HashMap map = Maps.newHashMap();
            for (Map.Entry<String, String> entry : entries) {
                map.put(entry.getKey(), entry.getValue());
            }
            return this.wrap(map);
        }

        abstract Map<String, String> wrap(HashMap<String, String> var1);
    }
}

