/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent.testing;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableScheduledFuture;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.common.util.concurrent.testing.TestingExecutors;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;

public class TestingExecutorsTest
extends TestCase {
    private volatile boolean taskDone;

    public void testNoOpScheduledExecutor() throws InterruptedException {
        this.taskDone = false;
        Runnable task = new Runnable(){

            @Override
            public void run() {
                TestingExecutorsTest.this.taskDone = true;
            }
        };
        ListenableScheduledFuture future = TestingExecutors.noOpScheduledExecutor().schedule(task, 10L, TimeUnit.MILLISECONDS);
        Thread.sleep(20L);
        TestingExecutorsTest.assertFalse((boolean)this.taskDone);
        TestingExecutorsTest.assertFalse((boolean)future.isDone());
    }

    public void testNoOpScheduledExecutorShutdown() {
        ListeningScheduledExecutorService executor = TestingExecutors.noOpScheduledExecutor();
        TestingExecutorsTest.assertFalse((boolean)executor.isShutdown());
        TestingExecutorsTest.assertFalse((boolean)executor.isTerminated());
        executor.shutdown();
        TestingExecutorsTest.assertTrue((boolean)executor.isShutdown());
        TestingExecutorsTest.assertTrue((boolean)executor.isTerminated());
    }

    public void testNoOpScheduledExecutorInvokeAll() throws ExecutionException, InterruptedException {
        ListeningScheduledExecutorService executor = TestingExecutors.noOpScheduledExecutor();
        this.taskDone = false;
        Callable<Boolean> task = new Callable<Boolean>(){

            @Override
            public Boolean call() {
                TestingExecutorsTest.this.taskDone = true;
                return TestingExecutorsTest.this.taskDone;
            }
        };
        List futureList = executor.invokeAll((Collection)ImmutableList.of((Object)task), 10L, TimeUnit.MILLISECONDS);
        Future future = (Future)futureList.get(0);
        TestingExecutorsTest.assertFalse((boolean)this.taskDone);
        TestingExecutorsTest.assertTrue((boolean)future.isDone());
        try {
            future.get();
            TestingExecutorsTest.fail();
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
    }

    public void testSameThreadScheduledExecutor() throws ExecutionException, InterruptedException {
        this.taskDone = false;
        Callable<Integer> task = new Callable<Integer>(){

            @Override
            public Integer call() {
                TestingExecutorsTest.this.taskDone = true;
                return 6;
            }
        };
        ListenableScheduledFuture future = TestingExecutors.sameThreadScheduledExecutor().schedule((Callable)task, 10000L, TimeUnit.MILLISECONDS);
        TestingExecutorsTest.assertTrue((String)"Should run callable immediately", (boolean)this.taskDone);
        TestingExecutorsTest.assertEquals((int)6, (int)((Integer)future.get()));
    }

    public void testSameThreadScheduledExecutorWithException() throws InterruptedException {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                throw new RuntimeException("Oh no!");
            }
        };
        ListenableFuture future = TestingExecutors.sameThreadScheduledExecutor().submit(runnable);
        try {
            future.get();
            TestingExecutorsTest.fail((String)"Should have thrown exception");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }
}

