/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.google;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.BoundType;
import com.google.common.collect.Iterators;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.common.collect.SortedMultiset;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.OneSizeTestContainerGenerator;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.google.AbstractMultisetTester;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;

@GwtCompatible
public class MultisetNavigationTester<E>
extends AbstractMultisetTester<E> {
    private SortedMultiset<E> sortedMultiset;
    private List<E> entries;
    private Multiset.Entry<E> a;
    private Multiset.Entry<E> b;
    private Multiset.Entry<E> c;

    static <T> SortedMultiset<T> cast(Multiset<T> iterable) {
        return (SortedMultiset)iterable;
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.sortedMultiset = MultisetNavigationTester.cast(this.getMultiset());
        this.entries = Helpers.copyToList(((OneSizeTestContainerGenerator)this.getSubjectGenerator()).getSampleElements(((OneSizeTestContainerGenerator)this.getSubjectGenerator()).getCollectionSize().getNumElements()));
        Collections.sort(this.entries, this.sortedMultiset.comparator());
        if (this.entries.size() >= 1) {
            this.a = Multisets.immutableEntry(this.entries.get(0), (int)this.sortedMultiset.count(this.entries.get(0)));
            if (this.entries.size() >= 3) {
                this.b = Multisets.immutableEntry(this.entries.get(1), (int)this.sortedMultiset.count(this.entries.get(1)));
                this.c = Multisets.immutableEntry(this.entries.get(2), (int)this.sortedMultiset.count(this.entries.get(2)));
            }
        }
    }

    private void resetWithHole() {
        ArrayList<Object> container = new ArrayList<Object>();
        container.addAll(Collections.nCopies(this.a.getCount(), this.a.getElement()));
        container.addAll(Collections.nCopies(this.c.getCount(), this.c.getElement()));
        super.resetContainer((Collection)((OneSizeTestContainerGenerator)this.getSubjectGenerator()).create(container.toArray()));
        this.sortedMultiset = (SortedMultiset)this.getMultiset();
    }

    @CollectionSize.Require(value={CollectionSize.ZERO})
    public void testEmptyMultisetFirst() {
        MultisetNavigationTester.assertNull((Object)this.sortedMultiset.firstEntry());
        try {
            this.sortedMultiset.elementSet().first();
            MultisetNavigationTester.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(value={CollectionSize.ZERO})
    public void testEmptyMultisetPollFirst() {
        MultisetNavigationTester.assertNull((Object)this.sortedMultiset.pollFirstEntry());
    }

    @CollectionSize.Require(value={CollectionSize.ZERO})
    public void testEmptyMultisetNearby() {
        for (BoundType type : BoundType.values()) {
            MultisetNavigationTester.assertNull((Object)this.sortedMultiset.headMultiset(this.e0(), type).lastEntry());
            MultisetNavigationTester.assertNull((Object)this.sortedMultiset.tailMultiset(this.e0(), type).firstEntry());
        }
    }

    @CollectionSize.Require(value={CollectionSize.ZERO})
    public void testEmptyMultisetLast() {
        MultisetNavigationTester.assertNull((Object)this.sortedMultiset.lastEntry());
        try {
            MultisetNavigationTester.assertNull(this.sortedMultiset.elementSet().last());
            MultisetNavigationTester.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(value={CollectionSize.ZERO})
    public void testEmptyMultisetPollLast() {
        MultisetNavigationTester.assertNull((Object)this.sortedMultiset.pollLastEntry());
    }

    @CollectionSize.Require(value={CollectionSize.ONE})
    public void testSingletonMultisetFirst() {
        MultisetNavigationTester.assertEquals(this.a, (Object)this.sortedMultiset.firstEntry());
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(value={CollectionSize.ONE})
    public void testSingletonMultisetPollFirst() {
        MultisetNavigationTester.assertEquals(this.a, (Object)this.sortedMultiset.pollFirstEntry());
        MultisetNavigationTester.assertTrue((boolean)this.sortedMultiset.isEmpty());
    }

    @CollectionSize.Require(value={CollectionSize.ONE})
    public void testSingletonMultisetNearby() {
        MultisetNavigationTester.assertNull((Object)this.sortedMultiset.headMultiset(this.e0(), BoundType.OPEN).lastEntry());
        MultisetNavigationTester.assertNull((Object)this.sortedMultiset.tailMultiset(this.e0(), BoundType.OPEN).lastEntry());
        MultisetNavigationTester.assertEquals(this.a, (Object)this.sortedMultiset.headMultiset(this.e0(), BoundType.CLOSED).lastEntry());
        MultisetNavigationTester.assertEquals(this.a, (Object)this.sortedMultiset.tailMultiset(this.e0(), BoundType.CLOSED).firstEntry());
    }

    @CollectionSize.Require(value={CollectionSize.ONE})
    public void testSingletonMultisetLast() {
        MultisetNavigationTester.assertEquals(this.a, (Object)this.sortedMultiset.lastEntry());
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(value={CollectionSize.ONE})
    public void testSingletonMultisetPollLast() {
        MultisetNavigationTester.assertEquals(this.a, (Object)this.sortedMultiset.pollLastEntry());
        MultisetNavigationTester.assertTrue((boolean)this.sortedMultiset.isEmpty());
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    public void testFirst() {
        MultisetNavigationTester.assertEquals(this.a, (Object)this.sortedMultiset.firstEntry());
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    public void testPollFirst() {
        MultisetNavigationTester.assertEquals(this.a, (Object)this.sortedMultiset.pollFirstEntry());
        MultisetNavigationTester.assertEquals(Arrays.asList(this.b, this.c), Helpers.copyToList(this.sortedMultiset.entrySet()));
    }

    @CollectionFeature.Require(absent={CollectionFeature.SUPPORTS_REMOVE})
    public void testPollFirstUnsupported() {
        try {
            this.sortedMultiset.pollFirstEntry();
            MultisetNavigationTester.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    public void testLower() {
        this.resetWithHole();
        MultisetNavigationTester.assertEquals(null, (Object)this.sortedMultiset.headMultiset(this.a.getElement(), BoundType.OPEN).lastEntry());
        MultisetNavigationTester.assertEquals(this.a, (Object)this.sortedMultiset.headMultiset(this.b.getElement(), BoundType.OPEN).lastEntry());
        MultisetNavigationTester.assertEquals(this.a, (Object)this.sortedMultiset.headMultiset(this.c.getElement(), BoundType.OPEN).lastEntry());
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    public void testFloor() {
        this.resetWithHole();
        MultisetNavigationTester.assertEquals(this.a, (Object)this.sortedMultiset.headMultiset(this.a.getElement(), BoundType.CLOSED).lastEntry());
        MultisetNavigationTester.assertEquals(this.a, (Object)this.sortedMultiset.headMultiset(this.b.getElement(), BoundType.CLOSED).lastEntry());
        MultisetNavigationTester.assertEquals(this.c, (Object)this.sortedMultiset.headMultiset(this.c.getElement(), BoundType.CLOSED).lastEntry());
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    public void testCeiling() {
        this.resetWithHole();
        MultisetNavigationTester.assertEquals(this.a, (Object)this.sortedMultiset.tailMultiset(this.a.getElement(), BoundType.CLOSED).firstEntry());
        MultisetNavigationTester.assertEquals(this.c, (Object)this.sortedMultiset.tailMultiset(this.b.getElement(), BoundType.CLOSED).firstEntry());
        MultisetNavigationTester.assertEquals(this.c, (Object)this.sortedMultiset.tailMultiset(this.c.getElement(), BoundType.CLOSED).firstEntry());
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    public void testHigher() {
        this.resetWithHole();
        MultisetNavigationTester.assertEquals(this.c, (Object)this.sortedMultiset.tailMultiset(this.a.getElement(), BoundType.OPEN).firstEntry());
        MultisetNavigationTester.assertEquals(this.c, (Object)this.sortedMultiset.tailMultiset(this.b.getElement(), BoundType.OPEN).firstEntry());
        MultisetNavigationTester.assertEquals(null, (Object)this.sortedMultiset.tailMultiset(this.c.getElement(), BoundType.OPEN).firstEntry());
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    public void testLast() {
        MultisetNavigationTester.assertEquals(this.c, (Object)this.sortedMultiset.lastEntry());
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    public void testPollLast() {
        MultisetNavigationTester.assertEquals(this.c, (Object)this.sortedMultiset.pollLastEntry());
        MultisetNavigationTester.assertEquals(Arrays.asList(this.a, this.b), Helpers.copyToList(this.sortedMultiset.entrySet()));
    }

    @CollectionFeature.Require(absent={CollectionFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    public void testPollLastUnsupported() {
        try {
            this.sortedMultiset.pollLastEntry();
            MultisetNavigationTester.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    public void testDescendingNavigation() {
        ArrayList ascending = new ArrayList();
        Iterators.addAll(ascending, this.sortedMultiset.entrySet().iterator());
        ArrayList descending = new ArrayList();
        Iterators.addAll(descending, this.sortedMultiset.descendingMultiset().entrySet().iterator());
        Collections.reverse(descending);
        MultisetNavigationTester.assertEquals(ascending, descending);
    }

    void expectAddFailure(SortedMultiset<E> multiset, Multiset.Entry<E> entry) {
        try {
            multiset.add(entry.getElement(), entry.getCount());
            MultisetNavigationTester.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            multiset.add(entry.getElement());
            MultisetNavigationTester.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            multiset.addAll(Collections.singletonList(entry.getElement()));
            MultisetNavigationTester.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    void expectRemoveZero(SortedMultiset<E> multiset, Multiset.Entry<E> entry) {
        MultisetNavigationTester.assertEquals((int)0, (int)multiset.remove(entry.getElement(), entry.getCount()));
        MultisetNavigationTester.assertFalse((boolean)multiset.remove(entry.getElement()));
        MultisetNavigationTester.assertFalse((boolean)multiset.elementSet().remove(entry.getElement()));
    }

    void expectSetCountFailure(SortedMultiset<E> multiset, Multiset.Entry<E> entry) {
        try {
            multiset.setCount(entry.getElement(), multiset.count(entry.getElement()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            multiset.setCount(entry.getElement(), multiset.count(entry.getElement()) + 1);
            MultisetNavigationTester.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @CollectionSize.Require(value={CollectionSize.ONE})
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ADD})
    public void testAddOutOfTailBoundsOne() {
        this.expectAddFailure(this.sortedMultiset.tailMultiset(this.a.getElement(), BoundType.OPEN), this.a);
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ADD})
    public void testAddOutOfTailBoundsSeveral() {
        this.expectAddFailure(this.sortedMultiset.tailMultiset(this.a.getElement(), BoundType.OPEN), this.a);
        this.expectAddFailure(this.sortedMultiset.tailMultiset(this.b.getElement(), BoundType.CLOSED), this.a);
        this.expectAddFailure(this.sortedMultiset.tailMultiset(this.b.getElement(), BoundType.OPEN), this.a);
        this.expectAddFailure(this.sortedMultiset.tailMultiset(this.b.getElement(), BoundType.OPEN), this.b);
        this.expectAddFailure(this.sortedMultiset.tailMultiset(this.c.getElement(), BoundType.CLOSED), this.a);
        this.expectAddFailure(this.sortedMultiset.tailMultiset(this.c.getElement(), BoundType.CLOSED), this.b);
        this.expectAddFailure(this.sortedMultiset.tailMultiset(this.c.getElement(), BoundType.OPEN), this.a);
        this.expectAddFailure(this.sortedMultiset.tailMultiset(this.c.getElement(), BoundType.OPEN), this.b);
        this.expectAddFailure(this.sortedMultiset.tailMultiset(this.c.getElement(), BoundType.OPEN), this.c);
    }

    @CollectionSize.Require(value={CollectionSize.ONE})
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ADD})
    public void testAddOutOfHeadBoundsOne() {
        this.expectAddFailure(this.sortedMultiset.headMultiset(this.a.getElement(), BoundType.OPEN), this.a);
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ADD})
    public void testAddOutOfHeadBoundsSeveral() {
        this.expectAddFailure(this.sortedMultiset.headMultiset(this.c.getElement(), BoundType.OPEN), this.c);
        this.expectAddFailure(this.sortedMultiset.headMultiset(this.b.getElement(), BoundType.CLOSED), this.c);
        this.expectAddFailure(this.sortedMultiset.headMultiset(this.b.getElement(), BoundType.OPEN), this.c);
        this.expectAddFailure(this.sortedMultiset.headMultiset(this.b.getElement(), BoundType.OPEN), this.b);
        this.expectAddFailure(this.sortedMultiset.headMultiset(this.a.getElement(), BoundType.CLOSED), this.c);
        this.expectAddFailure(this.sortedMultiset.headMultiset(this.a.getElement(), BoundType.CLOSED), this.b);
        this.expectAddFailure(this.sortedMultiset.headMultiset(this.a.getElement(), BoundType.OPEN), this.c);
        this.expectAddFailure(this.sortedMultiset.headMultiset(this.a.getElement(), BoundType.OPEN), this.b);
        this.expectAddFailure(this.sortedMultiset.headMultiset(this.a.getElement(), BoundType.OPEN), this.a);
    }

    @CollectionSize.Require(value={CollectionSize.ONE})
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    public void testRemoveOutOfTailBoundsOne() {
        this.expectRemoveZero(this.sortedMultiset.tailMultiset(this.a.getElement(), BoundType.OPEN), this.a);
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    public void testRemoveOutOfTailBoundsSeveral() {
        this.expectRemoveZero(this.sortedMultiset.tailMultiset(this.a.getElement(), BoundType.OPEN), this.a);
        this.expectRemoveZero(this.sortedMultiset.tailMultiset(this.b.getElement(), BoundType.CLOSED), this.a);
        this.expectRemoveZero(this.sortedMultiset.tailMultiset(this.b.getElement(), BoundType.OPEN), this.a);
        this.expectRemoveZero(this.sortedMultiset.tailMultiset(this.b.getElement(), BoundType.OPEN), this.b);
        this.expectRemoveZero(this.sortedMultiset.tailMultiset(this.c.getElement(), BoundType.CLOSED), this.a);
        this.expectRemoveZero(this.sortedMultiset.tailMultiset(this.c.getElement(), BoundType.CLOSED), this.b);
        this.expectRemoveZero(this.sortedMultiset.tailMultiset(this.c.getElement(), BoundType.OPEN), this.a);
        this.expectRemoveZero(this.sortedMultiset.tailMultiset(this.c.getElement(), BoundType.OPEN), this.b);
        this.expectRemoveZero(this.sortedMultiset.tailMultiset(this.c.getElement(), BoundType.OPEN), this.c);
    }

    @CollectionSize.Require(value={CollectionSize.ONE})
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    public void testRemoveOutOfHeadBoundsOne() {
        this.expectRemoveZero(this.sortedMultiset.headMultiset(this.a.getElement(), BoundType.OPEN), this.a);
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    public void testRemoveOutOfHeadBoundsSeveral() {
        this.expectRemoveZero(this.sortedMultiset.headMultiset(this.c.getElement(), BoundType.OPEN), this.c);
        this.expectRemoveZero(this.sortedMultiset.headMultiset(this.b.getElement(), BoundType.CLOSED), this.c);
        this.expectRemoveZero(this.sortedMultiset.headMultiset(this.b.getElement(), BoundType.OPEN), this.c);
        this.expectRemoveZero(this.sortedMultiset.headMultiset(this.b.getElement(), BoundType.OPEN), this.b);
        this.expectRemoveZero(this.sortedMultiset.headMultiset(this.a.getElement(), BoundType.CLOSED), this.c);
        this.expectRemoveZero(this.sortedMultiset.headMultiset(this.a.getElement(), BoundType.CLOSED), this.b);
        this.expectRemoveZero(this.sortedMultiset.headMultiset(this.a.getElement(), BoundType.OPEN), this.c);
        this.expectRemoveZero(this.sortedMultiset.headMultiset(this.a.getElement(), BoundType.OPEN), this.b);
        this.expectRemoveZero(this.sortedMultiset.headMultiset(this.a.getElement(), BoundType.OPEN), this.a);
    }

    @CollectionSize.Require(value={CollectionSize.ONE})
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ADD, CollectionFeature.SUPPORTS_REMOVE})
    public void testSetCountOutOfTailBoundsOne() {
        this.expectSetCountFailure(this.sortedMultiset.tailMultiset(this.a.getElement(), BoundType.OPEN), this.a);
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ADD, CollectionFeature.SUPPORTS_REMOVE})
    public void testSetCountOutOfTailBoundsSeveral() {
        this.expectSetCountFailure(this.sortedMultiset.tailMultiset(this.a.getElement(), BoundType.OPEN), this.a);
        this.expectSetCountFailure(this.sortedMultiset.tailMultiset(this.b.getElement(), BoundType.CLOSED), this.a);
        this.expectSetCountFailure(this.sortedMultiset.tailMultiset(this.b.getElement(), BoundType.OPEN), this.a);
        this.expectSetCountFailure(this.sortedMultiset.tailMultiset(this.b.getElement(), BoundType.OPEN), this.b);
        this.expectSetCountFailure(this.sortedMultiset.tailMultiset(this.c.getElement(), BoundType.CLOSED), this.a);
        this.expectSetCountFailure(this.sortedMultiset.tailMultiset(this.c.getElement(), BoundType.CLOSED), this.b);
        this.expectSetCountFailure(this.sortedMultiset.tailMultiset(this.c.getElement(), BoundType.OPEN), this.a);
        this.expectSetCountFailure(this.sortedMultiset.tailMultiset(this.c.getElement(), BoundType.OPEN), this.b);
        this.expectSetCountFailure(this.sortedMultiset.tailMultiset(this.c.getElement(), BoundType.OPEN), this.c);
    }

    @CollectionSize.Require(value={CollectionSize.ONE})
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ADD, CollectionFeature.SUPPORTS_REMOVE})
    public void testSetCountOutOfHeadBoundsOne() {
        this.expectSetCountFailure(this.sortedMultiset.headMultiset(this.a.getElement(), BoundType.OPEN), this.a);
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ADD, CollectionFeature.SUPPORTS_REMOVE})
    public void testSetCountOutOfHeadBoundsSeveral() {
        this.expectSetCountFailure(this.sortedMultiset.headMultiset(this.c.getElement(), BoundType.OPEN), this.c);
        this.expectSetCountFailure(this.sortedMultiset.headMultiset(this.b.getElement(), BoundType.CLOSED), this.c);
        this.expectSetCountFailure(this.sortedMultiset.headMultiset(this.b.getElement(), BoundType.OPEN), this.c);
        this.expectSetCountFailure(this.sortedMultiset.headMultiset(this.b.getElement(), BoundType.OPEN), this.b);
        this.expectSetCountFailure(this.sortedMultiset.headMultiset(this.a.getElement(), BoundType.CLOSED), this.c);
        this.expectSetCountFailure(this.sortedMultiset.headMultiset(this.a.getElement(), BoundType.CLOSED), this.b);
        this.expectSetCountFailure(this.sortedMultiset.headMultiset(this.a.getElement(), BoundType.OPEN), this.c);
        this.expectSetCountFailure(this.sortedMultiset.headMultiset(this.a.getElement(), BoundType.OPEN), this.b);
        this.expectSetCountFailure(this.sortedMultiset.headMultiset(this.a.getElement(), BoundType.OPEN), this.a);
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ADD})
    public void testAddWithConflictingBounds() {
        this.testEmptyRangeSubMultisetSupportingAdd(this.sortedMultiset.subMultiset(this.a.getElement(), BoundType.CLOSED, this.a.getElement(), BoundType.OPEN));
        this.testEmptyRangeSubMultisetSupportingAdd(this.sortedMultiset.subMultiset(this.a.getElement(), BoundType.OPEN, this.a.getElement(), BoundType.OPEN));
        this.testEmptyRangeSubMultisetSupportingAdd(this.sortedMultiset.subMultiset(this.a.getElement(), BoundType.OPEN, this.a.getElement(), BoundType.CLOSED));
        this.testEmptyRangeSubMultisetSupportingAdd(this.sortedMultiset.subMultiset(this.b.getElement(), BoundType.CLOSED, this.a.getElement(), BoundType.CLOSED));
        this.testEmptyRangeSubMultisetSupportingAdd(this.sortedMultiset.subMultiset(this.b.getElement(), BoundType.CLOSED, this.a.getElement(), BoundType.OPEN));
        this.testEmptyRangeSubMultisetSupportingAdd(this.sortedMultiset.subMultiset(this.b.getElement(), BoundType.OPEN, this.a.getElement(), BoundType.OPEN));
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ADD})
    public void testConflictingBounds() {
        this.testEmptyRangeSubMultiset(this.sortedMultiset.subMultiset(this.a.getElement(), BoundType.CLOSED, this.a.getElement(), BoundType.OPEN));
        this.testEmptyRangeSubMultiset(this.sortedMultiset.subMultiset(this.a.getElement(), BoundType.OPEN, this.a.getElement(), BoundType.OPEN));
        this.testEmptyRangeSubMultiset(this.sortedMultiset.subMultiset(this.a.getElement(), BoundType.OPEN, this.a.getElement(), BoundType.CLOSED));
        this.testEmptyRangeSubMultiset(this.sortedMultiset.subMultiset(this.b.getElement(), BoundType.CLOSED, this.a.getElement(), BoundType.CLOSED));
        this.testEmptyRangeSubMultiset(this.sortedMultiset.subMultiset(this.b.getElement(), BoundType.CLOSED, this.a.getElement(), BoundType.OPEN));
        this.testEmptyRangeSubMultiset(this.sortedMultiset.subMultiset(this.b.getElement(), BoundType.OPEN, this.a.getElement(), BoundType.OPEN));
    }

    public void testEmptyRangeSubMultiset(SortedMultiset<E> multiset) {
        MultisetNavigationTester.assertTrue((boolean)multiset.isEmpty());
        MultisetNavigationTester.assertEquals((int)0, (int)multiset.size());
        MultisetNavigationTester.assertEquals((int)0, (int)multiset.toArray().length);
        MultisetNavigationTester.assertTrue((boolean)multiset.entrySet().isEmpty());
        MultisetNavigationTester.assertFalse((boolean)multiset.iterator().hasNext());
        MultisetNavigationTester.assertEquals((int)0, (int)multiset.entrySet().size());
        MultisetNavigationTester.assertEquals((int)0, (int)multiset.entrySet().toArray().length);
        MultisetNavigationTester.assertFalse((boolean)multiset.entrySet().iterator().hasNext());
    }

    public void testEmptyRangeSubMultisetSupportingAdd(SortedMultiset<E> multiset) {
        for (Multiset.Entry entry : Arrays.asList(this.a, this.b, this.c)) {
            this.expectAddFailure(multiset, entry);
        }
    }

    private static int totalSize(Iterable<? extends Multiset.Entry<?>> entries) {
        int sum = 0;
        for (Multiset.Entry<?> entry : entries) {
            sum += entry.getCount();
        }
        return sum;
    }

    private void testSubMultisetEntrySet(SubMultisetSpec spec) {
        List entries = Helpers.copyToList(this.sortedMultiset.entrySet());
        for (int i = 0; i < entries.size(); ++i) {
            List expected = spec.expectedEntries(i, entries);
            SortedMultiset<E> subMultiset = spec.subMultiset(this.sortedMultiset, entries, i);
            MultisetNavigationTester.assertEquals(expected, Helpers.copyToList(subMultiset.entrySet()));
        }
    }

    private void testSubMultisetSize(SubMultisetSpec spec) {
        List entries = Helpers.copyToList(this.sortedMultiset.entrySet());
        for (int i = 0; i < entries.size(); ++i) {
            List expected = spec.expectedEntries(i, entries);
            SortedMultiset<E> subMultiset = spec.subMultiset(this.sortedMultiset, entries, i);
            MultisetNavigationTester.assertEquals((int)MultisetNavigationTester.totalSize(expected), (int)subMultiset.size());
        }
    }

    private void testSubMultisetDistinctElements(SubMultisetSpec spec) {
        List entries = Helpers.copyToList(this.sortedMultiset.entrySet());
        for (int i = 0; i < entries.size(); ++i) {
            List expected = spec.expectedEntries(i, entries);
            SortedMultiset<E> subMultiset = spec.subMultiset(this.sortedMultiset, entries, i);
            MultisetNavigationTester.assertEquals((int)expected.size(), (int)subMultiset.entrySet().size());
            MultisetNavigationTester.assertEquals((int)expected.size(), (int)subMultiset.elementSet().size());
        }
    }

    public void testTailClosedEntrySet() {
        this.testSubMultisetEntrySet(SubMultisetSpec.TAIL_CLOSED);
    }

    public void testTailClosedSize() {
        this.testSubMultisetSize(SubMultisetSpec.TAIL_CLOSED);
    }

    public void testTailClosedDistinctElements() {
        this.testSubMultisetDistinctElements(SubMultisetSpec.TAIL_CLOSED);
    }

    public void testTailOpenEntrySet() {
        this.testSubMultisetEntrySet(SubMultisetSpec.TAIL_OPEN);
    }

    public void testTailOpenSize() {
        this.testSubMultisetSize(SubMultisetSpec.TAIL_OPEN);
    }

    public void testTailOpenDistinctElements() {
        this.testSubMultisetDistinctElements(SubMultisetSpec.TAIL_OPEN);
    }

    public void testHeadClosedEntrySet() {
        this.testSubMultisetEntrySet(SubMultisetSpec.HEAD_CLOSED);
    }

    public void testHeadClosedSize() {
        this.testSubMultisetSize(SubMultisetSpec.HEAD_CLOSED);
    }

    public void testHeadClosedDistinctElements() {
        this.testSubMultisetDistinctElements(SubMultisetSpec.HEAD_CLOSED);
    }

    public void testHeadOpenEntrySet() {
        this.testSubMultisetEntrySet(SubMultisetSpec.HEAD_OPEN);
    }

    public void testHeadOpenSize() {
        this.testSubMultisetSize(SubMultisetSpec.HEAD_OPEN);
    }

    public void testHeadOpenDistinctElements() {
        this.testSubMultisetDistinctElements(SubMultisetSpec.HEAD_OPEN);
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    public void testClearTailOpen() {
        List expected = Helpers.copyToList(this.sortedMultiset.headMultiset(this.b.getElement(), BoundType.CLOSED).entrySet());
        this.sortedMultiset.tailMultiset(this.b.getElement(), BoundType.OPEN).clear();
        MultisetNavigationTester.assertEquals(expected, Helpers.copyToList(this.sortedMultiset.entrySet()));
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    public void testClearTailOpenEntrySet() {
        List expected = Helpers.copyToList(this.sortedMultiset.headMultiset(this.b.getElement(), BoundType.CLOSED).entrySet());
        this.sortedMultiset.tailMultiset(this.b.getElement(), BoundType.OPEN).entrySet().clear();
        MultisetNavigationTester.assertEquals(expected, Helpers.copyToList(this.sortedMultiset.entrySet()));
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    public void testClearTailClosed() {
        List expected = Helpers.copyToList(this.sortedMultiset.headMultiset(this.b.getElement(), BoundType.OPEN).entrySet());
        this.sortedMultiset.tailMultiset(this.b.getElement(), BoundType.CLOSED).clear();
        MultisetNavigationTester.assertEquals(expected, Helpers.copyToList(this.sortedMultiset.entrySet()));
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    public void testClearTailClosedEntrySet() {
        List expected = Helpers.copyToList(this.sortedMultiset.headMultiset(this.b.getElement(), BoundType.OPEN).entrySet());
        this.sortedMultiset.tailMultiset(this.b.getElement(), BoundType.CLOSED).entrySet().clear();
        MultisetNavigationTester.assertEquals(expected, Helpers.copyToList(this.sortedMultiset.entrySet()));
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    public void testClearHeadOpen() {
        List expected = Helpers.copyToList(this.sortedMultiset.tailMultiset(this.b.getElement(), BoundType.CLOSED).entrySet());
        this.sortedMultiset.headMultiset(this.b.getElement(), BoundType.OPEN).clear();
        MultisetNavigationTester.assertEquals(expected, Helpers.copyToList(this.sortedMultiset.entrySet()));
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    public void testClearHeadOpenEntrySet() {
        List expected = Helpers.copyToList(this.sortedMultiset.tailMultiset(this.b.getElement(), BoundType.CLOSED).entrySet());
        this.sortedMultiset.headMultiset(this.b.getElement(), BoundType.OPEN).entrySet().clear();
        MultisetNavigationTester.assertEquals(expected, Helpers.copyToList(this.sortedMultiset.entrySet()));
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    public void testClearHeadClosed() {
        List expected = Helpers.copyToList(this.sortedMultiset.tailMultiset(this.b.getElement(), BoundType.OPEN).entrySet());
        this.sortedMultiset.headMultiset(this.b.getElement(), BoundType.CLOSED).clear();
        MultisetNavigationTester.assertEquals(expected, Helpers.copyToList(this.sortedMultiset.entrySet()));
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    public void testClearHeadClosedEntrySet() {
        List expected = Helpers.copyToList(this.sortedMultiset.tailMultiset(this.b.getElement(), BoundType.OPEN).entrySet());
        this.sortedMultiset.headMultiset(this.b.getElement(), BoundType.CLOSED).entrySet().clear();
        MultisetNavigationTester.assertEquals(expected, Helpers.copyToList(this.sortedMultiset.entrySet()));
    }

    private static enum SubMultisetSpec {
        TAIL_CLOSED{

            @Override
            <E> List<Multiset.Entry<E>> expectedEntries(int targetEntry, List<Multiset.Entry<E>> entries) {
                return entries.subList(targetEntry, entries.size());
            }

            @Override
            <E> SortedMultiset<E> subMultiset(SortedMultiset<E> multiset, List<Multiset.Entry<E>> entries, int targetEntry) {
                return multiset.tailMultiset(entries.get(targetEntry).getElement(), BoundType.CLOSED);
            }
        }
        ,
        TAIL_OPEN{

            @Override
            <E> List<Multiset.Entry<E>> expectedEntries(int targetEntry, List<Multiset.Entry<E>> entries) {
                return entries.subList(targetEntry + 1, entries.size());
            }

            @Override
            <E> SortedMultiset<E> subMultiset(SortedMultiset<E> multiset, List<Multiset.Entry<E>> entries, int targetEntry) {
                return multiset.tailMultiset(entries.get(targetEntry).getElement(), BoundType.OPEN);
            }
        }
        ,
        HEAD_CLOSED{

            @Override
            <E> List<Multiset.Entry<E>> expectedEntries(int targetEntry, List<Multiset.Entry<E>> entries) {
                return entries.subList(0, targetEntry + 1);
            }

            @Override
            <E> SortedMultiset<E> subMultiset(SortedMultiset<E> multiset, List<Multiset.Entry<E>> entries, int targetEntry) {
                return multiset.headMultiset(entries.get(targetEntry).getElement(), BoundType.CLOSED);
            }
        }
        ,
        HEAD_OPEN{

            @Override
            <E> List<Multiset.Entry<E>> expectedEntries(int targetEntry, List<Multiset.Entry<E>> entries) {
                return entries.subList(0, targetEntry);
            }

            @Override
            <E> SortedMultiset<E> subMultiset(SortedMultiset<E> multiset, List<Multiset.Entry<E>> entries, int targetEntry) {
                return multiset.headMultiset(entries.get(targetEntry).getElement(), BoundType.OPEN);
            }
        };


        abstract <E> List<Multiset.Entry<E>> expectedEntries(int var1, List<Multiset.Entry<E>> var2);

        abstract <E> SortedMultiset<E> subMultiset(SortedMultiset<E> var1, List<Multiset.Entry<E>> var2, int var3);
    }
}

