/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.testing;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.reflect.AbstractInvocationHandler;
import com.google.common.reflect.Reflection;
import com.google.common.testing.EqualsTester;
import com.google.common.testing.FreshValueGenerator;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.Assert;

@Beta
@GwtIncompatible
public final class ForwardingWrapperTester {
    private boolean testsEquals = false;

    public ForwardingWrapperTester includingEquals() {
        this.testsEquals = true;
        return this;
    }

    public <T> void testForwarding(Class<T> interfaceType, Function<? super T, ? extends T> wrapperFunction) {
        Preconditions.checkNotNull(wrapperFunction);
        Preconditions.checkArgument((boolean)interfaceType.isInterface(), (String)"%s isn't an interface", (Object[])new Object[]{interfaceType});
        AccessibleObject[] methods = ForwardingWrapperTester.getMostConcreteMethods(interfaceType);
        AccessibleObject.setAccessible(methods, true);
        for (AccessibleObject method : methods) {
            if (!Modifier.isAbstract(((Method)method).getModifiers()) || ((Method)method).getName().equals("equals") && ((Method)method).getParameterTypes().length == 1 && ((Method)method).getParameterTypes()[0] == Object.class || ((Method)method).getName().equals("hashCode") && ((Method)method).getParameterTypes().length == 0 || ((Method)method).getName().equals("toString") && ((Method)method).getParameterTypes().length == 0) continue;
            ForwardingWrapperTester.testSuccessfulForwarding(interfaceType, (Method)method, wrapperFunction);
            ForwardingWrapperTester.testExceptionPropagation(interfaceType, (Method)method, wrapperFunction);
        }
        if (this.testsEquals) {
            ForwardingWrapperTester.testEquals(interfaceType, wrapperFunction);
        }
        ForwardingWrapperTester.testToString(interfaceType, wrapperFunction);
    }

    private static Method[] getMostConcreteMethods(Class<?> type) {
        Method[] methods = type.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            try {
                methods[i] = type.getMethod(methods[i].getName(), methods[i].getParameterTypes());
                continue;
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
        return methods;
    }

    private static <T> void testSuccessfulForwarding(Class<T> interfaceType, Method method, Function<? super T, ? extends T> wrapperFunction) {
        new InteractionTester<T>(interfaceType, method).testInteraction(wrapperFunction);
    }

    private static <T> void testExceptionPropagation(Class<T> interfaceType, Method method, Function<? super T, ? extends T> wrapperFunction) {
        final RuntimeException exception = new RuntimeException();
        Object proxy = Reflection.newProxy(interfaceType, (InvocationHandler)new AbstractInvocationHandler(){

            protected Object handleInvocation(Object p, Method m, Object[] args) throws Throwable {
                throw exception;
            }
        });
        Object wrapper = wrapperFunction.apply(proxy);
        try {
            method.invoke(wrapper, ForwardingWrapperTester.getParameterValues(method));
            Assert.fail((String)(method + " failed to throw exception as is."));
        }
        catch (InvocationTargetException e) {
            if (exception != e.getCause()) {
                throw new RuntimeException(e);
            }
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static <T> void testEquals(Class<T> interfaceType, Function<? super T, ? extends T> wrapperFunction) {
        FreshValueGenerator generator = new FreshValueGenerator();
        T instance = generator.newFreshProxy(interfaceType);
        new EqualsTester().addEqualityGroup(wrapperFunction.apply(instance), wrapperFunction.apply(instance)).addEqualityGroup(wrapperFunction.apply(generator.newFreshProxy(interfaceType))).testEquals();
    }

    private static <T> void testToString(Class<T> interfaceType, Function<? super T, ? extends T> wrapperFunction) {
        T proxy = new FreshValueGenerator().newFreshProxy(interfaceType);
        Assert.assertEquals((String)"toString() isn't properly forwarded", (String)proxy.toString(), (String)wrapperFunction.apply(proxy).toString());
    }

    private static Object[] getParameterValues(Method method) {
        FreshValueGenerator paramValues = new FreshValueGenerator();
        ArrayList passedArgs = Lists.newArrayList();
        for (Class<?> paramType : method.getParameterTypes()) {
            passedArgs.add(paramValues.generateFresh(paramType));
        }
        return passedArgs.toArray();
    }

    private static final class InteractionTester<T>
    extends AbstractInvocationHandler {
        private final Class<T> interfaceType;
        private final Method method;
        private final Object[] passedArgs;
        private final Object returnValue;
        private final AtomicInteger called = new AtomicInteger();

        InteractionTester(Class<T> interfaceType, Method method) {
            this.interfaceType = interfaceType;
            this.method = method;
            this.passedArgs = ForwardingWrapperTester.getParameterValues(method);
            this.returnValue = new FreshValueGenerator().generateFresh(method.getReturnType());
        }

        protected Object handleInvocation(Object p, Method calledMethod, Object[] args) throws Throwable {
            Assert.assertEquals((Object)this.method, (Object)calledMethod);
            Assert.assertEquals((String)(this.method + " invoked more than once."), (int)0, (int)this.called.get());
            for (int i = 0; i < this.passedArgs.length; ++i) {
                Assert.assertEquals((String)("Parameter #" + i + " of " + this.method + " not forwarded"), (Object)this.passedArgs[i], (Object)args[i]);
            }
            this.called.getAndIncrement();
            return this.returnValue;
        }

        void testInteraction(Function<? super T, ? extends T> wrapperFunction) {
            Object proxy = Reflection.newProxy(this.interfaceType, (InvocationHandler)((Object)this));
            Object wrapper = wrapperFunction.apply(proxy);
            boolean isPossibleChainingCall = this.interfaceType.isAssignableFrom(this.method.getReturnType());
            try {
                Object actualReturnValue = this.method.invoke(wrapper, this.passedArgs);
                if (!isPossibleChainingCall || wrapper != actualReturnValue) {
                    Assert.assertEquals((String)("Return value of " + this.method + " not forwarded"), (Object)this.returnValue, (Object)actualReturnValue);
                }
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw Throwables.propagate((Throwable)e.getCause());
            }
            Assert.assertEquals((String)("Failed to forward to " + this.method), (int)1, (int)this.called.get());
        }

        public String toString() {
            return "dummy " + this.interfaceType.getSimpleName();
        }
    }
}

