/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.collect.testing.NavigableSetTestSuiteBuilder;
import com.google.common.collect.testing.SafeTreeSet;
import com.google.common.collect.testing.SetTestSuiteBuilder;
import com.google.common.collect.testing.TestSetGenerator;
import com.google.common.collect.testing.TestStringSetGenerator;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.Feature;
import com.google.common.testing.SerializableTester;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class SafeTreeSetTest
extends TestCase {
    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(SafeTreeSetTest.class);
        suite.addTest((Test)((SetTestSuiteBuilder)((SetTestSuiteBuilder)NavigableSetTestSuiteBuilder.using((TestSetGenerator)new TestStringSetGenerator(){

            protected Set<String> create(String[] elements) {
                return new SafeTreeSet(Arrays.asList(elements));
            }

            public List<String> order(List<String> insertionOrder) {
                return Lists.newArrayList((Iterable)Sets.newTreeSet(insertionOrder));
            }
        }).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.KNOWN_ORDER, CollectionFeature.GENERAL_PURPOSE})).named("SafeTreeSet with natural comparator")).createTestSuite());
        suite.addTest((Test)((SetTestSuiteBuilder)((SetTestSuiteBuilder)SetTestSuiteBuilder.using((TestSetGenerator)new TestStringSetGenerator(){

            protected Set<String> create(String[] elements) {
                SafeTreeSet set = new SafeTreeSet((Comparator)Ordering.natural().nullsFirst());
                Collections.addAll(set, elements);
                return set;
            }

            public List<String> order(List<String> insertionOrder) {
                return Lists.newArrayList((Iterable)Sets.newTreeSet(insertionOrder));
            }
        }).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.KNOWN_ORDER, CollectionFeature.GENERAL_PURPOSE, CollectionFeature.ALLOWS_NULL_VALUES})).named("SafeTreeSet with null-friendly comparator")).createTestSuite());
        return suite;
    }

    @GwtIncompatible
    public void testViewSerialization() {
        ImmutableSortedMap map = ImmutableSortedMap.of((Comparable)((Object)"one"), (Object)1, (Comparable)((Object)"two"), (Object)2, (Comparable)((Object)"three"), (Object)3);
        SerializableTester.reserializeAndAssert(map.entrySet());
        SerializableTester.reserializeAndAssert(map.keySet());
        SafeTreeSetTest.assertEquals((Object)Lists.newArrayList(map.values()), (Object)Lists.newArrayList((Iterable)((Iterable)SerializableTester.reserialize(map.values()))));
    }

    @GwtIncompatible
    public void testEmpty_serialization() {
        SafeTreeSet set = new SafeTreeSet();
        SortedSet copy = (SortedSet)SerializableTester.reserializeAndAssert((Object)set);
        SafeTreeSetTest.assertEquals(set.comparator(), copy.comparator());
    }

    @GwtIncompatible
    public void testSingle_serialization() {
        SafeTreeSet set = new SafeTreeSet();
        set.add("e");
        SortedSet copy = (SortedSet)SerializableTester.reserializeAndAssert((Object)set);
        SafeTreeSetTest.assertEquals(set.comparator(), copy.comparator());
    }

    @GwtIncompatible
    public void testSeveral_serialization() {
        SafeTreeSet set = new SafeTreeSet();
        set.add("a");
        set.add("b");
        set.add("c");
        SortedSet copy = (SortedSet)SerializableTester.reserializeAndAssert((Object)set);
        SafeTreeSetTest.assertEquals(set.comparator(), copy.comparator());
    }
}

