/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.features;

import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.ListFeature;
import com.google.common.collect.testing.features.MapFeature;
import com.google.common.collect.testing.features.SetFeature;
import com.google.common.collect.testing.features.TesterAnnotation;
import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Method;
import java.util.Locale;
import junit.framework.TestCase;

public class FeatureEnumTest
extends TestCase {
    private static void assertGoodTesterAnnotation(Class<? extends Annotation> annotationClass) {
        FeatureEnumTest.assertNotNull((String)FeatureEnumTest.rootLocaleFormat("%s must be annotated with @TesterAnnotation.", annotationClass), (Object)annotationClass.getAnnotation(TesterAnnotation.class));
        Retention retentionPolicy = annotationClass.getAnnotation(Retention.class);
        FeatureEnumTest.assertNotNull((String)FeatureEnumTest.rootLocaleFormat("%s must have a @Retention annotation.", annotationClass), (Object)retentionPolicy);
        FeatureEnumTest.assertEquals((String)FeatureEnumTest.rootLocaleFormat("%s must have RUNTIME RetentionPolicy.", annotationClass), (Object)((Object)RetentionPolicy.RUNTIME), (Object)((Object)retentionPolicy.value()));
        FeatureEnumTest.assertNotNull((String)FeatureEnumTest.rootLocaleFormat("%s must be inherited.", annotationClass), (Object)annotationClass.getAnnotation(Inherited.class));
        for (String propertyName : new String[]{"value", "absent"}) {
            Method method = null;
            try {
                method = annotationClass.getMethod(propertyName, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                FeatureEnumTest.fail((String)FeatureEnumTest.rootLocaleFormat("%s must have a property named '%s'.", annotationClass, propertyName));
            }
            Class<?> returnType = method.getReturnType();
            FeatureEnumTest.assertTrue((String)FeatureEnumTest.rootLocaleFormat("%s.%s() must return an array.", annotationClass, propertyName), (boolean)returnType.isArray());
            FeatureEnumTest.assertSame((String)FeatureEnumTest.rootLocaleFormat("%s.%s() must return an array of %s.", annotationClass, propertyName, annotationClass.getDeclaringClass()), annotationClass.getDeclaringClass(), returnType.getComponentType());
        }
    }

    public static <E extends Enum<?>> void assertGoodFeatureEnum(Class<E> featureEnumClass) {
        Class<?>[] classes;
        for (Class<?> containedClass : classes = featureEnumClass.getDeclaredClasses()) {
            if (!containedClass.getSimpleName().equals("Require")) continue;
            if (containedClass.isAnnotation()) {
                FeatureEnumTest.assertGoodTesterAnnotation(FeatureEnumTest.asAnnotation(containedClass));
            } else {
                FeatureEnumTest.fail((String)FeatureEnumTest.rootLocaleFormat("Feature enum %s contains a class named 'Require' but it is not an annotation.", featureEnumClass));
            }
            return;
        }
        FeatureEnumTest.fail((String)FeatureEnumTest.rootLocaleFormat("Feature enum %s should contain an annotation named 'Require'.", featureEnumClass));
    }

    private static Class<? extends Annotation> asAnnotation(Class<?> clazz) {
        if (clazz.isAnnotation()) {
            return clazz;
        }
        throw new IllegalArgumentException(FeatureEnumTest.rootLocaleFormat("%s is not an annotation.", clazz));
    }

    public void testFeatureEnums() throws Exception {
        FeatureEnumTest.assertGoodFeatureEnum(CollectionFeature.class);
        FeatureEnumTest.assertGoodFeatureEnum(ListFeature.class);
        FeatureEnumTest.assertGoodFeatureEnum(SetFeature.class);
        FeatureEnumTest.assertGoodFeatureEnum(CollectionSize.class);
        FeatureEnumTest.assertGoodFeatureEnum(MapFeature.class);
    }

    private static String rootLocaleFormat(String format, Object ... args) {
        return String.format(Locale.ROOT, format, args);
    }
}

