/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.features;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.collect.testing.features.AndroidIncompatible;
import com.google.common.collect.testing.features.ConflictingRequirementsException;
import com.google.common.collect.testing.features.Feature;
import com.google.common.collect.testing.features.FeatureEnumTest;
import com.google.common.collect.testing.features.FeatureUtil;
import com.google.common.collect.testing.features.TesterAnnotation;
import com.google.common.collect.testing.features.TesterRequirements;
import com.google.common.truth.Truth;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import junit.framework.TestCase;

public class FeatureUtilTest
extends TestCase {
    public void testTestFeatureEnums() throws Exception {
        FeatureEnumTest.assertGoodFeatureEnum(ExampleBaseFeature.class);
        FeatureEnumTest.assertGoodFeatureEnum(ExampleDerivedFeature.class);
    }

    public void testAddImpliedFeatures_returnsSameSetInstance() throws Exception {
        HashSet features = Sets.newHashSet((Object[])new Feature[]{ExampleBaseFeature.BASE_FEATURE_1});
        FeatureUtilTest.assertSame((Object)features, (Object)FeatureUtil.addImpliedFeatures((Set)features));
    }

    public void testAddImpliedFeatures_addsImpliedFeatures() throws Exception {
        HashSet features = Sets.newHashSet((Object[])new Feature[]{ExampleDerivedFeature.DERIVED_FEATURE_1});
        Truth.assertThat((Iterable)FeatureUtil.addImpliedFeatures((Set)features)).contains((Object)ExampleDerivedFeature.DERIVED_FEATURE_1);
        features = Sets.newHashSet((Object[])new Feature[]{ExampleDerivedFeature.DERIVED_FEATURE_2});
        Truth.assertThat((Iterable)FeatureUtil.addImpliedFeatures((Set)features)).containsExactly(new Object[]{ExampleDerivedFeature.DERIVED_FEATURE_2, ExampleBaseFeature.BASE_FEATURE_1});
        features = Sets.newHashSet((Object[])new Feature[]{ExampleDerivedFeature.COMPOUND_DERIVED_FEATURE});
        Truth.assertThat((Iterable)FeatureUtil.addImpliedFeatures((Set)features)).containsExactly(new Object[]{ExampleDerivedFeature.COMPOUND_DERIVED_FEATURE, ExampleDerivedFeature.DERIVED_FEATURE_1, ExampleDerivedFeature.DERIVED_FEATURE_2, ExampleBaseFeature.BASE_FEATURE_1, ExampleBaseFeature.BASE_FEATURE_2});
    }

    public void testImpliedFeatures_returnsNewSetInstance() throws Exception {
        HashSet features = Sets.newHashSet((Object[])new Feature[]{ExampleBaseFeature.BASE_FEATURE_1});
        FeatureUtilTest.assertNotSame((Object)features, (Object)FeatureUtil.impliedFeatures((Set)features));
    }

    public void testImpliedFeatures_returnsImpliedFeatures() throws Exception {
        HashSet features = Sets.newHashSet((Object[])new Feature[]{ExampleDerivedFeature.DERIVED_FEATURE_1});
        FeatureUtilTest.assertTrue((boolean)FeatureUtil.impliedFeatures((Set)features).isEmpty());
        features = Sets.newHashSet((Object[])new Feature[]{ExampleDerivedFeature.DERIVED_FEATURE_2});
        Truth.assertThat((Iterable)FeatureUtil.impliedFeatures((Set)features)).contains((Object)ExampleBaseFeature.BASE_FEATURE_1);
        features = Sets.newHashSet((Object[])new Feature[]{ExampleDerivedFeature.COMPOUND_DERIVED_FEATURE});
        Truth.assertThat((Iterable)FeatureUtil.impliedFeatures((Set)features)).containsExactly(new Object[]{ExampleDerivedFeature.DERIVED_FEATURE_1, ExampleDerivedFeature.DERIVED_FEATURE_2, ExampleBaseFeature.BASE_FEATURE_1, ExampleBaseFeature.BASE_FEATURE_2});
    }

    @AndroidIncompatible
    public void testBuildTesterRequirements_class() throws Exception {
        FeatureUtilTest.assertEquals((Object)FeatureUtil.buildTesterRequirements(ExampleBaseInterfaceTester.class), (Object)new TesterRequirements((Set)Sets.newHashSet((Object[])new Feature[]{ExampleBaseFeature.BASE_FEATURE_1}), Collections.emptySet()));
        FeatureUtilTest.assertEquals((Object)FeatureUtil.buildTesterRequirements(ExampleDerivedInterfaceTester.class), (Object)new TesterRequirements((Set)Sets.newHashSet((Object[])new Feature[]{ExampleBaseFeature.BASE_FEATURE_1, ExampleDerivedFeature.DERIVED_FEATURE_2}), Collections.emptySet()));
    }

    @AndroidIncompatible
    public void testBuildTesterRequirements_method() throws Exception {
        FeatureUtilTest.assertEquals((Object)FeatureUtil.buildTesterRequirements((Method)ExampleDerivedInterfaceTester.class.getMethod("testRequiringTwoExplicitDerivedFeatures", new Class[0])), (Object)new TesterRequirements((Set)Sets.newHashSet((Object[])new Feature[]{ExampleBaseFeature.BASE_FEATURE_1, ExampleDerivedFeature.DERIVED_FEATURE_1, ExampleDerivedFeature.DERIVED_FEATURE_2}), Collections.emptySet()));
        FeatureUtilTest.assertEquals((Object)FeatureUtil.buildTesterRequirements((Method)ExampleDerivedInterfaceTester.class.getMethod("testRequiringAllThreeDerivedFeatures", new Class[0])), (Object)new TesterRequirements((Set)Sets.newHashSet((Object[])new Feature[]{ExampleBaseFeature.BASE_FEATURE_1, ExampleDerivedFeature.DERIVED_FEATURE_1, ExampleDerivedFeature.DERIVED_FEATURE_2, ExampleDerivedFeature.DERIVED_FEATURE_3}), Collections.emptySet()));
    }

    @AndroidIncompatible
    public void testBuildTesterRequirements_classClassConflict() throws Exception {
        try {
            FeatureUtil.buildTesterRequirements(ExampleDerivedInterfaceTester_Conflict.class);
            FeatureUtilTest.fail((String)"Expected ConflictingRequirementsException");
        }
        catch (ConflictingRequirementsException e) {
            Truth.assertThat((Iterable)e.getConflicts()).contains((Object)ExampleBaseFeature.BASE_FEATURE_1);
            FeatureUtilTest.assertEquals(ExampleDerivedInterfaceTester_Conflict.class, (Object)e.getSource());
        }
    }

    @AndroidIncompatible
    public void testBuildTesterRequirements_methodClassConflict() throws Exception {
        Method method = ExampleDerivedInterfaceTester.class.getMethod("testRequiringConflictingFeatures", new Class[0]);
        try {
            FeatureUtil.buildTesterRequirements((Method)method);
            FeatureUtilTest.fail((String)"Expected ConflictingRequirementsException");
        }
        catch (ConflictingRequirementsException e) {
            Truth.assertThat((Iterable)e.getConflicts()).contains((Object)ExampleBaseFeature.BASE_FEATURE_1);
            FeatureUtilTest.assertEquals((Object)method, (Object)e.getSource());
        }
    }

    @AndroidIncompatible
    public void testBuildDeclaredTesterRequirements() throws Exception {
        FeatureUtilTest.assertEquals((Object)FeatureUtil.buildDeclaredTesterRequirements((AnnotatedElement)ExampleDerivedInterfaceTester.class.getMethod("testRequiringTwoExplicitDerivedFeatures", new Class[0])), (Object)new TesterRequirements(FeatureUtil.addImpliedFeatures((Set)Sets.newHashSet((Object[])new Feature[]{ExampleDerivedFeature.DERIVED_FEATURE_1, ExampleDerivedFeature.DERIVED_FEATURE_2})), Collections.emptySet()));
    }

    @ExampleDerivedFeature.Require(absent={ExampleDerivedFeature.DERIVED_FEATURE_2})
    private static class ExampleDerivedInterfaceTester_Conflict
    extends ExampleBaseInterfaceTester {
        private ExampleDerivedInterfaceTester_Conflict() {
        }
    }

    @NonTesterAnnotation
    @ExampleDerivedFeature.Require(value={ExampleDerivedFeature.DERIVED_FEATURE_2})
    @AndroidIncompatible
    private static class ExampleDerivedInterfaceTester
    extends ExampleBaseInterfaceTester {
        private ExampleDerivedInterfaceTester() {
        }

        @ExampleDerivedFeature.Require(value={ExampleDerivedFeature.DERIVED_FEATURE_1, ExampleDerivedFeature.DERIVED_FEATURE_2})
        public void testRequiringTwoExplicitDerivedFeatures() throws Exception {
            this.doNotActuallyRunThis();
        }

        @ExampleDerivedFeature.Require(value={ExampleDerivedFeature.DERIVED_FEATURE_1, ExampleDerivedFeature.DERIVED_FEATURE_3})
        public void testRequiringAllThreeDerivedFeatures() {
            this.doNotActuallyRunThis();
        }

        @ExampleBaseFeature.Require(absent={ExampleBaseFeature.BASE_FEATURE_1})
        public void testRequiringConflictingFeatures() throws Exception {
            this.doNotActuallyRunThis();
        }
    }

    @ExampleBaseFeature.Require(value={ExampleBaseFeature.BASE_FEATURE_1})
    private static abstract class ExampleBaseInterfaceTester
    extends TestCase {
        private ExampleBaseInterfaceTester() {
        }

        protected final void doNotActuallyRunThis() {
            ExampleBaseInterfaceTester.fail((String)"Nobody's meant to actually run this!");
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface NonTesterAnnotation {
    }

    static enum ExampleDerivedFeature implements Feature<ExampleDerivedInterface>
    {
        DERIVED_FEATURE_1(new Feature[0]),
        DERIVED_FEATURE_2(ExampleBaseFeature.BASE_FEATURE_1),
        DERIVED_FEATURE_3(new Feature[0]),
        COMPOUND_DERIVED_FEATURE(DERIVED_FEATURE_1, DERIVED_FEATURE_2, ExampleBaseFeature.BASE_FEATURE_2);

        private Set<Feature<? super ExampleDerivedInterface>> implied;

        private ExampleDerivedFeature(Feature<? super ExampleDerivedInterface> ... implied) {
            this.implied = ImmutableSet.copyOf((Object[])implied);
        }

        public Set<Feature<? super ExampleDerivedInterface>> getImpliedFeatures() {
            return this.implied;
        }

        @Retention(value=RetentionPolicy.RUNTIME)
        @Inherited
        @TesterAnnotation
        static @interface Require {
            public ExampleDerivedFeature[] value() default {};

            public ExampleDerivedFeature[] absent() default {};
        }
    }

    static enum ExampleBaseFeature implements Feature<ExampleBaseInterface>
    {
        BASE_FEATURE_1,
        BASE_FEATURE_2;


        public Set<Feature<? super ExampleBaseInterface>> getImpliedFeatures() {
            return Collections.emptySet();
        }

        @Retention(value=RetentionPolicy.RUNTIME)
        @Inherited
        @TesterAnnotation
        static @interface Require {
            public ExampleBaseFeature[] value() default {};

            public ExampleBaseFeature[] absent() default {};
        }
    }

    static interface ExampleDerivedInterface
    extends ExampleBaseInterface {
        public void misbehave();
    }

    static interface ExampleBaseInterface {
        public void behave();
    }
}

