/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.testing;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Equivalence;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableTable;
import com.google.common.testing.EquivalenceTester;
import com.google.common.truth.Truth;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;

@GwtCompatible
public class EquivalenceTesterTest
extends TestCase {
    private EquivalenceTester<Object> tester;
    private MockEquivalence equivalenceMock;

    public void setUp() throws Exception {
        super.setUp();
        this.equivalenceMock = new MockEquivalence();
        this.tester = EquivalenceTester.of((Equivalence)this.equivalenceMock);
    }

    public void testOf_NullPointerException() {
        try {
            EquivalenceTester.of(null);
            EquivalenceTesterTest.fail((String)"Should fail on null reference");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testTest_NoData() {
        this.tester.test();
    }

    public void testTest() {
        TestObject group1Item1 = new TestObject(1, 1);
        TestObject group1Item2 = new TestObject(1, 2);
        TestObject group2Item1 = new TestObject(2, 1);
        TestObject group2Item2 = new TestObject(2, 2);
        this.equivalenceMock.expectEquivalent(group1Item1, group1Item2);
        this.equivalenceMock.expectDistinct(group1Item1, group2Item1);
        this.equivalenceMock.expectDistinct(group1Item1, group2Item2);
        this.equivalenceMock.expectEquivalent(group1Item2, group1Item1);
        this.equivalenceMock.expectDistinct(group1Item2, group2Item1);
        this.equivalenceMock.expectDistinct(group1Item2, group2Item2);
        this.equivalenceMock.expectDistinct(group2Item1, group1Item1);
        this.equivalenceMock.expectDistinct(group2Item1, group1Item2);
        this.equivalenceMock.expectEquivalent(group2Item1, group2Item2);
        this.equivalenceMock.expectDistinct(group2Item2, group1Item1);
        this.equivalenceMock.expectDistinct(group2Item2, group1Item2);
        this.equivalenceMock.expectEquivalent(group2Item2, group2Item1);
        this.equivalenceMock.expectHash(group1Item1, 1);
        this.equivalenceMock.expectHash(group1Item2, 1);
        this.equivalenceMock.expectHash(group2Item1, 2);
        this.equivalenceMock.expectHash(group2Item2, 2);
        this.equivalenceMock.replay();
        this.tester.addEquivalenceGroup((Object)group1Item1, new Object[]{group1Item2}).addEquivalenceGroup((Object)group2Item1, new Object[]{group2Item2}).test();
    }

    public void testTest_symmetric() {
        TestObject group1Item1 = new TestObject(1, 1);
        TestObject group1Item2 = new TestObject(1, 2);
        this.equivalenceMock.expectEquivalent(group1Item1, group1Item2);
        this.equivalenceMock.expectDistinct(group1Item2, group1Item1);
        this.equivalenceMock.expectHash(group1Item1, 1);
        this.equivalenceMock.expectHash(group1Item2, 1);
        this.equivalenceMock.replay();
        try {
            this.tester.addEquivalenceGroup((Object)group1Item1, new Object[]{group1Item2}).test();
        }
        catch (AssertionFailedError expected) {
            Truth.assertThat((String)expected.getMessage()).contains((CharSequence)"TestObject{group=1, item=2} [group 1, item 2] must be equivalent to TestObject{group=1, item=1} [group 1, item 1]");
            return;
        }
        EquivalenceTesterTest.fail();
    }

    public void testTest_trasitive() {
        TestObject group1Item1 = new TestObject(1, 1);
        TestObject group1Item2 = new TestObject(1, 2);
        TestObject group1Item3 = new TestObject(1, 3);
        this.equivalenceMock.expectEquivalent(group1Item1, group1Item2);
        this.equivalenceMock.expectEquivalent(group1Item1, group1Item3);
        this.equivalenceMock.expectEquivalent(group1Item2, group1Item1);
        this.equivalenceMock.expectDistinct(group1Item2, group1Item3);
        this.equivalenceMock.expectEquivalent(group1Item3, group1Item1);
        this.equivalenceMock.expectEquivalent(group1Item3, group1Item2);
        this.equivalenceMock.expectHash(group1Item1, 1);
        this.equivalenceMock.expectHash(group1Item2, 1);
        this.equivalenceMock.expectHash(group1Item3, 1);
        this.equivalenceMock.replay();
        try {
            this.tester.addEquivalenceGroup((Object)group1Item1, new Object[]{group1Item2, group1Item3}).test();
        }
        catch (AssertionFailedError expected) {
            Truth.assertThat((String)expected.getMessage()).contains((CharSequence)"TestObject{group=1, item=2} [group 1, item 2] must be equivalent to TestObject{group=1, item=3} [group 1, item 3]");
            return;
        }
        EquivalenceTesterTest.fail();
    }

    public void testTest_inequivalence() {
        TestObject group1Item1 = new TestObject(1, 1);
        TestObject group2Item1 = new TestObject(2, 1);
        this.equivalenceMock.expectEquivalent(group1Item1, group2Item1);
        this.equivalenceMock.expectDistinct(group2Item1, group1Item1);
        this.equivalenceMock.expectHash(group1Item1, 1);
        this.equivalenceMock.expectHash(group2Item1, 2);
        this.equivalenceMock.replay();
        try {
            this.tester.addEquivalenceGroup((Object)group1Item1, new Object[0]).addEquivalenceGroup((Object)group2Item1, new Object[0]).test();
        }
        catch (AssertionFailedError expected) {
            Truth.assertThat((String)expected.getMessage()).contains((CharSequence)"TestObject{group=1, item=1} [group 1, item 1] must not be equivalent to TestObject{group=2, item=1} [group 2, item 1]");
            return;
        }
        EquivalenceTesterTest.fail();
    }

    public void testTest_hash() {
        TestObject group1Item1 = new TestObject(1, 1);
        TestObject group1Item2 = new TestObject(1, 2);
        this.equivalenceMock.expectEquivalent(group1Item1, group1Item2);
        this.equivalenceMock.expectEquivalent(group1Item2, group1Item1);
        this.equivalenceMock.expectHash(group1Item1, 1);
        this.equivalenceMock.expectHash(group1Item2, 2);
        this.equivalenceMock.replay();
        try {
            this.tester.addEquivalenceGroup((Object)group1Item1, new Object[]{group1Item2}).test();
        }
        catch (AssertionFailedError expected) {
            String expectedMessage = "the hash (1) of TestObject{group=1, item=1} [group 1, item 1] must be equal to the hash (2) of TestObject{group=1, item=2} [group 1, item 2]";
            if (!expected.getMessage().contains(expectedMessage)) {
                EquivalenceTesterTest.fail((String)("<" + expected.getMessage() + "> expected to contain <" + expectedMessage + ">"));
            }
            return;
        }
        EquivalenceTesterTest.fail();
    }

    private static final class MockEquivalence
    extends Equivalence<Object> {
        final ImmutableTable.Builder<Object, Object, Boolean> equivalentExpectationsBuilder = ImmutableTable.builder();
        final ImmutableMap.Builder<Object, Integer> hashExpectationsBuilder = ImmutableMap.builder();
        ImmutableTable<Object, Object, Boolean> equivalentExpectations;
        ImmutableMap<Object, Integer> hashExpectations;

        private MockEquivalence() {
        }

        void expectEquivalent(Object a, Object b) {
            this.checkRecording();
            this.equivalentExpectationsBuilder.put(a, b, (Object)true);
        }

        void expectDistinct(Object a, Object b) {
            this.checkRecording();
            this.equivalentExpectationsBuilder.put(a, b, (Object)false);
        }

        void expectHash(Object object, int hash) {
            this.checkRecording();
            this.hashExpectationsBuilder.put(object, (Object)hash);
        }

        void replay() {
            this.checkRecording();
            this.equivalentExpectations = this.equivalentExpectationsBuilder.build();
            this.hashExpectations = this.hashExpectationsBuilder.build();
        }

        protected boolean doEquivalent(Object a, Object b) {
            return (Boolean)this.equivalentExpectations.get(a, b);
        }

        protected int doHash(Object object) {
            return (Integer)this.hashExpectations.get(object);
        }

        void checkRecording() {
            Preconditions.checkState((this.equivalentExpectations == null && this.hashExpectations == null ? 1 : 0) != 0);
        }
    }

    private static final class TestObject {
        final int group;
        final int item;

        TestObject(int group, int item) {
            this.group = group;
            this.item = item;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"TestObject").add("group", this.group).add("item", this.item).toString();
        }
    }
}

