/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.testing;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.testing.FakeTicker;
import com.google.common.testing.NullPointerTester;
import java.util.EnumSet;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;

@GwtCompatible(emulated=true)
public class FakeTickerTest
extends TestCase {
    @GwtIncompatible
    public void testNullPointerExceptions() {
        NullPointerTester tester = new NullPointerTester();
        tester.testAllPublicInstanceMethods((Object)new FakeTicker());
    }

    public void testAdvance() {
        FakeTicker ticker = new FakeTicker();
        FakeTickerTest.assertEquals((long)0L, (long)ticker.read());
        FakeTickerTest.assertSame((Object)ticker, (Object)ticker.advance(10L));
        FakeTickerTest.assertEquals((long)10L, (long)ticker.read());
        ticker.advance(1L, TimeUnit.MILLISECONDS);
        FakeTickerTest.assertEquals((long)1000010L, (long)ticker.read());
    }

    public void testAutoIncrementStep_returnsSameInstance() {
        FakeTicker ticker = new FakeTicker();
        FakeTickerTest.assertSame((Object)ticker, (Object)ticker.setAutoIncrementStep(10L, TimeUnit.NANOSECONDS));
    }

    public void testAutoIncrementStep_nanos() {
        FakeTicker ticker = new FakeTicker().setAutoIncrementStep(10L, TimeUnit.NANOSECONDS);
        FakeTickerTest.assertEquals((long)0L, (long)ticker.read());
        FakeTickerTest.assertEquals((long)10L, (long)ticker.read());
        FakeTickerTest.assertEquals((long)20L, (long)ticker.read());
    }

    public void testAutoIncrementStep_millis() {
        FakeTicker ticker = new FakeTicker().setAutoIncrementStep(1L, TimeUnit.MILLISECONDS);
        FakeTickerTest.assertEquals((long)0L, (long)ticker.read());
        FakeTickerTest.assertEquals((long)1000000L, (long)ticker.read());
        FakeTickerTest.assertEquals((long)2000000L, (long)ticker.read());
    }

    public void testAutoIncrementStep_seconds() {
        FakeTicker ticker = new FakeTicker().setAutoIncrementStep(3L, TimeUnit.SECONDS);
        FakeTickerTest.assertEquals((long)0L, (long)ticker.read());
        FakeTickerTest.assertEquals((long)3000000000L, (long)ticker.read());
        FakeTickerTest.assertEquals((long)6000000000L, (long)ticker.read());
    }

    public void testAutoIncrementStep_resetToZero() {
        FakeTicker ticker = new FakeTicker().setAutoIncrementStep(10L, TimeUnit.NANOSECONDS);
        FakeTickerTest.assertEquals((long)0L, (long)ticker.read());
        FakeTickerTest.assertEquals((long)10L, (long)ticker.read());
        FakeTickerTest.assertEquals((long)20L, (long)ticker.read());
        for (TimeUnit timeUnit : EnumSet.allOf(TimeUnit.class)) {
            ticker.setAutoIncrementStep(0L, timeUnit);
            FakeTickerTest.assertEquals((String)("Expected no auto-increment when setting autoIncrementStep to 0 " + (Object)((Object)timeUnit)), (long)30L, (long)ticker.read());
        }
    }

    public void testAutoIncrement_negative() {
        FakeTicker ticker = new FakeTicker();
        try {
            ticker.setAutoIncrementStep(-1L, TimeUnit.NANOSECONDS);
            FakeTickerTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @GwtIncompatible
    public void testConcurrentAdvance() throws Exception {
        final FakeTicker ticker = new FakeTicker();
        int numberOfThreads = 64;
        this.runConcurrentTest(numberOfThreads, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ticker.advance(1L);
                Thread.sleep(10L);
                ticker.advance(1L);
                return null;
            }
        });
        FakeTickerTest.assertEquals((long)(numberOfThreads * 2), (long)ticker.read());
    }

    @GwtIncompatible
    public void testConcurrentAutoIncrementStep() throws Exception {
        int incrementByNanos = 3;
        final FakeTicker ticker = new FakeTicker().setAutoIncrementStep((long)incrementByNanos, TimeUnit.NANOSECONDS);
        int numberOfThreads = 64;
        this.runConcurrentTest(numberOfThreads, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ticker.read();
                return null;
            }
        });
        FakeTickerTest.assertEquals((long)(incrementByNanos * numberOfThreads), (long)ticker.read());
    }

    @GwtIncompatible
    private void runConcurrentTest(int numberOfThreads, final Callable<Void> callable) throws Exception {
        ExecutorService executorService = Executors.newFixedThreadPool(numberOfThreads);
        final CountDownLatch startLatch = new CountDownLatch(numberOfThreads);
        final CountDownLatch doneLatch = new CountDownLatch(numberOfThreads);
        for (int i = numberOfThreads; i > 0; --i) {
            executorService.submit(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    startLatch.countDown();
                    startLatch.await();
                    callable.call();
                    doneLatch.countDown();
                    return null;
                }
            });
        }
        doneLatch.await();
    }
}

