/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.testing;

import com.google.common.base.CharMatcher;
import com.google.common.base.Equivalence;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.base.Ticker;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedMultiset;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import com.google.common.collect.Ordering;
import com.google.common.collect.Range;
import com.google.common.collect.RowSortedTable;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.SortedMultiset;
import com.google.common.collect.Table;
import com.google.common.collect.TreeBasedTable;
import com.google.common.collect.TreeMultiset;
import com.google.common.primitives.UnsignedInteger;
import com.google.common.primitives.UnsignedLong;
import com.google.common.reflect.TypeToken;
import com.google.common.testing.AndroidIncompatible;
import com.google.common.testing.ClassSanityTester;
import com.google.common.testing.EqualsTester;
import com.google.common.testing.FreshValueGenerator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Currency;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import junit.framework.TestCase;

public class FreshValueGeneratorTest
extends TestCase {
    @AndroidIncompatible
    public void testFreshInstance() {
        FreshValueGeneratorTest.assertFreshInstances(String.class, CharSequence.class, Appendable.class, StringBuffer.class, StringBuilder.class, Pattern.class, MatchResult.class, Number.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, Short.TYPE, Short.class, Byte.TYPE, Byte.class, Boolean.TYPE, Boolean.class, Character.TYPE, Character.class, int[].class, Object[].class, UnsignedInteger.class, UnsignedLong.class, BigInteger.class, BigDecimal.class, Throwable.class, Error.class, Exception.class, RuntimeException.class, Charset.class, Locale.class, Currency.class, List.class, Map.Entry.class, Object.class, Equivalence.class, Predicate.class, Function.class, Comparable.class, Comparator.class, Ordering.class, Class.class, Type.class, TypeToken.class, TimeUnit.class, Ticker.class, Joiner.class, Splitter.class, CharMatcher.class, InputStream.class, ByteArrayInputStream.class, Reader.class, Readable.class, StringReader.class, OutputStream.class, ByteArrayOutputStream.class, Writer.class, StringWriter.class, File.class, Buffer.class, ByteBuffer.class, CharBuffer.class, ShortBuffer.class, IntBuffer.class, LongBuffer.class, FloatBuffer.class, DoubleBuffer.class, String[].class, Object[].class, int[].class);
    }

    public void testStringArray() {
        FreshValueGenerator generator = new FreshValueGenerator();
        String[] a1 = (String[])generator.generateFresh(String[].class);
        String[] a2 = (String[])generator.generateFresh(String[].class);
        FreshValueGeneratorTest.assertFalse((boolean)a1[0].equals(a2[0]));
    }

    public void testPrimitiveArray() {
        int[] a2;
        FreshValueGenerator generator = new FreshValueGenerator();
        int[] a1 = (int[])generator.generateFresh(int[].class);
        FreshValueGeneratorTest.assertTrue((a1[0] != (a2 = (int[])generator.generateFresh(int[].class))[0] ? 1 : 0) != 0);
    }

    public void testRange() {
        FreshValueGeneratorTest.assertFreshInstance(new TypeToken<Range<String>>(){});
    }

    public void testImmutableList() {
        FreshValueGeneratorTest.assertFreshInstance(new TypeToken<ImmutableList<String>>(){});
    }

    public void testImmutableSet() {
        FreshValueGeneratorTest.assertFreshInstance(new TypeToken<ImmutableSet<String>>(){});
    }

    public void testImmutableSortedSet() {
        FreshValueGeneratorTest.assertFreshInstance(new TypeToken<ImmutableSortedSet<String>>(){});
    }

    public void testImmutableMultiset() {
        FreshValueGeneratorTest.assertFreshInstance(new TypeToken<ImmutableSortedSet<String>>(){});
        FreshValueGeneratorTest.assertNotInstantiable(new TypeToken<ImmutableMultiset<EmptyEnum>>(){});
    }

    public void testImmutableCollection() {
        FreshValueGeneratorTest.assertFreshInstance(new TypeToken<ImmutableCollection<String>>(){});
        FreshValueGeneratorTest.assertNotInstantiable(new TypeToken<ImmutableCollection<EmptyEnum>>(){});
    }

    public void testImmutableMap() {
        FreshValueGeneratorTest.assertFreshInstance(new TypeToken<ImmutableMap<String, Integer>>(){});
    }

    public void testImmutableSortedMap() {
        FreshValueGeneratorTest.assertFreshInstance(new TypeToken<ImmutableSortedMap<String, Integer>>(){});
    }

    public void testImmutableMultimap() {
        FreshValueGeneratorTest.assertFreshInstance(new TypeToken<ImmutableMultimap<String, Integer>>(){});
        FreshValueGeneratorTest.assertNotInstantiable(new TypeToken<ImmutableMultimap<EmptyEnum, String>>(){});
    }

    public void testImmutableListMultimap() {
        FreshValueGeneratorTest.assertFreshInstance(new TypeToken<ImmutableListMultimap<String, Integer>>(){});
    }

    public void testImmutableSetMultimap() {
        FreshValueGeneratorTest.assertFreshInstance(new TypeToken<ImmutableSetMultimap<String, Integer>>(){});
    }

    public void testImmutableBiMap() {
        FreshValueGeneratorTest.assertFreshInstance(new TypeToken<ImmutableBiMap<String, Integer>>(){});
    }

    public void testImmutableTable() {
        FreshValueGeneratorTest.assertFreshInstance(new TypeToken<ImmutableTable<String, Integer, ImmutableList<String>>>(){});
    }

    public void testList() {
        FreshValueGeneratorTest.assertFreshInstance(new TypeToken<List<String>>(){});
        FreshValueGeneratorTest.assertNotInstantiable(new TypeToken<List<EmptyEnum>>(){});
    }

    public void testArrayList() {
        FreshValueGeneratorTest.assertFreshInstance(new TypeToken<ArrayList<String>>(){});
        FreshValueGeneratorTest.assertNotInstantiable(new TypeToken<ArrayList<EmptyEnum>>(){});
    }

    public void testLinkedList() {
        FreshValueGeneratorTest.assertFreshInstance(new TypeToken<LinkedList<String>>(){});
    }

    public void testSet() {
        FreshValueGeneratorTest.assertFreshInstance(new TypeToken<Set<String>>(){});
        FreshValueGeneratorTest.assertNotInstantiable(new TypeToken<Set<EmptyEnum>>(){});
    }

    public void testHashSet() {
        FreshValueGeneratorTest.assertFreshInstance(new TypeToken<HashSet<String>>(){});
    }

    public void testLinkedHashSet() {
        FreshValueGeneratorTest.assertFreshInstance(new TypeToken<LinkedHashSet<String>>(){});
    }

    public void testTreeSet() {
        FreshValueGeneratorTest.assertFreshInstance(new TypeToken<TreeSet<String>>(){});
    }

    public void testSortedSet() {
        FreshValueGeneratorTest.assertFreshInstance(new TypeToken<SortedSet<String>>(){});
    }

    public void testNavigableSet() {
        FreshValueGeneratorTest.assertFreshInstance(new TypeToken<NavigableSet<String>>(){});
    }

    public void testMultiset() {
        FreshValueGeneratorTest.assertFreshInstance(new TypeToken<Multiset<String>>(){});
    }

    public void testSortedMultiset() {
        FreshValueGeneratorTest.assertFreshInstance(new TypeToken<SortedMultiset<String>>(){});
    }

    public void testHashMultiset() {
        FreshValueGeneratorTest.assertFreshInstance(new TypeToken<HashMultiset<String>>(){});
    }

    public void testLinkedHashMultiset() {
        FreshValueGeneratorTest.assertFreshInstance(new TypeToken<LinkedHashMultiset<String>>(){});
    }

    public void testTreeMultiset() {
        FreshValueGeneratorTest.assertFreshInstance(new TypeToken<TreeMultiset<String>>(){});
    }

    public void testImmutableSortedMultiset() {
        FreshValueGeneratorTest.assertFreshInstance(new TypeToken<ImmutableSortedMultiset<String>>(){});
    }

    public void testCollection() {
        FreshValueGeneratorTest.assertFreshInstance(new TypeToken<Collection<String>>(){});
    }

    public void testIterable() {
        FreshValueGeneratorTest.assertFreshInstance(new TypeToken<Iterable<String>>(){});
    }

    public void testMap() {
        FreshValueGeneratorTest.assertFreshInstance(new TypeToken<Map<String, ?>>(){});
    }

    public void testHashMap() {
        FreshValueGeneratorTest.assertFreshInstance(new TypeToken<HashMap<String, ?>>(){});
    }

    public void testLinkedHashMap() {
        FreshValueGeneratorTest.assertFreshInstance(new TypeToken<LinkedHashMap<String, ?>>(){});
    }

    public void testTreeMap() {
        FreshValueGeneratorTest.assertFreshInstance(new TypeToken<TreeMap<String, ?>>(){});
    }

    public void testSortedMap() {
        FreshValueGeneratorTest.assertFreshInstance(new TypeToken<SortedMap<?, String>>(){});
    }

    public void testNavigableMap() {
        FreshValueGeneratorTest.assertFreshInstance(new TypeToken<NavigableMap<?, ?>>(){});
    }

    public void testConcurrentMap() {
        FreshValueGeneratorTest.assertFreshInstance(new TypeToken<ConcurrentMap<String, ?>>(){});
        FreshValueGeneratorTest.assertCanGenerateOnly(new TypeToken<ConcurrentMap<EmptyEnum, String>>(){}, Maps.newConcurrentMap());
    }

    public void testMultimap() {
        FreshValueGeneratorTest.assertFreshInstance(new TypeToken<Multimap<String, ?>>(){});
    }

    public void testHashMultimap() {
        FreshValueGeneratorTest.assertFreshInstance(new TypeToken<HashMultimap<String, ?>>(){});
    }

    public void testLinkedHashMultimap() {
        FreshValueGeneratorTest.assertFreshInstance(new TypeToken<LinkedHashMultimap<String, ?>>(){});
    }

    public void testListMultimap() {
        FreshValueGeneratorTest.assertFreshInstance(new TypeToken<ListMultimap<String, ?>>(){});
    }

    public void testArrayListMultimap() {
        FreshValueGeneratorTest.assertFreshInstance(new TypeToken<ArrayListMultimap<String, ?>>(){});
    }

    public void testSetMultimap() {
        FreshValueGeneratorTest.assertFreshInstance(new TypeToken<SetMultimap<String, ?>>(){});
    }

    public void testBiMap() {
        FreshValueGeneratorTest.assertFreshInstance(new TypeToken<BiMap<String, ?>>(){});
        FreshValueGeneratorTest.assertNotInstantiable(new TypeToken<BiMap<EmptyEnum, String>>(){});
    }

    public void testHashBiMap() {
        FreshValueGeneratorTest.assertFreshInstance(new TypeToken<HashBiMap<String, ?>>(){});
    }

    public void testTable() {
        FreshValueGeneratorTest.assertFreshInstance(new TypeToken<Table<String, ?, ?>>(){});
        FreshValueGeneratorTest.assertNotInstantiable(new TypeToken<Table<EmptyEnum, String, Integer>>(){});
    }

    public void testHashBasedTable() {
        FreshValueGeneratorTest.assertFreshInstance(new TypeToken<HashBasedTable<String, ?, ?>>(){});
    }

    public void testRowSortedTable() {
        FreshValueGeneratorTest.assertFreshInstance(new TypeToken<RowSortedTable<String, ?, ?>>(){});
    }

    public void testTreeBasedTable() {
        FreshValueGeneratorTest.assertFreshInstance(new TypeToken<TreeBasedTable<String, ?, ?>>(){});
    }

    public void testObject() {
        FreshValueGeneratorTest.assertEquals((Object)new FreshValueGenerator().generateFresh(String.class), (Object)new FreshValueGenerator().generateFresh(Object.class));
    }

    public void testEnums() {
        FreshValueGeneratorTest.assertEqualInstance(EmptyEnum.class, null);
        FreshValueGeneratorTest.assertEqualInstance(OneConstantEnum.class, OneConstantEnum.CONSTANT1);
        FreshValueGeneratorTest.assertFreshInstance(TwoConstantEnum.class, 2);
        FreshValueGeneratorTest.assertFreshInstance(new TypeToken<Optional<OneConstantEnum>>(){}, 2);
        FreshValueGeneratorTest.assertFreshInstance(new TypeToken<List<OneConstantEnum>>(){}, 1);
        FreshValueGeneratorTest.assertFreshInstance(new TypeToken<List<TwoConstantEnum>>(){}, 2);
    }

    @AndroidIncompatible
    public void testOptional() {
        FreshValueGenerator generator = new FreshValueGenerator();
        FreshValueGeneratorTest.assertEquals((Object)Optional.absent(), (Object)generator.generateFresh((TypeToken)new TypeToken<Optional<String>>(){}));
        FreshValueGeneratorTest.assertEquals((Object)Optional.of((Object)"2"), (Object)generator.generateFresh((TypeToken)new TypeToken<Optional<String>>(){}));
        FreshValueGeneratorTest.assertEquals((Object)Optional.absent(), (Object)generator.generateFresh((TypeToken)new TypeToken<Optional<OneConstantEnum>>(){}));
        FreshValueGeneratorTest.assertEquals((Object)Optional.of((Object)((Object)OneConstantEnum.CONSTANT1)), (Object)generator.generateFresh((TypeToken)new TypeToken<Optional<OneConstantEnum>>(){}));
    }

    public void testAddSampleInstances_twoInstances() {
        FreshValueGenerator generator = new FreshValueGenerator();
        generator.addSampleInstances(String.class, (Iterable)ImmutableList.of((Object)"a", (Object)"b"));
        FreshValueGeneratorTest.assertEquals((String)"a", (String)((String)generator.generateFresh(String.class)));
        FreshValueGeneratorTest.assertEquals((String)"b", (String)((String)generator.generateFresh(String.class)));
        FreshValueGeneratorTest.assertEquals((String)"a", (String)((String)generator.generateFresh(String.class)));
    }

    public void testAddSampleInstances_oneInstance() {
        FreshValueGenerator generator = new FreshValueGenerator();
        generator.addSampleInstances(String.class, (Iterable)ImmutableList.of((Object)"a"));
        FreshValueGeneratorTest.assertEquals((String)"a", (String)((String)generator.generateFresh(String.class)));
        FreshValueGeneratorTest.assertEquals((String)"a", (String)((String)generator.generateFresh(String.class)));
    }

    public void testAddSampleInstances_noInstance() {
        FreshValueGenerator generator = new FreshValueGenerator();
        generator.addSampleInstances(String.class, (Iterable)ImmutableList.of());
        FreshValueGeneratorTest.assertEquals((String)((String)new FreshValueGenerator().generateFresh(String.class)), (String)((String)generator.generateFresh(String.class)));
    }

    public void testFreshCurrency() {
        FreshValueGenerator generator = new FreshValueGenerator();
        FreshValueGeneratorTest.assertNotNull((Object)generator.generateFresh(Currency.class));
        FreshValueGeneratorTest.assertNotNull((Object)generator.generateFresh(Currency.class));
        FreshValueGeneratorTest.assertNotNull((Object)generator.generateFresh(Currency.class));
    }

    public void testNulls() throws Exception {
        new ClassSanityTester().setDefault(Method.class, (Object)FreshValueGeneratorTest.class.getDeclaredMethod("testNulls", new Class[0])).testNulls(FreshValueGenerator.class);
    }

    private static void assertFreshInstances(Class<?> ... types) {
        for (Class<?> type : types) {
            FreshValueGeneratorTest.assertFreshInstance(type, 2);
        }
    }

    private static void assertFreshInstance(TypeToken<?> type) {
        FreshValueGeneratorTest.assertFreshInstance(type, 3);
    }

    private static void assertFreshInstance(Class<?> type, int instances) {
        FreshValueGeneratorTest.assertFreshInstance(TypeToken.of(type), instances);
    }

    private static void assertFreshInstance(TypeToken<?> type, int instances) {
        FreshValueGenerator generator = new FreshValueGenerator();
        EqualsTester tester = new EqualsTester();
        for (int i = 0; i < instances; ++i) {
            tester.addEqualityGroup(new Object[]{generator.generateFresh(type)});
        }
        tester.testEquals();
    }

    private static <T> void assertEqualInstance(Class<T> type, T value) {
        FreshValueGenerator generator = new FreshValueGenerator();
        FreshValueGeneratorTest.assertEquals(value, (Object)generator.generateFresh(type));
        FreshValueGeneratorTest.assertEquals(value, (Object)generator.generateFresh(type));
    }

    private static void assertCanGenerateOnly(TypeToken<?> type, Object expected) {
        FreshValueGenerator generator = new FreshValueGenerator();
        FreshValueGeneratorTest.assertValueAndTypeEquals(expected, generator.generateFresh(type));
        FreshValueGeneratorTest.assertNull((Object)generator.generateFresh(type));
    }

    private static void assertNotInstantiable(TypeToken<?> type) {
        FreshValueGeneratorTest.assertNull((Object)new FreshValueGenerator().generateFresh(type));
    }

    private static void assertValueAndTypeEquals(Object expected, Object actual) {
        FreshValueGeneratorTest.assertEquals((Object)expected, (Object)actual);
        FreshValueGeneratorTest.assertEquals(expected.getClass(), actual.getClass());
    }

    private static enum TwoConstantEnum {
        CONSTANT1,
        CONSTANT2;

    }

    private static enum OneConstantEnum {
        CONSTANT1;

    }

    private static enum EmptyEnum {

    }
}

