/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph.testing;

import com.google.common.graph.ImmutableNetwork;
import com.google.common.graph.MutableNetwork;
import com.google.common.graph.NetworkBuilder;

public final class TestNetworkBuilder<N, E> {
    private final MutableNetwork<N, E> graph;

    private TestNetworkBuilder(MutableNetwork<N, E> graph) {
        this.graph = graph;
    }

    public static <N, E> TestNetworkBuilder<N, E> init(NetworkBuilder<? super N, ? super E> builder) {
        return new TestNetworkBuilder<N, E>(builder.build());
    }

    public TestNetworkBuilder<N, E> addNode(N node) {
        this.graph.addNode(node);
        return this;
    }

    public TestNetworkBuilder<N, E> addEdge(E edge, N node1, N node2) {
        this.graph.addEdge(edge, node1, node2);
        return this;
    }

    public ImmutableNetwork<N, E> toImmutableNetwork() {
        return ImmutableNetwork.copyOf(this.graph);
    }
}

