/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.testing.Helpers;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;

@GwtCompatible
public class HelpersTest
extends TestCase {
    public void testNullsBeforeB() {
        Helpers.testComparator((Comparator)Helpers.NullsBeforeB.INSTANCE, (Object[])new String[]{"a", "azzzzzz", null, "b", "c"});
    }

    public void testIsEmpty_iterable() {
        ArrayList<String> list = new ArrayList<String>();
        Helpers.assertEmpty(list);
        list.add("a");
        try {
            Helpers.assertEmpty(list);
            HelpersTest.fail();
        }
        catch (AssertionFailedError assertionFailedError) {
            // empty catch block
        }
    }

    public void testIsEmpty_map() {
        HashMap<String, String> map = new HashMap<String, String>();
        Helpers.assertEmpty(map);
        map.put("a", "b");
        try {
            Helpers.assertEmpty(map);
            HelpersTest.fail();
        }
        catch (AssertionFailedError assertionFailedError) {
            // empty catch block
        }
    }

    public void testAssertEqualInOrder() {
        List<String> list = Arrays.asList("a", "b", "c");
        Helpers.assertEqualInOrder(list, list);
        List<String> fewer = Arrays.asList("a", "b");
        try {
            Helpers.assertEqualInOrder(list, fewer);
            HelpersTest.fail();
        }
        catch (AssertionFailedError assertionFailedError) {
            // empty catch block
        }
        try {
            Helpers.assertEqualInOrder(fewer, list);
            HelpersTest.fail();
        }
        catch (AssertionFailedError assertionFailedError) {
            // empty catch block
        }
        List<String> differentOrder = Arrays.asList("a", "c", "b");
        try {
            Helpers.assertEqualInOrder(list, differentOrder);
            HelpersTest.fail();
        }
        catch (AssertionFailedError assertionFailedError) {
            // empty catch block
        }
        List<String> differentContents = Arrays.asList("a", "b", "C");
        try {
            Helpers.assertEqualInOrder(list, differentContents);
            HelpersTest.fail();
        }
        catch (AssertionFailedError assertionFailedError) {
            // empty catch block
        }
    }

    public void testAssertContentsInOrder() {
        List<String> list = Arrays.asList("a", "b", "c");
        Helpers.assertContentsInOrder(list, (Object[])new Object[]{"a", "b", "c"});
        try {
            Helpers.assertContentsInOrder(list, (Object[])new Object[]{"a", "b"});
            HelpersTest.fail();
        }
        catch (AssertionFailedError assertionFailedError) {
            // empty catch block
        }
        try {
            Helpers.assertContentsInOrder(list, (Object[])new Object[]{"a", "b", "c", "d"});
            HelpersTest.fail();
        }
        catch (AssertionFailedError assertionFailedError) {
            // empty catch block
        }
        try {
            Helpers.assertContentsInOrder(list, (Object[])new Object[]{"a", "c", "b"});
            HelpersTest.fail();
        }
        catch (AssertionFailedError assertionFailedError) {
            // empty catch block
        }
        try {
            Helpers.assertContentsInOrder(list, (Object[])new Object[]{"a", "B", "c"});
            HelpersTest.fail();
        }
        catch (AssertionFailedError assertionFailedError) {
            // empty catch block
        }
    }

    public void testAssertContains() {
        List<String> list = Arrays.asList("a", "b");
        Helpers.assertContains(list, (Object)"a");
        Helpers.assertContains(list, (Object)"b");
        try {
            Helpers.assertContains(list, (Object)"c");
            HelpersTest.fail();
        }
        catch (AssertionFailedError assertionFailedError) {
            // empty catch block
        }
    }

    public void testAssertContainsAllOf() {
        List<String> list = Arrays.asList("a", "a", "b", "c");
        Helpers.assertContainsAllOf(list, (Object[])new Object[]{"a"});
        Helpers.assertContainsAllOf(list, (Object[])new Object[]{"a", "a"});
        Helpers.assertContainsAllOf(list, (Object[])new Object[]{"a", "b", "c"});
        Helpers.assertContainsAllOf(list, (Object[])new Object[]{"a", "b", "c", "a"});
        try {
            Helpers.assertContainsAllOf(list, (Object[])new Object[]{"d"});
            HelpersTest.fail();
        }
        catch (AssertionFailedError assertionFailedError) {
            // empty catch block
        }
        try {
            Helpers.assertContainsAllOf(list, (Object[])new Object[]{"a", "b", "c", "d"});
            HelpersTest.fail();
        }
        catch (AssertionFailedError assertionFailedError) {
            // empty catch block
        }
        try {
            Helpers.assertContainsAllOf(list, (Object[])new Object[]{"a", "a", "a"});
            HelpersTest.fail();
        }
        catch (AssertionFailedError assertionFailedError) {
            // empty catch block
        }
    }
}

