/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.MapTestSuiteBuilder;
import com.google.common.collect.testing.NavigableMapTestSuiteBuilder;
import com.google.common.collect.testing.SafeTreeMap;
import com.google.common.collect.testing.SortedMapInterfaceTest;
import com.google.common.collect.testing.TestSortedMapGenerator;
import com.google.common.collect.testing.TestStringSortedMapGenerator;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.Feature;
import com.google.common.collect.testing.features.MapFeature;
import com.google.common.testing.SerializableTester;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class SafeTreeMapTest
extends TestCase {
    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(SafeTreeMapTest.class);
        suite.addTest((Test)((MapTestSuiteBuilder)((MapTestSuiteBuilder)NavigableMapTestSuiteBuilder.using((TestSortedMapGenerator)new TestStringSortedMapGenerator(){

            protected SortedMap<String, String> create(Map.Entry<String, String>[] entries) {
                SafeTreeMap map = new SafeTreeMap((Comparator)Ordering.natural());
                for (Map.Entry<String, String> entry : entries) {
                    map.put(entry.getKey(), entry.getValue());
                }
                return map;
            }
        }).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.KNOWN_ORDER, CollectionFeature.SERIALIZABLE, MapFeature.ALLOWS_NULL_VALUES, CollectionFeature.SUPPORTS_ITERATOR_REMOVE, MapFeature.GENERAL_PURPOSE})).named("SafeTreeMap with natural comparator")).createTestSuite());
        suite.addTest((Test)((MapTestSuiteBuilder)((MapTestSuiteBuilder)NavigableMapTestSuiteBuilder.using((TestSortedMapGenerator)new TestStringSortedMapGenerator(){

            protected SortedMap<String, String> create(Map.Entry<String, String>[] entries) {
                SafeTreeMap map = new SafeTreeMap((Comparator)Helpers.NullsBeforeTwo.INSTANCE);
                for (Map.Entry<String, String> entry : entries) {
                    map.put(entry.getKey(), entry.getValue());
                }
                return map;
            }

            public Iterable<Map.Entry<String, String>> order(List<Map.Entry<String, String>> insertionOrder) {
                Collections.sort(insertionOrder, Helpers.entryComparator((Comparator)Helpers.NullsBeforeTwo.INSTANCE));
                return insertionOrder;
            }
        }).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.KNOWN_ORDER, MapFeature.ALLOWS_NULL_KEYS, MapFeature.ALLOWS_NULL_VALUES, MapFeature.ALLOWS_ANY_NULL_QUERIES, MapFeature.GENERAL_PURPOSE, CollectionFeature.SUPPORTS_ITERATOR_REMOVE, CollectionFeature.SERIALIZABLE})).named("SafeTreeMap with null-friendly comparator")).createTestSuite());
        return suite;
    }

    @GwtIncompatible
    public void testViewSerialization() {
        ImmutableSortedMap map = ImmutableSortedMap.of((Comparable)((Object)"one"), (Object)1, (Comparable)((Object)"two"), (Object)2, (Comparable)((Object)"three"), (Object)3);
        SerializableTester.reserializeAndAssert(map.entrySet());
        SerializableTester.reserializeAndAssert(map.keySet());
        SafeTreeMapTest.assertEquals((Object)Lists.newArrayList(map.values()), (Object)Lists.newArrayList((Iterable)((Iterable)SerializableTester.reserialize(map.values()))));
    }

    @GwtIncompatible
    public static class ReserializedMapTests
    extends SortedMapInterfaceTest<String, Integer> {
        public ReserializedMapTests() {
            super(false, true, true, true, true);
        }

        protected SortedMap<String, Integer> makePopulatedMap() {
            SafeTreeMap map = new SafeTreeMap();
            map.put("one", 1);
            map.put("two", 2);
            map.put("three", 3);
            return (SortedMap)SerializableTester.reserialize((Object)map);
        }

        protected SortedMap<String, Integer> makeEmptyMap() throws UnsupportedOperationException {
            SafeTreeMap map = new SafeTreeMap();
            return (SortedMap)SerializableTester.reserialize((Object)map);
        }

        protected String getKeyNotInPopulatedMap() {
            return "minus one";
        }

        protected Integer getValueNotInPopulatedMap() {
            return -1;
        }
    }
}

