/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.caliper.BeforeExperiment;
import com.google.caliper.Benchmark;
import com.google.caliper.Param;
import com.google.common.base.Ascii;
import com.google.common.collect.Lists;
import com.google.common.primitives.Chars;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Random;

public class AsciiBenchmark {
    private static String ALPHA = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    private static String NONALPHA = "0123456789`~-_=+[]{}|;:',.<>/?!@#$%^&*()\"\\";
    @Param(value={"20", "2000"})
    int size;
    @Param(value={"2", "20"})
    int nonAlphaRatio;
    @Param
    boolean noWorkToDo;
    Random random;
    String testString;

    @BeforeExperiment
    void setUp() {
        int i;
        this.random = new Random();
        int nonAlpha = this.size / this.nonAlphaRatio;
        int alpha = this.size - nonAlpha;
        ArrayList chars = Lists.newArrayListWithCapacity((int)this.size);
        for (i = 0; i < alpha; ++i) {
            chars.add(Character.valueOf(this.randomAlpha()));
        }
        for (i = 0; i < nonAlpha; ++i) {
            chars.add(Character.valueOf(this.randomNonAlpha()));
        }
        Collections.shuffle(chars, this.random);
        char[] array = Chars.toArray((Collection)chars);
        this.testString = new String(array);
    }

    private char randomAlpha() {
        return ALPHA.charAt(this.random.nextInt(ALPHA.length()));
    }

    private char randomNonAlpha() {
        return NONALPHA.charAt(this.random.nextInt(NONALPHA.length()));
    }

    @Benchmark
    int asciiStringToUpperCase(int reps) {
        String string = this.noWorkToDo ? Ascii.toUpperCase((String)this.testString) : this.testString;
        int dummy = 0;
        for (int i = 0; i < reps; ++i) {
            dummy += Ascii.toUpperCase((String)string).length();
        }
        return dummy;
    }

    @Benchmark
    int asciiCharSequenceToUpperCase(int reps) {
        String string = this.noWorkToDo ? AsciiBenchmark.charSequenceToUpperCase(this.testString) : this.testString;
        int dummy = 0;
        for (int i = 0; i < reps; ++i) {
            dummy += AsciiBenchmark.charSequenceToUpperCase(string).length();
        }
        return dummy;
    }

    @Benchmark
    int stringToUpperCase(int reps) {
        String string = this.noWorkToDo ? this.testString.toUpperCase(Locale.US) : this.testString;
        int dummy = 0;
        for (int i = 0; i < reps; ++i) {
            dummy += string.toUpperCase(Locale.US).length();
        }
        return dummy;
    }

    @Benchmark
    boolean equalsIgnoreCaseCharSequence(int reps) {
        String upperString = this.testString.toUpperCase();
        StringBuilder testSeq = new StringBuilder(this.testString);
        StringBuilder upperSeq = new StringBuilder(upperString);
        CharSequence[] lhs = new CharSequence[]{this.testString, testSeq, this.testString, testSeq};
        CharSequence[] rhs = new CharSequence[]{upperString, upperString, upperSeq, upperSeq};
        boolean dummy = false;
        for (int i = 0; i < reps; ++i) {
            dummy ^= Ascii.equalsIgnoreCase((CharSequence)lhs[i & 3], (CharSequence)rhs[i & 3]);
        }
        return dummy;
    }

    @Benchmark
    boolean equalsIgnoreCaseStringOnly(int reps) {
        String lhs = this.testString;
        String rhs = this.testString.toUpperCase();
        boolean dummy = false;
        for (int i = 0; i < reps; ++i) {
            dummy ^= Ascii.equalsIgnoreCase((CharSequence)lhs, (CharSequence)rhs);
        }
        return dummy;
    }

    @Benchmark
    boolean equalsIgnoreCaseJDK(int reps) {
        String lhs = this.testString;
        String rhs = this.testString.toUpperCase();
        boolean dummy = false;
        for (int i = 0; i < reps; ++i) {
            dummy ^= lhs.equalsIgnoreCase(rhs);
        }
        return dummy;
    }

    @Benchmark
    boolean isUpperCase(int reps) {
        char[] chars = this.testString.toCharArray();
        boolean dummy = false;
        for (int i = 0; i < reps; ++i) {
            for (int n = 0; n < chars.length; ++n) {
                dummy ^= Ascii.isUpperCase((char)chars[n]);
            }
        }
        return dummy;
    }

    static String charSequenceToUpperCase(CharSequence chars) {
        int length = chars.length();
        StringBuilder builder = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            builder.append(Ascii.toUpperCase((char)chars.charAt(i)));
        }
        return builder.toString();
    }
}

