/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.cache;

import com.google.common.cache.AbstractLoadingCache;
import com.google.common.util.concurrent.ExecutionError;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import junit.framework.TestCase;

public class AbstractLoadingCacheTest
extends TestCase {
    public void testGetUnchecked_checked() {
        final Exception cause = new Exception();
        final AtomicReference<Object> valueRef = new AtomicReference<Object>();
        AbstractLoadingCache<Object, Object> cache = new AbstractLoadingCache<Object, Object>(){

            public Object get(Object key) throws ExecutionException {
                Object v = valueRef.get();
                if (v == null) {
                    throw new ExecutionException(cause);
                }
                return v;
            }

            public Object getIfPresent(Object key) {
                return valueRef.get();
            }
        };
        try {
            cache.getUnchecked(new Object());
            AbstractLoadingCacheTest.fail();
        }
        catch (UncheckedExecutionException expected) {
            AbstractLoadingCacheTest.assertEquals((Object)cause, (Object)expected.getCause());
        }
        Object newValue = new Object();
        valueRef.set(newValue);
        AbstractLoadingCacheTest.assertSame((Object)newValue, (Object)cache.getUnchecked(new Object()));
    }

    public void testGetUnchecked_unchecked() {
        final RuntimeException cause = new RuntimeException();
        final AtomicReference<Object> valueRef = new AtomicReference<Object>();
        AbstractLoadingCache<Object, Object> cache = new AbstractLoadingCache<Object, Object>(){

            public Object get(Object key) throws ExecutionException {
                Object v = valueRef.get();
                if (v == null) {
                    throw new ExecutionException(cause);
                }
                return v;
            }

            public Object getIfPresent(Object key) {
                return valueRef.get();
            }
        };
        try {
            cache.getUnchecked(new Object());
            AbstractLoadingCacheTest.fail();
        }
        catch (UncheckedExecutionException expected) {
            AbstractLoadingCacheTest.assertEquals((Object)cause, (Object)expected.getCause());
        }
        Object newValue = new Object();
        valueRef.set(newValue);
        AbstractLoadingCacheTest.assertSame((Object)newValue, (Object)cache.getUnchecked(new Object()));
    }

    public void testGetUnchecked_error() {
        final Error cause = new Error();
        final AtomicReference<Object> valueRef = new AtomicReference<Object>();
        AbstractLoadingCache<Object, Object> cache = new AbstractLoadingCache<Object, Object>(){

            public Object get(Object key) throws ExecutionException {
                Object v = valueRef.get();
                if (v == null) {
                    throw new ExecutionError(cause);
                }
                return v;
            }

            public Object getIfPresent(Object key) {
                return valueRef.get();
            }
        };
        try {
            cache.getUnchecked(new Object());
            AbstractLoadingCacheTest.fail();
        }
        catch (ExecutionError expected) {
            AbstractLoadingCacheTest.assertEquals((Object)cause, (Object)expected.getCause());
        }
        Object newValue = new Object();
        valueRef.set(newValue);
        AbstractLoadingCacheTest.assertSame((Object)newValue, (Object)cache.getUnchecked(new Object()));
    }

    public void testGetUnchecked_otherThrowable() {
        final Throwable cause = new Throwable();
        final AtomicReference<Object> valueRef = new AtomicReference<Object>();
        AbstractLoadingCache<Object, Object> cache = new AbstractLoadingCache<Object, Object>(){

            public Object get(Object key) throws ExecutionException {
                Object v = valueRef.get();
                if (v == null) {
                    throw new ExecutionException(cause);
                }
                return v;
            }

            public Object getIfPresent(Object key) {
                return valueRef.get();
            }
        };
        try {
            cache.getUnchecked(new Object());
            AbstractLoadingCacheTest.fail();
        }
        catch (UncheckedExecutionException expected) {
            AbstractLoadingCacheTest.assertEquals((Object)cause, (Object)expected.getCause());
        }
        Object newValue = new Object();
        valueRef.set(newValue);
        AbstractLoadingCacheTest.assertSame((Object)newValue, (Object)cache.getUnchecked(new Object()));
    }
}

