/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.cache;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheBuilderSpec;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.LocalCache;
import com.google.common.cache.TestingWeighers;
import com.google.common.testing.EqualsTester;
import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;

public class CacheBuilderSpecTest
extends TestCase {
    public void testParse_empty() {
        CacheBuilderSpec spec = CacheBuilderSpec.parse((String)"");
        CacheBuilderSpecTest.assertNull((Object)spec.initialCapacity);
        CacheBuilderSpecTest.assertNull((Object)spec.maximumSize);
        CacheBuilderSpecTest.assertNull((Object)spec.maximumWeight);
        CacheBuilderSpecTest.assertNull((Object)spec.concurrencyLevel);
        CacheBuilderSpecTest.assertNull((Object)spec.keyStrength);
        CacheBuilderSpecTest.assertNull((Object)spec.valueStrength);
        CacheBuilderSpecTest.assertNull((Object)((Object)spec.writeExpirationTimeUnit));
        CacheBuilderSpecTest.assertNull((Object)((Object)spec.accessExpirationTimeUnit));
        CacheBuilderSpecTest.assertCacheBuilderEquivalence(CacheBuilder.newBuilder(), CacheBuilder.from((CacheBuilderSpec)spec));
    }

    public void testParse_initialCapacity() {
        CacheBuilderSpec spec = CacheBuilderSpec.parse((String)"initialCapacity=10");
        CacheBuilderSpecTest.assertEquals((int)10, (int)spec.initialCapacity);
        CacheBuilderSpecTest.assertNull((Object)spec.maximumSize);
        CacheBuilderSpecTest.assertNull((Object)spec.maximumWeight);
        CacheBuilderSpecTest.assertNull((Object)spec.concurrencyLevel);
        CacheBuilderSpecTest.assertNull((Object)spec.keyStrength);
        CacheBuilderSpecTest.assertNull((Object)spec.valueStrength);
        CacheBuilderSpecTest.assertNull((Object)((Object)spec.writeExpirationTimeUnit));
        CacheBuilderSpecTest.assertNull((Object)((Object)spec.accessExpirationTimeUnit));
        CacheBuilderSpecTest.assertCacheBuilderEquivalence(CacheBuilder.newBuilder().initialCapacity(10), CacheBuilder.from((CacheBuilderSpec)spec));
    }

    public void testParse_initialCapacityRepeated() {
        try {
            CacheBuilderSpec.parse((String)"initialCapacity=10, initialCapacity=20");
            CacheBuilderSpecTest.fail((String)"Expected exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testParse_maximumSize() {
        CacheBuilderSpec spec = CacheBuilderSpec.parse((String)"maximumSize=9000");
        CacheBuilderSpecTest.assertNull((Object)spec.initialCapacity);
        CacheBuilderSpecTest.assertEquals((long)9000L, (long)spec.maximumSize);
        CacheBuilderSpecTest.assertNull((Object)spec.concurrencyLevel);
        CacheBuilderSpecTest.assertNull((Object)spec.keyStrength);
        CacheBuilderSpecTest.assertNull((Object)spec.valueStrength);
        CacheBuilderSpecTest.assertNull((Object)((Object)spec.writeExpirationTimeUnit));
        CacheBuilderSpecTest.assertNull((Object)((Object)spec.accessExpirationTimeUnit));
        CacheBuilderSpecTest.assertCacheBuilderEquivalence(CacheBuilder.newBuilder().maximumSize(9000L), CacheBuilder.from((CacheBuilderSpec)spec));
    }

    public void testParse_maximumSizeRepeated() {
        try {
            CacheBuilderSpec.parse((String)"maximumSize=10, maximumSize=20");
            CacheBuilderSpecTest.fail((String)"Expected exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testParse_maximumWeight() {
        CacheBuilderSpec spec = CacheBuilderSpec.parse((String)"maximumWeight=9000");
        CacheBuilderSpecTest.assertNull((Object)spec.initialCapacity);
        CacheBuilderSpecTest.assertEquals((long)9000L, (long)spec.maximumWeight);
        CacheBuilderSpecTest.assertNull((Object)spec.concurrencyLevel);
        CacheBuilderSpecTest.assertNull((Object)spec.keyStrength);
        CacheBuilderSpecTest.assertNull((Object)spec.valueStrength);
        CacheBuilderSpecTest.assertNull((Object)((Object)spec.writeExpirationTimeUnit));
        CacheBuilderSpecTest.assertNull((Object)((Object)spec.accessExpirationTimeUnit));
        CacheBuilderSpecTest.assertCacheBuilderEquivalence(CacheBuilder.newBuilder().maximumWeight(9000L), CacheBuilder.from((CacheBuilderSpec)spec));
    }

    public void testParse_maximumWeightRepeated() {
        try {
            CacheBuilderSpec.parse((String)"maximumWeight=10, maximumWeight=20");
            CacheBuilderSpecTest.fail((String)"Expected exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testParse_maximumSizeAndMaximumWeight() {
        try {
            CacheBuilderSpec.parse((String)"maximumSize=10, maximumWeight=20");
            CacheBuilderSpecTest.fail((String)"Expected exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testParse_concurrencyLevel() {
        CacheBuilderSpec spec = CacheBuilderSpec.parse((String)"concurrencyLevel=32");
        CacheBuilderSpecTest.assertNull((Object)spec.initialCapacity);
        CacheBuilderSpecTest.assertNull((Object)spec.maximumSize);
        CacheBuilderSpecTest.assertNull((Object)spec.maximumWeight);
        CacheBuilderSpecTest.assertEquals((int)32, (int)spec.concurrencyLevel);
        CacheBuilderSpecTest.assertNull((Object)spec.keyStrength);
        CacheBuilderSpecTest.assertNull((Object)spec.valueStrength);
        CacheBuilderSpecTest.assertNull((Object)((Object)spec.writeExpirationTimeUnit));
        CacheBuilderSpecTest.assertNull((Object)((Object)spec.accessExpirationTimeUnit));
        CacheBuilderSpecTest.assertCacheBuilderEquivalence(CacheBuilder.newBuilder().concurrencyLevel(32), CacheBuilder.from((CacheBuilderSpec)spec));
    }

    public void testParse_concurrencyLevelRepeated() {
        try {
            CacheBuilderSpec.parse((String)"concurrencyLevel=10, concurrencyLevel=20");
            CacheBuilderSpecTest.fail((String)"Expected exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testParse_weakKeys() {
        CacheBuilderSpec spec = CacheBuilderSpec.parse((String)"weakKeys");
        CacheBuilderSpecTest.assertNull((Object)spec.initialCapacity);
        CacheBuilderSpecTest.assertNull((Object)spec.maximumSize);
        CacheBuilderSpecTest.assertNull((Object)spec.maximumWeight);
        CacheBuilderSpecTest.assertNull((Object)spec.concurrencyLevel);
        CacheBuilderSpecTest.assertEquals((Object)LocalCache.Strength.WEAK, (Object)spec.keyStrength);
        CacheBuilderSpecTest.assertNull((Object)spec.valueStrength);
        CacheBuilderSpecTest.assertNull((Object)((Object)spec.writeExpirationTimeUnit));
        CacheBuilderSpecTest.assertNull((Object)((Object)spec.accessExpirationTimeUnit));
        CacheBuilderSpecTest.assertCacheBuilderEquivalence(CacheBuilder.newBuilder().weakKeys(), CacheBuilder.from((CacheBuilderSpec)spec));
    }

    public void testParse_weakKeysCannotHaveValue() {
        try {
            CacheBuilderSpec.parse((String)"weakKeys=true");
            CacheBuilderSpecTest.fail((String)"Expected exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testParse_repeatedKeyStrength() {
        try {
            CacheBuilderSpec.parse((String)"weakKeys, weakKeys");
            CacheBuilderSpecTest.fail((String)"Expected exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testParse_softValues() {
        CacheBuilderSpec spec = CacheBuilderSpec.parse((String)"softValues");
        CacheBuilderSpecTest.assertNull((Object)spec.initialCapacity);
        CacheBuilderSpecTest.assertNull((Object)spec.maximumSize);
        CacheBuilderSpecTest.assertNull((Object)spec.maximumWeight);
        CacheBuilderSpecTest.assertNull((Object)spec.concurrencyLevel);
        CacheBuilderSpecTest.assertNull((Object)spec.keyStrength);
        CacheBuilderSpecTest.assertEquals((Object)LocalCache.Strength.SOFT, (Object)spec.valueStrength);
        CacheBuilderSpecTest.assertNull((Object)((Object)spec.writeExpirationTimeUnit));
        CacheBuilderSpecTest.assertNull((Object)((Object)spec.accessExpirationTimeUnit));
        CacheBuilderSpecTest.assertCacheBuilderEquivalence(CacheBuilder.newBuilder().softValues(), CacheBuilder.from((CacheBuilderSpec)spec));
    }

    public void testParse_softValuesCannotHaveValue() {
        try {
            CacheBuilderSpec.parse((String)"softValues=true");
            CacheBuilderSpecTest.fail((String)"Expected exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testParse_weakValues() {
        CacheBuilderSpec spec = CacheBuilderSpec.parse((String)"weakValues");
        CacheBuilderSpecTest.assertNull((Object)spec.initialCapacity);
        CacheBuilderSpecTest.assertNull((Object)spec.maximumSize);
        CacheBuilderSpecTest.assertNull((Object)spec.maximumWeight);
        CacheBuilderSpecTest.assertNull((Object)spec.concurrencyLevel);
        CacheBuilderSpecTest.assertNull((Object)spec.keyStrength);
        CacheBuilderSpecTest.assertEquals((Object)LocalCache.Strength.WEAK, (Object)spec.valueStrength);
        CacheBuilderSpecTest.assertNull((Object)((Object)spec.writeExpirationTimeUnit));
        CacheBuilderSpecTest.assertNull((Object)((Object)spec.accessExpirationTimeUnit));
        CacheBuilderSpecTest.assertCacheBuilderEquivalence(CacheBuilder.newBuilder().weakValues(), CacheBuilder.from((CacheBuilderSpec)spec));
    }

    public void testParse_weakValuesCannotHaveValue() {
        try {
            CacheBuilderSpec.parse((String)"weakValues=true");
            CacheBuilderSpecTest.fail((String)"Expected exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testParse_repeatedValueStrength() {
        try {
            CacheBuilderSpec.parse((String)"softValues, softValues");
            CacheBuilderSpecTest.fail((String)"Expected exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            CacheBuilderSpec.parse((String)"softValues, weakValues");
            CacheBuilderSpecTest.fail((String)"Expected exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            CacheBuilderSpec.parse((String)"weakValues, softValues");
            CacheBuilderSpecTest.fail((String)"Expected exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            CacheBuilderSpec.parse((String)"weakValues, weakValues");
            CacheBuilderSpecTest.fail((String)"Expected exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testParse_writeExpirationDays() {
        CacheBuilderSpec spec = CacheBuilderSpec.parse((String)"expireAfterWrite=10d");
        CacheBuilderSpecTest.assertNull((Object)spec.initialCapacity);
        CacheBuilderSpecTest.assertNull((Object)spec.maximumSize);
        CacheBuilderSpecTest.assertNull((Object)spec.maximumWeight);
        CacheBuilderSpecTest.assertNull((Object)spec.concurrencyLevel);
        CacheBuilderSpecTest.assertNull((Object)spec.keyStrength);
        CacheBuilderSpecTest.assertNull((Object)spec.valueStrength);
        CacheBuilderSpecTest.assertEquals((Object)((Object)TimeUnit.DAYS), (Object)((Object)spec.writeExpirationTimeUnit));
        CacheBuilderSpecTest.assertEquals((long)10L, (long)spec.writeExpirationDuration);
        CacheBuilderSpecTest.assertNull((Object)((Object)spec.accessExpirationTimeUnit));
        CacheBuilderSpecTest.assertCacheBuilderEquivalence(CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.DAYS), CacheBuilder.from((CacheBuilderSpec)spec));
    }

    public void testParse_writeExpirationHours() {
        CacheBuilderSpec spec = CacheBuilderSpec.parse((String)"expireAfterWrite=150h");
        CacheBuilderSpecTest.assertEquals((Object)((Object)TimeUnit.HOURS), (Object)((Object)spec.writeExpirationTimeUnit));
        CacheBuilderSpecTest.assertEquals((long)150L, (long)spec.writeExpirationDuration);
        CacheBuilderSpecTest.assertCacheBuilderEquivalence(CacheBuilder.newBuilder().expireAfterWrite(150L, TimeUnit.HOURS), CacheBuilder.from((CacheBuilderSpec)spec));
    }

    public void testParse_writeExpirationMinutes() {
        CacheBuilderSpec spec = CacheBuilderSpec.parse((String)"expireAfterWrite=10m");
        CacheBuilderSpecTest.assertEquals((Object)((Object)TimeUnit.MINUTES), (Object)((Object)spec.writeExpirationTimeUnit));
        CacheBuilderSpecTest.assertEquals((long)10L, (long)spec.writeExpirationDuration);
        CacheBuilderSpecTest.assertCacheBuilderEquivalence(CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.MINUTES), CacheBuilder.from((CacheBuilderSpec)spec));
    }

    public void testParse_writeExpirationSeconds() {
        CacheBuilderSpec spec = CacheBuilderSpec.parse((String)"expireAfterWrite=10s");
        CacheBuilderSpecTest.assertEquals((Object)((Object)TimeUnit.SECONDS), (Object)((Object)spec.writeExpirationTimeUnit));
        CacheBuilderSpecTest.assertEquals((long)10L, (long)spec.writeExpirationDuration);
        CacheBuilderSpecTest.assertCacheBuilderEquivalence(CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.SECONDS), CacheBuilder.from((CacheBuilderSpec)spec));
    }

    public void testParse_writeExpirationRepeated() {
        try {
            CacheBuilderSpec.parse((String)"expireAfterWrite=10s,expireAfterWrite=10m");
            CacheBuilderSpecTest.fail((String)"Expected exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testParse_accessExpirationDays() {
        CacheBuilderSpec spec = CacheBuilderSpec.parse((String)"expireAfterAccess=10d");
        CacheBuilderSpecTest.assertNull((Object)spec.initialCapacity);
        CacheBuilderSpecTest.assertNull((Object)spec.maximumSize);
        CacheBuilderSpecTest.assertNull((Object)spec.maximumWeight);
        CacheBuilderSpecTest.assertNull((Object)spec.concurrencyLevel);
        CacheBuilderSpecTest.assertNull((Object)spec.keyStrength);
        CacheBuilderSpecTest.assertNull((Object)spec.valueStrength);
        CacheBuilderSpecTest.assertNull((Object)((Object)spec.writeExpirationTimeUnit));
        CacheBuilderSpecTest.assertEquals((Object)((Object)TimeUnit.DAYS), (Object)((Object)spec.accessExpirationTimeUnit));
        CacheBuilderSpecTest.assertEquals((long)10L, (long)spec.accessExpirationDuration);
        CacheBuilderSpecTest.assertCacheBuilderEquivalence(CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.DAYS), CacheBuilder.from((CacheBuilderSpec)spec));
    }

    public void testParse_accessExpirationHours() {
        CacheBuilderSpec spec = CacheBuilderSpec.parse((String)"expireAfterAccess=150h");
        CacheBuilderSpecTest.assertEquals((Object)((Object)TimeUnit.HOURS), (Object)((Object)spec.accessExpirationTimeUnit));
        CacheBuilderSpecTest.assertEquals((long)150L, (long)spec.accessExpirationDuration);
        CacheBuilderSpecTest.assertCacheBuilderEquivalence(CacheBuilder.newBuilder().expireAfterAccess(150L, TimeUnit.HOURS), CacheBuilder.from((CacheBuilderSpec)spec));
    }

    public void testParse_accessExpirationMinutes() {
        CacheBuilderSpec spec = CacheBuilderSpec.parse((String)"expireAfterAccess=10m");
        CacheBuilderSpecTest.assertEquals((Object)((Object)TimeUnit.MINUTES), (Object)((Object)spec.accessExpirationTimeUnit));
        CacheBuilderSpecTest.assertEquals((long)10L, (long)spec.accessExpirationDuration);
        CacheBuilderSpecTest.assertCacheBuilderEquivalence(CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES), CacheBuilder.from((CacheBuilderSpec)spec));
    }

    public void testParse_accessExpirationSeconds() {
        CacheBuilderSpec spec = CacheBuilderSpec.parse((String)"expireAfterAccess=10s");
        CacheBuilderSpecTest.assertEquals((Object)((Object)TimeUnit.SECONDS), (Object)((Object)spec.accessExpirationTimeUnit));
        CacheBuilderSpecTest.assertEquals((long)10L, (long)spec.accessExpirationDuration);
        CacheBuilderSpecTest.assertCacheBuilderEquivalence(CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.SECONDS), CacheBuilder.from((CacheBuilderSpec)spec));
    }

    public void testParse_accessExpirationRepeated() {
        try {
            CacheBuilderSpec.parse((String)"expireAfterAccess=10s,expireAfterAccess=10m");
            CacheBuilderSpecTest.fail((String)"Expected exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testParse_recordStats() {
        CacheBuilderSpec spec = CacheBuilderSpec.parse((String)"recordStats");
        CacheBuilderSpecTest.assertTrue((boolean)spec.recordStats);
        CacheBuilderSpecTest.assertCacheBuilderEquivalence(CacheBuilder.newBuilder().recordStats(), CacheBuilder.from((CacheBuilderSpec)spec));
    }

    public void testParse_recordStatsValueSpecified() {
        try {
            CacheBuilderSpec.parse((String)"recordStats=True");
            CacheBuilderSpecTest.fail((String)"Expected exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testParse_recordStatsRepeated() {
        try {
            CacheBuilderSpec.parse((String)"recordStats,recordStats");
            CacheBuilderSpecTest.fail((String)"Expected exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testParse_accessExpirationAndWriteExpiration() {
        CacheBuilderSpec spec = CacheBuilderSpec.parse((String)"expireAfterAccess=10s,expireAfterWrite=9m");
        CacheBuilderSpecTest.assertEquals((Object)((Object)TimeUnit.MINUTES), (Object)((Object)spec.writeExpirationTimeUnit));
        CacheBuilderSpecTest.assertEquals((long)9L, (long)spec.writeExpirationDuration);
        CacheBuilderSpecTest.assertEquals((Object)((Object)TimeUnit.SECONDS), (Object)((Object)spec.accessExpirationTimeUnit));
        CacheBuilderSpecTest.assertEquals((long)10L, (long)spec.accessExpirationDuration);
        CacheBuilderSpecTest.assertCacheBuilderEquivalence(CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.SECONDS).expireAfterWrite(9L, TimeUnit.MINUTES), CacheBuilder.from((CacheBuilderSpec)spec));
    }

    public void testParse_multipleKeys() {
        CacheBuilderSpec spec = CacheBuilderSpec.parse((String)"initialCapacity=10,maximumSize=20,concurrencyLevel=30,weakKeys,weakValues,expireAfterAccess=10m,expireAfterWrite=1h");
        CacheBuilderSpecTest.assertEquals((int)10, (int)spec.initialCapacity);
        CacheBuilderSpecTest.assertEquals((int)20, (int)spec.maximumSize.intValue());
        CacheBuilderSpecTest.assertNull((Object)spec.maximumWeight);
        CacheBuilderSpecTest.assertEquals((int)30, (int)spec.concurrencyLevel);
        CacheBuilderSpecTest.assertEquals((Object)LocalCache.Strength.WEAK, (Object)spec.keyStrength);
        CacheBuilderSpecTest.assertEquals((Object)LocalCache.Strength.WEAK, (Object)spec.valueStrength);
        CacheBuilderSpecTest.assertEquals((Object)((Object)TimeUnit.HOURS), (Object)((Object)spec.writeExpirationTimeUnit));
        CacheBuilderSpecTest.assertEquals((Object)((Object)TimeUnit.MINUTES), (Object)((Object)spec.accessExpirationTimeUnit));
        CacheBuilderSpecTest.assertEquals((long)1L, (long)spec.writeExpirationDuration);
        CacheBuilderSpecTest.assertEquals((long)10L, (long)spec.accessExpirationDuration);
        CacheBuilder expected = CacheBuilder.newBuilder().initialCapacity(10).maximumSize(20L).concurrencyLevel(30).weakKeys().weakValues().expireAfterAccess(10L, TimeUnit.MINUTES).expireAfterWrite(1L, TimeUnit.HOURS);
        CacheBuilderSpecTest.assertCacheBuilderEquivalence(expected, CacheBuilder.from((CacheBuilderSpec)spec));
    }

    public void testParse_whitespaceAllowed() {
        CacheBuilderSpec spec = CacheBuilderSpec.parse((String)" initialCapacity=10,\nmaximumSize=20,\t\rweakKeys \t ,softValues \n , \r  expireAfterWrite \t =  15s\n\n");
        CacheBuilderSpecTest.assertEquals((int)10, (int)spec.initialCapacity);
        CacheBuilderSpecTest.assertEquals((int)20, (int)spec.maximumSize.intValue());
        CacheBuilderSpecTest.assertNull((Object)spec.maximumWeight);
        CacheBuilderSpecTest.assertNull((Object)spec.concurrencyLevel);
        CacheBuilderSpecTest.assertEquals((Object)LocalCache.Strength.WEAK, (Object)spec.keyStrength);
        CacheBuilderSpecTest.assertEquals((Object)LocalCache.Strength.SOFT, (Object)spec.valueStrength);
        CacheBuilderSpecTest.assertEquals((Object)((Object)TimeUnit.SECONDS), (Object)((Object)spec.writeExpirationTimeUnit));
        CacheBuilderSpecTest.assertEquals((long)15L, (long)spec.writeExpirationDuration);
        CacheBuilderSpecTest.assertNull((Object)((Object)spec.accessExpirationTimeUnit));
        CacheBuilder expected = CacheBuilder.newBuilder().initialCapacity(10).maximumSize(20L).weakKeys().softValues().expireAfterWrite(15L, TimeUnit.SECONDS);
        CacheBuilderSpecTest.assertCacheBuilderEquivalence(expected, CacheBuilder.from((CacheBuilderSpec)spec));
    }

    public void testParse_unknownKey() {
        try {
            CacheBuilderSpec.parse((String)"foo=17");
            CacheBuilderSpecTest.fail((String)"Expected exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testParse_extraCommaIsInvalid() {
        try {
            CacheBuilderSpec.parse((String)"weakKeys,");
            CacheBuilderSpecTest.fail((String)"Expected exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            CacheBuilderSpec.parse((String)",weakKeys");
            CacheBuilderSpecTest.fail((String)"Expected exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            CacheBuilderSpec.parse((String)"weakKeys,,softValues");
            CacheBuilderSpecTest.fail((String)"Expected exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testEqualsAndHashCode() {
        new EqualsTester().addEqualityGroup(new Object[]{CacheBuilderSpec.parse((String)""), CacheBuilderSpec.parse((String)"")}).addEqualityGroup(new Object[]{CacheBuilderSpec.parse((String)"concurrencyLevel=7"), CacheBuilderSpec.parse((String)"concurrencyLevel=7")}).addEqualityGroup(new Object[]{CacheBuilderSpec.parse((String)"concurrencyLevel=15"), CacheBuilderSpec.parse((String)"concurrencyLevel=15")}).addEqualityGroup(new Object[]{CacheBuilderSpec.parse((String)"initialCapacity=7"), CacheBuilderSpec.parse((String)"initialCapacity=7")}).addEqualityGroup(new Object[]{CacheBuilderSpec.parse((String)"initialCapacity=15"), CacheBuilderSpec.parse((String)"initialCapacity=15")}).addEqualityGroup(new Object[]{CacheBuilderSpec.parse((String)"maximumSize=7"), CacheBuilderSpec.parse((String)"maximumSize=7")}).addEqualityGroup(new Object[]{CacheBuilderSpec.parse((String)"maximumSize=15"), CacheBuilderSpec.parse((String)"maximumSize=15")}).addEqualityGroup(new Object[]{CacheBuilderSpec.parse((String)"maximumWeight=7"), CacheBuilderSpec.parse((String)"maximumWeight=7")}).addEqualityGroup(new Object[]{CacheBuilderSpec.parse((String)"maximumWeight=15"), CacheBuilderSpec.parse((String)"maximumWeight=15")}).addEqualityGroup(new Object[]{CacheBuilderSpec.parse((String)"expireAfterAccess=60s"), CacheBuilderSpec.parse((String)"expireAfterAccess=1m")}).addEqualityGroup(new Object[]{CacheBuilderSpec.parse((String)"expireAfterAccess=60m"), CacheBuilderSpec.parse((String)"expireAfterAccess=1h")}).addEqualityGroup(new Object[]{CacheBuilderSpec.parse((String)"expireAfterWrite=60s"), CacheBuilderSpec.parse((String)"expireAfterWrite=1m")}).addEqualityGroup(new Object[]{CacheBuilderSpec.parse((String)"expireAfterWrite=60m"), CacheBuilderSpec.parse((String)"expireAfterWrite=1h")}).addEqualityGroup(new Object[]{CacheBuilderSpec.parse((String)"weakKeys"), CacheBuilderSpec.parse((String)"weakKeys")}).addEqualityGroup(new Object[]{CacheBuilderSpec.parse((String)"softValues"), CacheBuilderSpec.parse((String)"softValues")}).addEqualityGroup(new Object[]{CacheBuilderSpec.parse((String)"weakValues"), CacheBuilderSpec.parse((String)"weakValues")}).addEqualityGroup(new Object[]{CacheBuilderSpec.parse((String)"recordStats"), CacheBuilderSpec.parse((String)"recordStats")}).testEquals();
    }

    public void testMaximumWeight_withWeigher() {
        CacheBuilder builder = CacheBuilder.from((CacheBuilderSpec)CacheBuilderSpec.parse((String)"maximumWeight=9000"));
        builder.weigher(TestingWeighers.constantWeigher(42)).build(CacheLoader.from((Supplier)Suppliers.ofInstance(null)));
    }

    public void testMaximumWeight_withoutWeigher() {
        CacheBuilder builder = CacheBuilder.from((CacheBuilderSpec)CacheBuilderSpec.parse((String)"maximumWeight=9000"));
        try {
            builder.build(CacheLoader.from((Supplier)Suppliers.ofInstance(null)));
            CacheBuilderSpecTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testMaximumSize_withWeigher() {
        CacheBuilder builder = CacheBuilder.from((CacheBuilderSpec)CacheBuilderSpec.parse((String)"maximumSize=9000"));
        builder.weigher(TestingWeighers.constantWeigher(42)).build(CacheLoader.from((Supplier)Suppliers.ofInstance(null)));
    }

    public void testMaximumSize_withoutWeigher() {
        CacheBuilder builder = CacheBuilder.from((CacheBuilderSpec)CacheBuilderSpec.parse((String)"maximumSize=9000"));
        builder.build(CacheLoader.from((Supplier)Suppliers.ofInstance(null)));
    }

    public void testDisableCaching() {
        CacheBuilder builder = CacheBuilder.from((CacheBuilderSpec)CacheBuilderSpec.disableCaching());
        Object key = new Object();
        Object value = new Object();
        LoadingCache cache = builder.build(CacheLoader.from((Supplier)Suppliers.ofInstance((Object)value)));
        CacheBuilderSpecTest.assertSame((Object)value, (Object)cache.getUnchecked(key));
        CacheBuilderSpecTest.assertEquals((long)0L, (long)cache.size());
        CacheBuilderSpecTest.assertFalse((boolean)cache.asMap().containsKey(key));
    }

    public void testCacheBuilderFrom_string() {
        CacheBuilder fromString = CacheBuilder.from((String)"initialCapacity=10,maximumSize=20,concurrencyLevel=30,weakKeys,weakValues,expireAfterAccess=10m");
        CacheBuilder expected = CacheBuilder.newBuilder().initialCapacity(10).maximumSize(20L).concurrencyLevel(30).weakKeys().weakValues().expireAfterAccess(10L, TimeUnit.MINUTES);
        CacheBuilderSpecTest.assertCacheBuilderEquivalence(expected, fromString);
    }

    private static void assertCacheBuilderEquivalence(CacheBuilder<?, ?> a, CacheBuilder<?, ?> b) {
        CacheBuilderSpecTest.assertEquals((String)"concurrencyLevel", (int)a.concurrencyLevel, (int)b.concurrencyLevel);
        CacheBuilderSpecTest.assertEquals((String)"expireAfterAccessNanos", (long)a.expireAfterAccessNanos, (long)b.expireAfterAccessNanos);
        CacheBuilderSpecTest.assertEquals((String)"expireAfterWriteNanos", (long)a.expireAfterWriteNanos, (long)b.expireAfterWriteNanos);
        CacheBuilderSpecTest.assertEquals((String)"initialCapacity", (int)a.initialCapacity, (int)b.initialCapacity);
        CacheBuilderSpecTest.assertEquals((String)"maximumSize", (long)a.maximumSize, (long)b.maximumSize);
        CacheBuilderSpecTest.assertEquals((String)"maximumWeight", (long)a.maximumWeight, (long)b.maximumWeight);
        CacheBuilderSpecTest.assertEquals((String)"refreshNanos", (long)a.refreshNanos, (long)b.refreshNanos);
        CacheBuilderSpecTest.assertEquals((String)"keyEquivalence", (Object)a.keyEquivalence, (Object)b.keyEquivalence);
        CacheBuilderSpecTest.assertEquals((String)"keyStrength", (Object)a.keyStrength, (Object)b.keyStrength);
        CacheBuilderSpecTest.assertEquals((String)"removalListener", (Object)a.removalListener, (Object)b.removalListener);
        CacheBuilderSpecTest.assertEquals((String)"weigher", (Object)a.weigher, (Object)b.weigher);
        CacheBuilderSpecTest.assertEquals((String)"valueEquivalence", (Object)a.valueEquivalence, (Object)b.valueEquivalence);
        CacheBuilderSpecTest.assertEquals((String)"valueStrength", (Object)a.valueStrength, (Object)b.valueStrength);
        CacheBuilderSpecTest.assertEquals((String)"statsCounterSupplier", (Object)a.statsCounterSupplier, (Object)b.statsCounterSupplier);
        CacheBuilderSpecTest.assertEquals((String)"ticker", (Object)a.ticker, (Object)b.ticker);
        CacheBuilderSpecTest.assertEquals((String)"recordStats", (boolean)a.isRecordingStats(), (boolean)b.isRecordingStats());
    }
}

