/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.cache;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Ticker;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.CacheStats;
import com.google.common.cache.CacheTesting;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.LocalCache;
import com.google.common.cache.RemovalNotification;
import com.google.common.cache.TestingCacheLoaders;
import com.google.common.cache.TestingRemovalListeners;
import com.google.common.cache.TestingWeighers;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.testing.NullPointerTester;
import com.google.common.truth.Truth;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.TestCase;

@GwtCompatible(emulated=true)
public class CacheBuilderTest
extends TestCase {
    public void testNewBuilder() {
        TestingCacheLoaders.ConstantLoader loader = TestingCacheLoaders.constantLoader(1);
        LoadingCache cache = CacheBuilder.newBuilder().removalListener(TestingRemovalListeners.countingRemovalListener()).build(loader);
        CacheBuilderTest.assertEquals((Object)1, (Object)cache.getUnchecked((Object)"one"));
        CacheBuilderTest.assertEquals((long)1L, (long)cache.size());
    }

    public void testInitialCapacity_negative() {
        CacheBuilder builder = new CacheBuilder();
        try {
            builder.initialCapacity(-1);
            CacheBuilderTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testInitialCapacity_setTwice() {
        CacheBuilder builder = new CacheBuilder().initialCapacity(16);
        try {
            builder.initialCapacity(16);
            CacheBuilderTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @GwtIncompatible
    public void testInitialCapacity_small() {
        LoadingCache cache = CacheBuilder.newBuilder().initialCapacity(5).build(TestingCacheLoaders.identityLoader());
        LocalCache map = CacheTesting.toLocalCache(cache);
        Truth.assertThat((Object[])map.segments).hasLength(4);
        CacheBuilderTest.assertEquals((int)2, (int)map.segments[0].table.length());
        CacheBuilderTest.assertEquals((int)2, (int)map.segments[1].table.length());
        CacheBuilderTest.assertEquals((int)2, (int)map.segments[2].table.length());
        CacheBuilderTest.assertEquals((int)2, (int)map.segments[3].table.length());
    }

    @GwtIncompatible
    public void testInitialCapacity_smallest() {
        LoadingCache cache = CacheBuilder.newBuilder().initialCapacity(0).build(TestingCacheLoaders.identityLoader());
        LocalCache map = CacheTesting.toLocalCache(cache);
        Truth.assertThat((Object[])map.segments).hasLength(4);
        CacheBuilderTest.assertEquals((int)1, (int)map.segments[0].table.length());
        CacheBuilderTest.assertEquals((int)1, (int)map.segments[1].table.length());
        CacheBuilderTest.assertEquals((int)1, (int)map.segments[2].table.length());
        CacheBuilderTest.assertEquals((int)1, (int)map.segments[3].table.length());
    }

    public void testInitialCapacity_large() {
        CacheBuilder.newBuilder().initialCapacity(Integer.MAX_VALUE);
    }

    public void testConcurrencyLevel_zero() {
        CacheBuilder builder = new CacheBuilder();
        try {
            builder.concurrencyLevel(0);
            CacheBuilderTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testConcurrencyLevel_setTwice() {
        CacheBuilder builder = new CacheBuilder().concurrencyLevel(16);
        try {
            builder.concurrencyLevel(16);
            CacheBuilderTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @GwtIncompatible
    public void testConcurrencyLevel_small() {
        LoadingCache cache = CacheBuilder.newBuilder().concurrencyLevel(1).build(TestingCacheLoaders.identityLoader());
        LocalCache map = CacheTesting.toLocalCache(cache);
        Truth.assertThat((Object[])map.segments).hasLength(1);
    }

    public void testConcurrencyLevel_large() {
        CacheBuilder.newBuilder().concurrencyLevel(Integer.MAX_VALUE);
    }

    public void testMaximumSize_negative() {
        CacheBuilder builder = new CacheBuilder();
        try {
            builder.maximumSize(-1L);
            CacheBuilderTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testMaximumSize_setTwice() {
        CacheBuilder builder = new CacheBuilder().maximumSize(16L);
        try {
            builder.maximumSize(16L);
            CacheBuilderTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @GwtIncompatible
    public void testMaximumSize_andWeight() {
        CacheBuilder builder = new CacheBuilder().maximumSize(16L);
        try {
            builder.maximumWeight(16L);
            CacheBuilderTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @GwtIncompatible
    public void testMaximumWeight_negative() {
        CacheBuilder builder = new CacheBuilder();
        try {
            builder.maximumWeight(-1L);
            CacheBuilderTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @GwtIncompatible
    public void testMaximumWeight_setTwice() {
        CacheBuilder builder = new CacheBuilder().maximumWeight(16L);
        try {
            builder.maximumWeight(16L);
            CacheBuilderTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            builder.maximumSize(16L);
            CacheBuilderTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @GwtIncompatible
    public void testMaximumWeight_withoutWeigher() {
        CacheBuilder builder = new CacheBuilder().maximumWeight(1L);
        try {
            builder.build(TestingCacheLoaders.identityLoader());
            CacheBuilderTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @GwtIncompatible
    public void testWeigher_withoutMaximumWeight() {
        CacheBuilder builder = new CacheBuilder().weigher(TestingWeighers.constantWeigher(42));
        try {
            builder.build(TestingCacheLoaders.identityLoader());
            CacheBuilderTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @GwtIncompatible
    public void testWeigher_withMaximumSize() {
        try {
            new CacheBuilder().weigher(TestingWeighers.constantWeigher(42)).maximumSize(1L);
            CacheBuilderTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            new CacheBuilder().maximumSize(1L).weigher(TestingWeighers.constantWeigher(42));
            CacheBuilderTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @GwtIncompatible
    public void testKeyStrengthSetTwice() {
        CacheBuilder builder1 = new CacheBuilder().weakKeys();
        try {
            builder1.weakKeys();
            CacheBuilderTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @GwtIncompatible
    public void testValueStrengthSetTwice() {
        CacheBuilder builder1 = new CacheBuilder().weakValues();
        try {
            builder1.weakValues();
            CacheBuilderTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            builder1.softValues();
            CacheBuilderTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        CacheBuilder builder2 = new CacheBuilder().softValues();
        try {
            builder2.softValues();
            CacheBuilderTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            builder2.weakValues();
            CacheBuilderTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testTimeToLive_negative() {
        CacheBuilder builder = new CacheBuilder();
        try {
            builder.expireAfterWrite(-1L, TimeUnit.SECONDS);
            CacheBuilderTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testTimeToLive_small() {
        CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.NANOSECONDS).build(TestingCacheLoaders.identityLoader());
    }

    public void testTimeToLive_setTwice() {
        CacheBuilder builder = new CacheBuilder().expireAfterWrite(3600L, TimeUnit.SECONDS);
        try {
            builder.expireAfterWrite(3600L, TimeUnit.SECONDS);
            CacheBuilderTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testTimeToIdle_negative() {
        CacheBuilder builder = new CacheBuilder();
        try {
            builder.expireAfterAccess(-1L, TimeUnit.SECONDS);
            CacheBuilderTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testTimeToIdle_small() {
        CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.NANOSECONDS).build(TestingCacheLoaders.identityLoader());
    }

    public void testTimeToIdle_setTwice() {
        CacheBuilder builder = new CacheBuilder().expireAfterAccess(3600L, TimeUnit.SECONDS);
        try {
            builder.expireAfterAccess(3600L, TimeUnit.SECONDS);
            CacheBuilderTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testTimeToIdleAndToLive() {
        CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.NANOSECONDS).expireAfterAccess(1L, TimeUnit.NANOSECONDS).build(TestingCacheLoaders.identityLoader());
    }

    @GwtIncompatible
    public void testRefresh_zero() {
        CacheBuilder builder = new CacheBuilder();
        try {
            builder.refreshAfterWrite(0L, TimeUnit.SECONDS);
            CacheBuilderTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @GwtIncompatible
    public void testRefresh_setTwice() {
        CacheBuilder builder = new CacheBuilder().refreshAfterWrite(3600L, TimeUnit.SECONDS);
        try {
            builder.refreshAfterWrite(3600L, TimeUnit.SECONDS);
            CacheBuilderTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testTicker_setTwice() {
        Ticker testTicker = Ticker.systemTicker();
        CacheBuilder builder = new CacheBuilder().ticker(testTicker);
        try {
            builder.ticker(testTicker);
            CacheBuilderTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testRemovalListener_setTwice() {
        TestingRemovalListeners.NullRemovalListener testListener = TestingRemovalListeners.nullRemovalListener();
        CacheBuilder builder = new CacheBuilder().removalListener(testListener);
        try {
            builder = builder.removalListener(testListener);
            CacheBuilderTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testValuesIsNotASet() {
        Truth.assertThat(new CacheBuilder().build().asMap().values()).isNotInstanceOf(Set.class);
    }

    @GwtIncompatible
    public void testNullCache() {
        TestingRemovalListeners.CountingRemovalListener listener = TestingRemovalListeners.countingRemovalListener();
        LoadingCache nullCache = new CacheBuilder().maximumSize(0L).removalListener(listener).build(TestingCacheLoaders.identityLoader());
        CacheBuilderTest.assertEquals((long)0L, (long)nullCache.size());
        Object key = new Object();
        CacheBuilderTest.assertSame((Object)key, (Object)nullCache.getUnchecked(key));
        CacheBuilderTest.assertEquals((int)1, (int)listener.getCount());
        CacheBuilderTest.assertEquals((long)0L, (long)nullCache.size());
        CacheTesting.checkEmpty(nullCache.asMap());
    }

    @GwtIncompatible
    public void testRemovalNotification_clear() throws InterruptedException {
        final AtomicBoolean shouldWait = new AtomicBoolean(false);
        final CountDownLatch computingLatch = new CountDownLatch(1);
        CacheLoader<String, String> computingFunction = new CacheLoader<String, String>(){

            public String load(String key) throws InterruptedException {
                if (shouldWait.get()) {
                    computingLatch.await();
                }
                return key;
            }
        };
        TestingRemovalListeners.QueuingRemovalListener listener = TestingRemovalListeners.queuingRemovalListener();
        final LoadingCache cache = CacheBuilder.newBuilder().concurrencyLevel(1).removalListener(listener).build((CacheLoader)computingFunction);
        cache.getUnchecked((Object)"a");
        shouldWait.set(true);
        final CountDownLatch computationStarted = new CountDownLatch(1);
        final CountDownLatch computationComplete = new CountDownLatch(1);
        new Thread(new Runnable(){

            @Override
            public void run() {
                computationStarted.countDown();
                cache.getUnchecked((Object)"b");
                computationComplete.countDown();
            }
        }).start();
        computationStarted.await();
        cache.invalidateAll();
        computingLatch.countDown();
        computationComplete.await();
        CacheBuilderTest.assertEquals((int)1, (int)listener.size());
        RemovalNotification notification = (RemovalNotification)listener.remove();
        CacheBuilderTest.assertEquals((String)"a", (String)((String)notification.getKey()));
        CacheBuilderTest.assertEquals((String)"a", (String)((String)notification.getValue()));
        CacheBuilderTest.assertEquals((long)1L, (long)cache.size());
        CacheBuilderTest.assertEquals((String)"b", (String)((String)cache.getUnchecked((Object)"b")));
    }

    @GwtIncompatible
    public void testRemovalNotification_clear_basher() throws InterruptedException {
        AtomicBoolean computationShouldWait = new AtomicBoolean();
        CountDownLatch computationLatch = new CountDownLatch(1);
        TestingRemovalListeners.QueuingRemovalListener listener = TestingRemovalListeners.queuingRemovalListener();
        final LoadingCache cache = CacheBuilder.newBuilder().removalListener(listener).concurrencyLevel(20).build(new DelayingIdentityLoader(computationShouldWait, computationLatch));
        int nThreads = 100;
        int nTasks = 1000;
        int nSeededEntries = 100;
        HashSet expectedKeys = Sets.newHashSetWithExpectedSize((int)(nTasks + nSeededEntries));
        for (int i = 0; i < nSeededEntries; ++i) {
            String s = "b" + i;
            cache.getUnchecked((Object)s);
            expectedKeys.add(s);
        }
        computationShouldWait.set(true);
        final AtomicInteger computedCount = new AtomicInteger();
        ExecutorService threadPool = Executors.newFixedThreadPool(nThreads);
        final CountDownLatch tasksFinished = new CountDownLatch(nTasks);
        for (int i = 0; i < nTasks; ++i) {
            final String s = "a" + i;
            threadPool.submit(new Runnable(){

                @Override
                public void run() {
                    cache.getUnchecked((Object)s);
                    computedCount.incrementAndGet();
                    tasksFinished.countDown();
                }
            });
            expectedKeys.add(s);
        }
        computationLatch.countDown();
        while (computedCount.get() < nThreads) {
            Thread.yield();
        }
        cache.invalidateAll();
        tasksFinished.await();
        HashMap removalNotifications = Maps.newHashMap();
        for (RemovalNotification removalNotification : listener) {
            removalNotifications.put(removalNotification.getKey(), removalNotification.getValue());
            CacheBuilderTest.assertEquals((String)"Unexpected key/value pair passed to removalListener", (String)((String)removalNotification.getKey()), (String)((String)removalNotification.getValue()));
        }
        for (int i = 0; i < nSeededEntries; ++i) {
            CacheBuilderTest.assertEquals((String)("b" + i), (String)((String)removalNotifications.get("b" + i)));
        }
        CacheBuilderTest.assertEquals((Object)expectedKeys, (Object)Sets.union(cache.asMap().keySet(), removalNotifications.keySet()));
        CacheBuilderTest.assertTrue((boolean)Sets.intersection(cache.asMap().keySet(), removalNotifications.keySet()).isEmpty());
    }

    @GwtIncompatible
    public void testRemovalNotification_get_basher() throws InterruptedException {
        int nTasks = 1000;
        int nThreads = 100;
        int getsPerTask = 1000;
        int nUniqueKeys = 10000;
        final Random random = new Random();
        TestingRemovalListeners.QueuingRemovalListener removalListener = TestingRemovalListeners.queuingRemovalListener();
        final AtomicInteger computeCount = new AtomicInteger();
        final AtomicInteger exceptionCount = new AtomicInteger();
        final AtomicInteger computeNullCount = new AtomicInteger();
        CacheLoader<String, String> countingIdentityLoader = new CacheLoader<String, String>(){

            public String load(String key) throws InterruptedException {
                int behavior = random.nextInt(4);
                if (behavior == 0) {
                    exceptionCount.incrementAndGet();
                    throw new RuntimeException("fake exception for test");
                }
                if (behavior == 1) {
                    computeNullCount.incrementAndGet();
                    return null;
                }
                if (behavior == 2) {
                    Thread.sleep(5L);
                    computeCount.incrementAndGet();
                    return key;
                }
                computeCount.incrementAndGet();
                return key;
            }
        };
        final LoadingCache cache = CacheBuilder.newBuilder().recordStats().concurrencyLevel(2).expireAfterWrite(100L, TimeUnit.MILLISECONDS).removalListener(removalListener).maximumSize(5000L).build((CacheLoader)countingIdentityLoader);
        ExecutorService threadPool = Executors.newFixedThreadPool(nThreads);
        for (int i = 0; i < nTasks; ++i) {
            threadPool.submit(new Runnable(){

                @Override
                public void run() {
                    for (int j = 0; j < 1000; ++j) {
                        try {
                            cache.getUnchecked((Object)("key" + random.nextInt(10000)));
                            continue;
                        }
                        catch (RuntimeException runtimeException) {
                            // empty catch block
                        }
                    }
                }
            });
        }
        threadPool.shutdown();
        threadPool.awaitTermination(300L, TimeUnit.SECONDS);
        for (RemovalNotification removalNotification : removalListener) {
            CacheBuilderTest.assertEquals((String)"Invalid removal notification", (String)((String)removalNotification.getKey()), (String)((String)removalNotification.getValue()));
        }
        CacheStats stats = cache.stats();
        CacheBuilderTest.assertEquals((long)removalListener.size(), (long)stats.evictionCount());
        CacheBuilderTest.assertEquals((long)computeCount.get(), (long)stats.loadSuccessCount());
        CacheBuilderTest.assertEquals((long)(exceptionCount.get() + computeNullCount.get()), (long)stats.loadExceptionCount());
        CacheBuilderTest.assertEquals((long)computeCount.get(), (long)(cache.size() + (long)removalListener.size()));
    }

    @GwtIncompatible
    public void testNullParameters() throws Exception {
        NullPointerTester tester = new NullPointerTester();
        CacheBuilder builder = new CacheBuilder();
        tester.testAllPublicInstanceMethods((Object)builder);
    }

    @GwtIncompatible
    public void testSizingDefaults() {
        LoadingCache cache = CacheBuilder.newBuilder().build(TestingCacheLoaders.identityLoader());
        LocalCache map = CacheTesting.toLocalCache(cache);
        Truth.assertThat((Object[])map.segments).hasLength(4);
        CacheBuilderTest.assertEquals((int)4, (int)map.segments[0].table.length());
    }

    @GwtIncompatible
    static final class DelayingIdentityLoader<T>
    extends CacheLoader<T, T> {
        private final AtomicBoolean shouldWait;
        private final CountDownLatch delayLatch;

        DelayingIdentityLoader(AtomicBoolean shouldWait, CountDownLatch delayLatch) {
            this.shouldWait = shouldWait;
            this.delayLatch = delayLatch;
        }

        public T load(T key) throws InterruptedException {
            if (this.shouldWait.get()) {
                this.delayLatch.await();
            }
            return key;
        }
    }
}

