/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.cache;

import com.google.common.base.Function;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheBuilderFactory;
import com.google.common.cache.CacheTesting;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.LocalCache;
import com.google.common.cache.TestingCacheLoaders;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.testing.EqualsTester;
import com.google.common.truth.Truth;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;

public class PopulatedCachesTest
extends TestCase {
    static final int WARMUP_MIN = 120;
    static final int WARMUP_MAX = 135;
    static final int WARMUP_SIZE = 15;

    public void testSize_populated() {
        for (LoadingCache<Object, Object> cache : this.caches()) {
            List<Map.Entry<Object, Object>> warmed = this.warmUp(cache);
            PopulatedCachesTest.assertEquals((long)15L, (long)cache.size());
            this.assertMapSize(cache.asMap(), 15);
            CacheTesting.checkValidState(cache);
        }
    }

    public void testContainsKey_found() {
        for (LoadingCache<Object, Object> cache : this.caches()) {
            List<Map.Entry<Object, Object>> warmed = this.warmUp(cache);
            for (int i = 120; i < 135; ++i) {
                Map.Entry<Object, Object> entry = warmed.get(i - 120);
                PopulatedCachesTest.assertTrue((boolean)cache.asMap().containsKey(entry.getKey()));
                PopulatedCachesTest.assertTrue((boolean)cache.asMap().containsValue(entry.getValue()));
                PopulatedCachesTest.assertEquals((Object)entry.getValue(), (Object)cache.getUnchecked(entry.getKey()));
            }
            PopulatedCachesTest.assertEquals((long)15L, (long)cache.stats().missCount());
            CacheTesting.checkValidState(cache);
        }
    }

    public void testPut_populated() {
        for (LoadingCache<Object, Object> cache : this.caches()) {
            List<Map.Entry<Object, Object>> warmed = this.warmUp(cache);
            for (int i = 120; i < 135; ++i) {
                Map.Entry<Object, Object> entry = warmed.get(i - 120);
                Object newValue = new Object();
                PopulatedCachesTest.assertSame((Object)entry.getValue(), (Object)cache.asMap().put(entry.getKey(), newValue));
                warmed.add(this.entryOf(entry.getKey(), newValue));
                Object newKey = new Object();
                PopulatedCachesTest.assertNull((Object)cache.asMap().put(newKey, entry.getValue()));
                PopulatedCachesTest.assertEquals((Object)newValue, (Object)cache.getUnchecked(entry.getKey()));
                PopulatedCachesTest.assertEquals((Object)entry.getValue(), (Object)cache.getUnchecked(newKey));
                warmed.add(this.entryOf(newKey, entry.getValue()));
            }
            PopulatedCachesTest.assertEquals((long)15L, (long)cache.stats().missCount());
            CacheTesting.checkValidState(cache);
        }
    }

    public void testPutIfAbsent_populated() {
        for (LoadingCache<Object, Object> cache : this.caches()) {
            List<Map.Entry<Object, Object>> warmed = this.warmUp(cache);
            for (int i = 120; i < 135; ++i) {
                Map.Entry<Object, Object> entry = warmed.get(i - 120);
                Object newValue = new Object();
                PopulatedCachesTest.assertSame((Object)entry.getValue(), (Object)cache.asMap().putIfAbsent(entry.getKey(), newValue));
                Object newKey = new Object();
                PopulatedCachesTest.assertNull((Object)cache.asMap().putIfAbsent(newKey, entry.getValue()));
                PopulatedCachesTest.assertEquals((Object)entry.getValue(), (Object)cache.getUnchecked(entry.getKey()));
                PopulatedCachesTest.assertEquals((Object)entry.getValue(), (Object)cache.getUnchecked(newKey));
                warmed.add(this.entryOf(newKey, entry.getValue()));
            }
            PopulatedCachesTest.assertEquals((long)15L, (long)cache.stats().missCount());
            CacheTesting.checkValidState(cache);
        }
    }

    public void testPutAll_populated() {
        for (LoadingCache<Object, Object> cache : this.caches()) {
            List<Map.Entry<Object, Object>> warmed = this.warmUp(cache);
            Object newKey = new Object();
            Object newValue = new Object();
            cache.asMap().putAll(ImmutableMap.of((Object)newKey, (Object)newValue));
            PopulatedCachesTest.assertEquals((Object)newValue, (Object)cache.getUnchecked(newKey));
            PopulatedCachesTest.assertEquals((long)15L, (long)cache.stats().missCount());
            CacheTesting.checkValidState(cache);
        }
    }

    public void testReplace_populated() {
        for (LoadingCache<Object, Object> cache : this.caches()) {
            List<Map.Entry<Object, Object>> warmed = this.warmUp(cache);
            for (int i = 120; i < 135; ++i) {
                Map.Entry<Object, Object> entry = warmed.get(i - 120);
                Object newValue = new Object();
                PopulatedCachesTest.assertSame((Object)entry.getValue(), (Object)cache.asMap().replace(entry.getKey(), newValue));
                PopulatedCachesTest.assertTrue((boolean)cache.asMap().replace(entry.getKey(), newValue, entry.getValue()));
                Object newKey = new Object();
                PopulatedCachesTest.assertNull((Object)cache.asMap().replace(newKey, entry.getValue()));
                PopulatedCachesTest.assertFalse((boolean)cache.asMap().replace(newKey, entry.getValue(), newValue));
                PopulatedCachesTest.assertEquals((Object)entry.getValue(), (Object)cache.getUnchecked(entry.getKey()));
                PopulatedCachesTest.assertFalse((boolean)cache.asMap().containsKey(newKey));
            }
            PopulatedCachesTest.assertEquals((long)15L, (long)cache.stats().missCount());
            CacheTesting.checkValidState(cache);
        }
    }

    public void testRemove_byKey() {
        for (LoadingCache<Object, Object> cache : this.caches()) {
            List<Map.Entry<Object, Object>> warmed = this.warmUp(cache);
            for (int i = 120; i < 135; ++i) {
                Map.Entry<Object, Object> entry = warmed.get(i - 120);
                Object key = entry.getKey();
                PopulatedCachesTest.assertEquals((Object)entry.getValue(), cache.asMap().remove(key));
                PopulatedCachesTest.assertNull(cache.asMap().remove(key));
                PopulatedCachesTest.assertFalse((boolean)cache.asMap().containsKey(key));
            }
            CacheTesting.checkEmpty(cache);
        }
    }

    public void testRemove_byKeyAndValue() {
        for (LoadingCache<Object, Object> cache : this.caches()) {
            List<Map.Entry<Object, Object>> warmed = this.warmUp(cache);
            for (int i = 120; i < 135; ++i) {
                Object key = warmed.get(i - 120).getKey();
                Object value = warmed.get(i - 120).getValue();
                PopulatedCachesTest.assertFalse((boolean)cache.asMap().remove(key, -1));
                PopulatedCachesTest.assertTrue((boolean)cache.asMap().remove(key, value));
                PopulatedCachesTest.assertFalse((boolean)cache.asMap().remove(key, -1));
                PopulatedCachesTest.assertFalse((boolean)cache.asMap().containsKey(key));
            }
            CacheTesting.checkEmpty(cache);
        }
    }

    public void testKeySet_populated() {
        for (LoadingCache<Object, Object> cache : this.caches()) {
            Set keys = cache.asMap().keySet();
            List<Map.Entry<Object, Object>> warmed = this.warmUp(cache);
            Set expected = Maps.newHashMap((Map)cache.asMap()).keySet();
            Truth.assertThat(keys).containsExactlyElementsIn(expected);
            Truth.assertThat((Object[])keys.toArray()).asList().containsExactlyElementsIn(expected);
            Truth.assertThat((Object[])keys.toArray(new Object[0])).asList().containsExactlyElementsIn(expected);
            new EqualsTester().addEqualityGroup(new Object[]{cache.asMap().keySet(), keys}).addEqualityGroup(new Object[]{ImmutableSet.of()}).testEquals();
            PopulatedCachesTest.assertEquals((int)15, (int)keys.size());
            for (int i = 120; i < 135; ++i) {
                Object key = warmed.get(i - 120).getKey();
                PopulatedCachesTest.assertTrue((boolean)keys.contains(key));
                PopulatedCachesTest.assertTrue((boolean)keys.remove(key));
                PopulatedCachesTest.assertFalse((boolean)keys.remove(key));
                PopulatedCachesTest.assertFalse((boolean)keys.contains(key));
            }
            CacheTesting.checkEmpty(keys);
            CacheTesting.checkEmpty(cache);
        }
    }

    public void testValues_populated() {
        for (LoadingCache<Object, Object> cache : this.caches()) {
            Collection values = cache.asMap().values();
            List<Map.Entry<Object, Object>> warmed = this.warmUp(cache);
            Collection expected = Maps.newHashMap((Map)cache.asMap()).values();
            Truth.assertThat(values).containsExactlyElementsIn(expected);
            Truth.assertThat((Object[])values.toArray()).asList().containsExactlyElementsIn(expected);
            Truth.assertThat((Object[])values.toArray(new Object[0])).asList().containsExactlyElementsIn(expected);
            PopulatedCachesTest.assertEquals((int)15, (int)values.size());
            for (int i = 120; i < 135; ++i) {
                Object value = warmed.get(i - 120).getValue();
                PopulatedCachesTest.assertTrue((boolean)values.contains(value));
                PopulatedCachesTest.assertTrue((boolean)values.remove(value));
                PopulatedCachesTest.assertFalse((boolean)values.remove(value));
                PopulatedCachesTest.assertFalse((boolean)values.contains(value));
            }
            CacheTesting.checkEmpty(values);
            CacheTesting.checkEmpty(cache);
        }
    }

    public void testEntrySet_populated() {
        for (LoadingCache<Object, Object> cache : this.caches()) {
            Set entries = cache.asMap().entrySet();
            List<Map.Entry<Object, Object>> warmed = this.warmUp(cache, 120, 135);
            Set expected = Maps.newHashMap((Map)cache.asMap()).entrySet();
            Truth.assertThat(entries).containsExactlyElementsIn(expected);
            Truth.assertThat((Object[])entries.toArray()).asList().containsExactlyElementsIn(expected);
            Truth.assertThat((Object[])entries.toArray(new Map.Entry[0])).asList().containsExactlyElementsIn(expected);
            new EqualsTester().addEqualityGroup(new Object[]{cache.asMap().entrySet(), entries}).addEqualityGroup(new Object[]{ImmutableSet.of()}).testEquals();
            PopulatedCachesTest.assertEquals((int)15, (int)entries.size());
            for (int i = 120; i < 135; ++i) {
                Map.Entry<Object, Object> newEntry = warmed.get(i - 120);
                PopulatedCachesTest.assertTrue((boolean)entries.contains(newEntry));
                PopulatedCachesTest.assertTrue((boolean)entries.remove(newEntry));
                PopulatedCachesTest.assertFalse((boolean)entries.remove(newEntry));
                PopulatedCachesTest.assertFalse((boolean)entries.contains(newEntry));
            }
            CacheTesting.checkEmpty(entries);
            CacheTesting.checkEmpty(cache);
        }
    }

    public void testWriteThroughEntry() {
        for (LoadingCache<Object, Object> cache : this.caches()) {
            cache.getUnchecked((Object)1);
            Map.Entry entry = (Map.Entry)Iterables.getOnlyElement(cache.asMap().entrySet());
            cache.invalidate((Object)1);
            PopulatedCachesTest.assertEquals((long)0L, (long)cache.size());
            entry.setValue(3);
            PopulatedCachesTest.assertEquals((long)1L, (long)cache.size());
            PopulatedCachesTest.assertEquals((Object)3, (Object)cache.getIfPresent((Object)1));
            CacheTesting.checkValidState(cache);
            try {
                entry.setValue(null);
                PopulatedCachesTest.fail();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            CacheTesting.checkValidState(cache);
        }
    }

    private Iterable<LoadingCache<Object, Object>> caches() {
        CacheBuilderFactory factory = this.cacheFactory();
        return Iterables.transform(factory.buildAllPermutations(), (Function)new Function<CacheBuilder<Object, Object>, LoadingCache<Object, Object>>(){

            public LoadingCache<Object, Object> apply(CacheBuilder<Object, Object> builder) {
                return builder.recordStats().build(TestingCacheLoaders.identityLoader());
            }
        });
    }

    private CacheBuilderFactory cacheFactory() {
        return new CacheBuilderFactory().withKeyStrengths((Set<LocalCache.Strength>)ImmutableSet.of((Object)LocalCache.Strength.STRONG, (Object)LocalCache.Strength.WEAK)).withValueStrengths((Set<LocalCache.Strength>)ImmutableSet.copyOf((Object[])LocalCache.Strength.values())).withConcurrencyLevels((Set<Integer>)ImmutableSet.of((Object)1, (Object)4, (Object)16, (Object)64)).withMaximumSizes((Set<Integer>)ImmutableSet.of((Object)400, (Object)1000)).withInitialCapacities((Set<Integer>)ImmutableSet.of((Object)0, (Object)1, (Object)10, (Object)100, (Object)1000)).withExpireAfterWrites((Set<CacheBuilderFactory.DurationSpec>)ImmutableSet.of((Object)CacheBuilderFactory.DurationSpec.of(1L, TimeUnit.SECONDS), (Object)CacheBuilderFactory.DurationSpec.of(1L, TimeUnit.DAYS))).withExpireAfterAccesses((Set<CacheBuilderFactory.DurationSpec>)ImmutableSet.of((Object)CacheBuilderFactory.DurationSpec.of(1L, TimeUnit.SECONDS), (Object)CacheBuilderFactory.DurationSpec.of(1L, TimeUnit.DAYS))).withRefreshes((Set<CacheBuilderFactory.DurationSpec>)ImmutableSet.of((Object)CacheBuilderFactory.DurationSpec.of(1L, TimeUnit.SECONDS), (Object)CacheBuilderFactory.DurationSpec.of(1L, TimeUnit.DAYS)));
    }

    private List<Map.Entry<Object, Object>> warmUp(LoadingCache<Object, Object> cache) {
        return this.warmUp(cache, 120, 135);
    }

    private List<Map.Entry<Object, Object>> warmUp(LoadingCache<Object, Object> cache, int minimum, int maximum) {
        ArrayList entries = Lists.newArrayList();
        for (int i = minimum; i < maximum; ++i) {
            Integer key = i;
            Object value = cache.getUnchecked((Object)key);
            entries.add(this.entryOf(key, value));
        }
        return entries;
    }

    private Map.Entry<Object, Object> entryOf(Object key, Object value) {
        return Maps.immutableEntry((Object)key, (Object)value);
    }

    private void assertMapSize(Map<?, ?> map, int size) {
        PopulatedCachesTest.assertEquals((int)size, (int)map.size());
        if (size > 0) {
            PopulatedCachesTest.assertFalse((boolean)map.isEmpty());
        } else {
            PopulatedCachesTest.assertTrue((boolean)map.isEmpty());
        }
        this.assertCollectionSize(map.keySet(), size);
        this.assertCollectionSize(map.entrySet(), size);
        this.assertCollectionSize(map.values(), size);
    }

    private void assertCollectionSize(Collection<?> collection, int size) {
        PopulatedCachesTest.assertEquals((int)size, (int)collection.size());
        if (size > 0) {
            PopulatedCachesTest.assertFalse((boolean)collection.isEmpty());
        } else {
            PopulatedCachesTest.assertTrue((boolean)collection.isEmpty());
        }
        PopulatedCachesTest.assertEquals((int)size, (int)Iterables.size(collection));
        PopulatedCachesTest.assertEquals((int)size, (int)Iterators.size(collection.iterator()));
    }
}

