/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.caliper.BeforeExperiment;
import com.google.caliper.Benchmark;
import com.google.caliper.Param;
import com.google.common.base.Optional;
import com.google.common.collect.BinaryTreeTraverser;
import com.google.common.collect.SpecialRandom;
import com.google.common.collect.TreeTraverser;
import com.google.common.primitives.Ints;
import java.util.List;
import java.util.Random;

public class BinaryTreeTraverserBenchmark {
    private static final BinaryTreeTraverser<BinaryNode> BINARY_VIEWER = new BinaryTreeTraverser<BinaryNode>(){

        public Optional<BinaryNode> leftChild(BinaryNode node) {
            return node.left;
        }

        public Optional<BinaryNode> rightChild(BinaryNode node) {
            return node.right;
        }
    };
    private static final TreeTraverser<BinaryNode> VIEWER = new TreeTraverser<BinaryNode>(){

        public Iterable<BinaryNode> children(BinaryNode root) {
            return BINARY_VIEWER.children((Object)root);
        }
    };
    private Iterable<BinaryNode> view;
    @Param
    Topology topology;
    @Param(value={"1", "100", "10000", "1000000"})
    int size;
    @Param
    Traversal traversal;
    @Param
    boolean useBinaryTraverser;
    @Param(value={"1234"})
    SpecialRandom rng;

    @BeforeExperiment
    void setUp() {
        this.view = this.traversal.view(this.topology.createTree(this.size, this.rng).get(), this.useBinaryTraverser ? BINARY_VIEWER : VIEWER);
    }

    @Benchmark
    int traversal(int reps) {
        int tmp = 0;
        for (int i = 0; i < reps; ++i) {
            for (BinaryNode node : this.view) {
                tmp += node.x;
            }
        }
        return tmp;
    }

    static enum Traversal {
        PRE_ORDER{

            @Override
            <T> Iterable<T> view(T root, TreeTraverser<T> viewer) {
                return viewer.preOrderTraversal(root);
            }
        }
        ,
        POST_ORDER{

            @Override
            <T> Iterable<T> view(T root, TreeTraverser<T> viewer) {
                return viewer.postOrderTraversal(root);
            }
        }
        ,
        BREADTH_FIRST{

            @Override
            <T> Iterable<T> view(T root, TreeTraverser<T> viewer) {
                return viewer.breadthFirstTraversal(root);
            }
        };


        abstract <T> Iterable<T> view(T var1, TreeTraverser<T> var2);
    }

    static enum Topology {
        BALANCED{

            @Override
            Optional<BinaryNode> createTree(int size, Random rng) {
                if (size == 0) {
                    return Optional.absent();
                }
                int leftChildSize = (size - 1) / 2;
                int rightChildSize = size - 1 - leftChildSize;
                return Optional.of((Object)new BinaryNode(rng.nextInt(), this.createTree(leftChildSize, rng), this.createTree(rightChildSize, rng)));
            }
        }
        ,
        ALL_LEFT{

            @Override
            Optional<BinaryNode> createTree(int size, Random rng) {
                Optional root = Optional.absent();
                for (int i = 0; i < size; ++i) {
                    root = Optional.of((Object)new BinaryNode(rng.nextInt(), (Optional<BinaryNode>)root, (Optional<BinaryNode>)Optional.absent()));
                }
                return root;
            }
        }
        ,
        ALL_RIGHT{

            @Override
            Optional<BinaryNode> createTree(int size, Random rng) {
                Optional root = Optional.absent();
                for (int i = 0; i < size; ++i) {
                    root = Optional.of((Object)new BinaryNode(rng.nextInt(), (Optional<BinaryNode>)Optional.absent(), (Optional<BinaryNode>)root));
                }
                return root;
            }
        }
        ,
        RANDOM{

            @Override
            Optional<BinaryNode> createTree(int size, Random rng) {
                int[] keys = new int[size];
                for (int i = 0; i < size; ++i) {
                    keys[i] = rng.nextInt();
                }
                return this.createTreap(Ints.asList((int[])keys));
            }

            private Optional<BinaryNode> createTreap(List<Integer> keys) {
                if (keys.isEmpty()) {
                    return Optional.absent();
                }
                int minIndex = 0;
                for (int i = 1; i < keys.size(); ++i) {
                    if (keys.get(i) >= keys.get(minIndex)) continue;
                    minIndex = i;
                }
                Optional<BinaryNode> leftChild = this.createTreap(keys.subList(0, minIndex));
                Optional<BinaryNode> rightChild = this.createTreap(keys.subList(minIndex + 1, keys.size()));
                return Optional.of((Object)new BinaryNode(keys.get(minIndex), leftChild, rightChild));
            }
        };


        abstract Optional<BinaryNode> createTree(int var1, Random var2);
    }

    private static class BinaryNode {
        final int x;
        final Optional<BinaryNode> left;
        final Optional<BinaryNode> right;

        BinaryNode(int x, Optional<BinaryNode> left, Optional<BinaryNode> right) {
            this.x = x;
            this.left = left;
            this.right = right;
        }
    }
}

