/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.MapConstraint;
import com.google.common.collect.MapConstraints;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.Feature;
import com.google.common.collect.testing.features.MapFeature;
import com.google.common.collect.testing.google.MultimapTestSuiteBuilder;
import com.google.common.collect.testing.google.SetMultimapTestSuiteBuilder;
import com.google.common.collect.testing.google.TestSetMultimapGenerator;
import com.google.common.collect.testing.google.TestStringSetMultimapGenerator;
import java.io.Serializable;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestCase;

public class ConstrainedSetMultimapTest
extends TestCase {
    public static Test suite() {
        return ((MultimapTestSuiteBuilder)((MultimapTestSuiteBuilder)SetMultimapTestSuiteBuilder.using((TestSetMultimapGenerator)new TestStringSetMultimapGenerator(){

            protected SetMultimap<String, String> create(Map.Entry<String, String>[] entries) {
                HashMultimap multimap = HashMultimap.create();
                for (Map.Entry<String, String> entry : entries) {
                    multimap.put((Object)entry.getKey(), (Object)entry.getValue());
                }
                return MapConstraints.constrainedSetMultimap((SetMultimap)multimap, (MapConstraint)Constraint.INSTANCE);
            }
        }).named("MapConstraints.constrainedSetMultimap")).withFeatures(new Feature[]{MapFeature.ALLOWS_NULL_KEYS, MapFeature.ALLOWS_NULL_VALUES, MapFeature.ALLOWS_ANY_NULL_QUERIES, MapFeature.GENERAL_PURPOSE, CollectionSize.ANY, CollectionFeature.SERIALIZABLE, CollectionFeature.SUPPORTS_ITERATOR_REMOVE})).createTestSuite();
    }

    private static enum Constraint implements Serializable,
    MapConstraint<String, String>
    {
        INSTANCE;


        public void checkKeyValue(String key, String value) {
            Preconditions.checkArgument((!"test".equals(key) ? 1 : 0) != 0);
            Preconditions.checkArgument((!"test".equals(value) ? 1 : 0) != 0);
        }
    }
}

