/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.collect.ForwardingCollection;
import com.google.common.collect.ForwardingTestCase;
import com.google.common.collect.Lists;
import com.google.common.collect.testing.CollectionTestSuiteBuilder;
import com.google.common.collect.testing.MinimalCollection;
import com.google.common.collect.testing.TestCollectionGenerator;
import com.google.common.collect.testing.TestStringCollectionGenerator;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.Feature;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import junit.framework.Test;
import junit.framework.TestSuite;

public class ForwardingCollectionTest
extends ForwardingTestCase {
    private static final Collection<String> EMPTY_COLLECTION = Collections.emptyList();
    private Collection<String> forward;

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(ForwardingCollectionTest.class);
        suite.addTest((Test)((CollectionTestSuiteBuilder)((CollectionTestSuiteBuilder)CollectionTestSuiteBuilder.using((TestCollectionGenerator)new TestStringCollectionGenerator(){

            protected Collection<String> create(String[] elements) {
                return new StandardImplForwardingCollection(Lists.newLinkedList(Arrays.asList(elements)));
            }
        }).named("ForwardingCollection[LinkedList] with standard implementations")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.ALLOWS_NULL_VALUES, CollectionFeature.GENERAL_PURPOSE})).createTestSuite());
        suite.addTest((Test)((CollectionTestSuiteBuilder)((CollectionTestSuiteBuilder)CollectionTestSuiteBuilder.using((TestCollectionGenerator)new TestStringCollectionGenerator(){

            protected Collection<String> create(String[] elements) {
                return new StandardImplForwardingCollection(MinimalCollection.of((Object[])elements));
            }
        }).named("ForwardingCollection[MinimalCollection] with standard implementations")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.ALLOWS_NULL_VALUES})).createTestSuite());
        return suite;
    }

    public void setUp() throws Exception {
        super.setUp();
        final Collection list = this.createProxyInstance(Collection.class);
        this.forward = new ForwardingCollection<String>(){

            protected Collection<String> delegate() {
                return list;
            }
        };
    }

    public void testAdd_T() {
        this.forward.add("asdf");
        ForwardingCollectionTest.assertEquals((String)"[add(Object)]", (String)this.getCalls());
    }

    public void testAddAll_Collection() {
        this.forward.addAll(EMPTY_COLLECTION);
        ForwardingCollectionTest.assertEquals((String)"[addAll(Collection)]", (String)this.getCalls());
    }

    public void testClear() {
        this.forward.clear();
        ForwardingCollectionTest.assertEquals((String)"[clear]", (String)this.getCalls());
    }

    public void testContains_Object() {
        this.forward.contains(null);
        ForwardingCollectionTest.assertEquals((String)"[contains(Object)]", (String)this.getCalls());
    }

    public void testContainsAll_Collection() {
        this.forward.containsAll(EMPTY_COLLECTION);
        ForwardingCollectionTest.assertEquals((String)"[containsAll(Collection)]", (String)this.getCalls());
    }

    public void testIsEmpty() {
        this.forward.isEmpty();
        ForwardingCollectionTest.assertEquals((String)"[isEmpty]", (String)this.getCalls());
    }

    public void testIterator() {
        this.forward.iterator();
        ForwardingCollectionTest.assertEquals((String)"[iterator]", (String)this.getCalls());
    }

    public void testRemove_Object() {
        this.forward.remove(null);
        ForwardingCollectionTest.assertEquals((String)"[remove(Object)]", (String)this.getCalls());
    }

    public void testRemoveAll_Collection() {
        this.forward.removeAll(EMPTY_COLLECTION);
        ForwardingCollectionTest.assertEquals((String)"[removeAll(Collection)]", (String)this.getCalls());
    }

    public void testRetainAll_Collection() {
        this.forward.retainAll(EMPTY_COLLECTION);
        ForwardingCollectionTest.assertEquals((String)"[retainAll(Collection)]", (String)this.getCalls());
    }

    public void testSize() {
        this.forward.size();
        ForwardingCollectionTest.assertEquals((String)"[size]", (String)this.getCalls());
    }

    public void testToArray() {
        this.forward.toArray();
        ForwardingCollectionTest.assertEquals((String)"[toArray]", (String)this.getCalls());
    }

    public void testToArray_TArray() {
        this.forward.toArray(new String[0]);
        ForwardingCollectionTest.assertEquals((String)"[toArray(Object[])]", (String)this.getCalls());
    }

    public void testToString() {
        this.forward.toString();
        ForwardingCollectionTest.assertEquals((String)"[toString]", (String)this.getCalls());
    }

    public void testEquals_Object() {
        this.forward.equals("asdf");
        ForwardingCollectionTest.assertFalse((String)"equals() should not be forwarded.", (boolean)this.isCalled());
    }

    public void testHashCode() {
        this.forward.hashCode();
        ForwardingCollectionTest.assertFalse((String)"hashCode() should not be forwarded.", (boolean)this.isCalled());
    }

    static final class StandardImplForwardingCollection<T>
    extends ForwardingCollection<T> {
        private final Collection<T> backingCollection;

        StandardImplForwardingCollection(Collection<T> backingCollection) {
            this.backingCollection = backingCollection;
        }

        protected Collection<T> delegate() {
            return this.backingCollection;
        }

        public boolean addAll(Collection<? extends T> collection) {
            return this.standardAddAll(collection);
        }

        public void clear() {
            this.standardClear();
        }

        public boolean contains(Object object) {
            return this.standardContains(object);
        }

        public boolean containsAll(Collection<?> collection) {
            return this.standardContainsAll(collection);
        }

        public boolean remove(Object object) {
            return this.standardRemove(object);
        }

        public boolean removeAll(Collection<?> collection) {
            return this.standardRemoveAll(collection);
        }

        public boolean retainAll(Collection<?> collection) {
            return this.standardRetainAll(collection);
        }

        public Object[] toArray() {
            return this.standardToArray();
        }

        public <T> T[] toArray(T[] array) {
            return this.standardToArray(array);
        }

        public String toString() {
            return this.standardToString();
        }
    }
}

