/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.collect.ForwardingMap;
import com.google.common.collect.ForwardingNavigableMap;
import com.google.common.collect.ForwardingSortedMapTest;
import com.google.common.collect.Maps;
import com.google.common.collect.testing.MapTestSuiteBuilder;
import com.google.common.collect.testing.NavigableMapTestSuiteBuilder;
import com.google.common.collect.testing.SafeTreeMap;
import com.google.common.collect.testing.TestSortedMapGenerator;
import com.google.common.collect.testing.TestStringSortedMapGenerator;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.Feature;
import com.google.common.collect.testing.features.MapFeature;
import com.google.common.collect.testing.testers.MapEntrySetTester;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedMap;
import junit.framework.Test;
import junit.framework.TestSuite;

public class ForwardingNavigableMapTest
extends ForwardingSortedMapTest {
    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(ForwardingNavigableMapTest.class);
        suite.addTest((Test)((MapTestSuiteBuilder)((MapTestSuiteBuilder)((MapTestSuiteBuilder)NavigableMapTestSuiteBuilder.using((TestSortedMapGenerator)new TestStringSortedMapGenerator(){

            protected SortedMap<String, String> create(Map.Entry<String, String>[] entries) {
                SafeTreeMap map = new SafeTreeMap();
                for (Map.Entry<String, String> entry : entries) {
                    map.put(entry.getKey(), entry.getValue());
                }
                return new StandardImplForwardingNavigableMap(map);
            }
        }).named("ForwardingNavigableMap[SafeTreeMap] with no comparator and standard implementations")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.KNOWN_ORDER, MapFeature.ALLOWS_NULL_VALUES, CollectionFeature.SUPPORTS_ITERATOR_REMOVE, MapFeature.GENERAL_PURPOSE})).suppressing(new Method[]{MapEntrySetTester.getSetValueMethod()})).createTestSuite());
        return suite;
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        final NavigableMap sortedMap = this.createProxyInstance(NavigableMap.class);
        this.forward = new ForwardingNavigableMap<String, Boolean>(){

            protected NavigableMap<String, Boolean> delegate() {
                return sortedMap;
            }
        };
    }

    public void testStandardLastEntry() {
        StandardLastEntryForwardingNavigableMap<String, Integer> forwarding = new StandardLastEntryForwardingNavigableMap<String, Integer>((NavigableMap<String, Integer>)new SafeTreeMap());
        ForwardingNavigableMapTest.assertNull(forwarding.lastEntry());
        forwarding.put("b", 2);
        ForwardingNavigableMapTest.assertEquals((Object)Maps.immutableEntry((Object)"b", (Object)2), forwarding.lastEntry());
        forwarding.put("c", 3);
        ForwardingNavigableMapTest.assertEquals((Object)Maps.immutableEntry((Object)"c", (Object)3), forwarding.lastEntry());
        forwarding.put("a", 1);
        ForwardingNavigableMapTest.assertEquals((Object)Maps.immutableEntry((Object)"c", (Object)3), forwarding.lastEntry());
        forwarding.remove("c");
        ForwardingNavigableMapTest.assertEquals((Object)Maps.immutableEntry((Object)"b", (Object)2), forwarding.lastEntry());
    }

    public void testLowerEntry() {
        this.forward().lowerEntry("key");
        ForwardingNavigableMapTest.assertEquals((String)"[lowerEntry(Object)]", (String)this.getCalls());
    }

    public void testLowerKey() {
        this.forward().lowerKey("key");
        ForwardingNavigableMapTest.assertEquals((String)"[lowerKey(Object)]", (String)this.getCalls());
    }

    public void testFloorEntry() {
        this.forward().floorEntry("key");
        ForwardingNavigableMapTest.assertEquals((String)"[floorEntry(Object)]", (String)this.getCalls());
    }

    public void testFloorKey() {
        this.forward().floorKey("key");
        ForwardingNavigableMapTest.assertEquals((String)"[floorKey(Object)]", (String)this.getCalls());
    }

    public void testCeilingEntry() {
        this.forward().ceilingEntry("key");
        ForwardingNavigableMapTest.assertEquals((String)"[ceilingEntry(Object)]", (String)this.getCalls());
    }

    public void testCeilingKey() {
        this.forward().ceilingKey("key");
        ForwardingNavigableMapTest.assertEquals((String)"[ceilingKey(Object)]", (String)this.getCalls());
    }

    public void testHigherEntry() {
        this.forward().higherEntry("key");
        ForwardingNavigableMapTest.assertEquals((String)"[higherEntry(Object)]", (String)this.getCalls());
    }

    public void testHigherKey() {
        this.forward().higherKey("key");
        ForwardingNavigableMapTest.assertEquals((String)"[higherKey(Object)]", (String)this.getCalls());
    }

    public void testPollFirstEntry() {
        this.forward().pollFirstEntry();
        ForwardingNavigableMapTest.assertEquals((String)"[pollFirstEntry]", (String)this.getCalls());
    }

    public void testPollLastEntry() {
        this.forward().pollLastEntry();
        ForwardingNavigableMapTest.assertEquals((String)"[pollLastEntry]", (String)this.getCalls());
    }

    public void testFirstEntry() {
        this.forward().firstEntry();
        ForwardingNavigableMapTest.assertEquals((String)"[firstEntry]", (String)this.getCalls());
    }

    public void testLastEntry() {
        this.forward().lastEntry();
        ForwardingNavigableMapTest.assertEquals((String)"[lastEntry]", (String)this.getCalls());
    }

    public void testDescendingMap() {
        this.forward().descendingMap();
        ForwardingNavigableMapTest.assertEquals((String)"[descendingMap]", (String)this.getCalls());
    }

    public void testNavigableKeySet() {
        this.forward().navigableKeySet();
        ForwardingNavigableMapTest.assertEquals((String)"[navigableKeySet]", (String)this.getCalls());
    }

    public void testDescendingKeySet() {
        this.forward().descendingKeySet();
        ForwardingNavigableMapTest.assertEquals((String)"[descendingKeySet]", (String)this.getCalls());
    }

    public void testSubMap_K_Bool_K_Bool() {
        this.forward().subMap("a", false, "b", true);
        ForwardingNavigableMapTest.assertEquals((String)"[subMap(Object,boolean,Object,boolean)]", (String)this.getCalls());
    }

    public void testHeadMap_K_Bool() {
        this.forward().headMap("a", false);
        ForwardingNavigableMapTest.assertEquals((String)"[headMap(Object,boolean)]", (String)this.getCalls());
    }

    public void testTailMap_K_Bool() {
        this.forward().tailMap("a", false);
        ForwardingNavigableMapTest.assertEquals((String)"[tailMap(Object,boolean)]", (String)this.getCalls());
    }

    @Override
    NavigableMap<String, Boolean> forward() {
        return (NavigableMap)super.forward();
    }

    static class StandardLastEntryForwardingNavigableMap<K, V>
    extends ForwardingNavigableMap<K, V> {
        private final NavigableMap<K, V> backingMap;

        StandardLastEntryForwardingNavigableMap(NavigableMap<K, V> backingMap) {
            this.backingMap = backingMap;
        }

        protected NavigableMap<K, V> delegate() {
            return this.backingMap;
        }

        public Map.Entry<K, V> lastEntry() {
            return this.standardLastEntry();
        }
    }

    static class StandardImplForwardingNavigableMap<K, V>
    extends ForwardingNavigableMap<K, V> {
        private final NavigableMap<K, V> backingMap;

        StandardImplForwardingNavigableMap(NavigableMap<K, V> backingMap) {
            this.backingMap = backingMap;
        }

        protected NavigableMap<K, V> delegate() {
            return this.backingMap;
        }

        public boolean containsKey(Object key) {
            return this.standardContainsKey(key);
        }

        public boolean containsValue(Object value) {
            return this.standardContainsValue(value);
        }

        public void putAll(Map<? extends K, ? extends V> map) {
            this.standardPutAll(map);
        }

        public V remove(Object object) {
            return (V)this.standardRemove(object);
        }

        public boolean equals(Object object) {
            return this.standardEquals(object);
        }

        public int hashCode() {
            return this.standardHashCode();
        }

        public Set<K> keySet() {
            return this.navigableKeySet();
        }

        public Collection<V> values() {
            return new ForwardingMap.StandardValues((ForwardingMap)this);
        }

        public String toString() {
            return this.standardToString();
        }

        public Set<Map.Entry<K, V>> entrySet() {
            return new ForwardingMap.StandardEntrySet(){

                public Iterator<Map.Entry<K, V>> iterator() {
                    return StandardImplForwardingNavigableMap.this.backingMap.entrySet().iterator();
                }
            };
        }

        public void clear() {
            this.standardClear();
        }

        public boolean isEmpty() {
            return this.standardIsEmpty();
        }

        public SortedMap<K, V> subMap(K fromKey, K toKey) {
            return this.standardSubMap(fromKey, toKey);
        }

        public Map.Entry<K, V> lowerEntry(K key) {
            return this.standardLowerEntry(key);
        }

        public K lowerKey(K key) {
            return (K)this.standardLowerKey(key);
        }

        public Map.Entry<K, V> floorEntry(K key) {
            return this.standardFloorEntry(key);
        }

        public K floorKey(K key) {
            return (K)this.standardFloorKey(key);
        }

        public Map.Entry<K, V> ceilingEntry(K key) {
            return this.standardCeilingEntry(key);
        }

        public K ceilingKey(K key) {
            return (K)this.standardCeilingKey(key);
        }

        public Map.Entry<K, V> higherEntry(K key) {
            return this.standardHigherEntry(key);
        }

        public K higherKey(K key) {
            return (K)this.standardHigherKey(key);
        }

        public Map.Entry<K, V> firstEntry() {
            return this.standardFirstEntry();
        }

        public Map.Entry<K, V> pollFirstEntry() {
            return this.standardPollFirstEntry();
        }

        public Map.Entry<K, V> pollLastEntry() {
            return this.standardPollLastEntry();
        }

        public NavigableMap<K, V> descendingMap() {
            return new ForwardingNavigableMap.StandardDescendingMap((ForwardingNavigableMap)this);
        }

        public NavigableSet<K> navigableKeySet() {
            return new ForwardingNavigableMap.StandardNavigableKeySet((ForwardingNavigableMap)this);
        }

        public NavigableSet<K> descendingKeySet() {
            return this.standardDescendingKeySet();
        }

        public K firstKey() {
            return (K)this.standardFirstKey();
        }

        public SortedMap<K, V> headMap(K toKey) {
            return this.standardHeadMap(toKey);
        }

        public K lastKey() {
            return (K)this.standardLastKey();
        }

        public SortedMap<K, V> tailMap(K fromKey) {
            return this.standardTailMap(fromKey);
        }
    }
}

