/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Joiner;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.collect.testing.MapInterfaceTest;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.Feature;
import com.google.common.collect.testing.features.MapFeature;
import com.google.common.collect.testing.google.BiMapGenerators;
import com.google.common.collect.testing.google.BiMapInverseTester;
import com.google.common.collect.testing.google.BiMapTestSuiteBuilder;
import com.google.common.collect.testing.google.TestBiMapGenerator;
import com.google.common.testing.SerializableTester;
import com.google.common.truth.Truth;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

@GwtCompatible(emulated=true)
public class ImmutableBiMapTest
extends TestCase {
    @GwtIncompatible
    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(MapTests.class);
        suite.addTestSuite(InverseMapTests.class);
        suite.addTestSuite(CreationTests.class);
        suite.addTestSuite(BiMapSpecificTests.class);
        suite.addTest((Test)((BiMapTestSuiteBuilder)((BiMapTestSuiteBuilder)((BiMapTestSuiteBuilder)BiMapTestSuiteBuilder.using((TestBiMapGenerator)new BiMapGenerators.ImmutableBiMapGenerator()).named("ImmutableBiMap")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.SERIALIZABLE, CollectionFeature.KNOWN_ORDER, MapFeature.REJECTS_DUPLICATES_AT_CREATION, MapFeature.ALLOWS_ANY_NULL_QUERIES})).suppressing((Collection)BiMapInverseTester.getInverseSameAfterSerializingMethods())).createTestSuite());
        suite.addTest((Test)((BiMapTestSuiteBuilder)((BiMapTestSuiteBuilder)((BiMapTestSuiteBuilder)BiMapTestSuiteBuilder.using((TestBiMapGenerator)new BiMapGenerators.ImmutableBiMapCopyOfGenerator()).named("ImmutableBiMap.copyOf[Map]")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.SERIALIZABLE, CollectionFeature.KNOWN_ORDER, MapFeature.ALLOWS_ANY_NULL_QUERIES})).suppressing((Collection)BiMapInverseTester.getInverseSameAfterSerializingMethods())).createTestSuite());
        suite.addTest((Test)((BiMapTestSuiteBuilder)((BiMapTestSuiteBuilder)((BiMapTestSuiteBuilder)BiMapTestSuiteBuilder.using((TestBiMapGenerator)new BiMapGenerators.ImmutableBiMapCopyOfEntriesGenerator()).named("ImmutableBiMap.copyOf[Iterable<Entry>]")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.SERIALIZABLE, CollectionFeature.KNOWN_ORDER, MapFeature.REJECTS_DUPLICATES_AT_CREATION, MapFeature.ALLOWS_ANY_NULL_QUERIES})).suppressing((Collection)BiMapInverseTester.getInverseSameAfterSerializingMethods())).createTestSuite());
        return suite;
    }

    private static <K, V> void assertMapEquals(Map<K, V> map, Object ... alternatingKeysAndValues) {
        int i = 0;
        for (Map.Entry<K, V> entry : map.entrySet()) {
            ImmutableBiMapTest.assertEquals((Object)alternatingKeysAndValues[i++], entry.getKey());
            ImmutableBiMapTest.assertEquals((Object)alternatingKeysAndValues[i++], entry.getValue());
        }
    }

    public static class BiMapSpecificTests
    extends TestCase {
        public void testForcePut() {
            ImmutableBiMap bimap = ImmutableBiMap.copyOf((Map)ImmutableMap.of((Object)"one", (Object)1, (Object)"two", (Object)2));
            try {
                bimap.forcePut((Object)"three", (Object)3);
                BiMapSpecificTests.fail();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }

        public void testKeySet() {
            ImmutableBiMap bimap = ImmutableBiMap.copyOf((Map)ImmutableMap.of((Object)"one", (Object)1, (Object)"two", (Object)2, (Object)"three", (Object)3, (Object)"four", (Object)4));
            ImmutableSet keys = bimap.keySet();
            BiMapSpecificTests.assertEquals((Object)Sets.newHashSet((Object[])new String[]{"one", "two", "three", "four"}), (Object)keys);
            Truth.assertThat((Iterable)keys).containsExactly(new Object[]{"one", "two", "three", "four"}).inOrder();
        }

        public void testValues() {
            ImmutableBiMap bimap = ImmutableBiMap.copyOf((Map)ImmutableMap.of((Object)"one", (Object)1, (Object)"two", (Object)2, (Object)"three", (Object)3, (Object)"four", (Object)4));
            ImmutableSet values = bimap.values();
            BiMapSpecificTests.assertEquals((Object)Sets.newHashSet((Object[])new Integer[]{1, 2, 3, 4}), (Object)values);
            Truth.assertThat((Iterable)values).containsExactly(new Object[]{1, 2, 3, 4}).inOrder();
        }

        public void testDoubleInverse() {
            ImmutableBiMap bimap = ImmutableBiMap.copyOf((Map)ImmutableMap.of((Object)"one", (Object)1, (Object)"two", (Object)2));
            BiMapSpecificTests.assertSame((Object)bimap, (Object)bimap.inverse().inverse());
        }

        @GwtIncompatible
        public void testEmptySerialization() {
            ImmutableBiMap bimap = ImmutableBiMap.of();
            BiMapSpecificTests.assertSame((Object)bimap, (Object)SerializableTester.reserializeAndAssert((Object)bimap));
        }

        @GwtIncompatible
        public void testSerialization() {
            ImmutableBiMap bimap = ImmutableBiMap.copyOf((Map)ImmutableMap.of((Object)"one", (Object)1, (Object)"two", (Object)2));
            ImmutableBiMap copy = (ImmutableBiMap)SerializableTester.reserializeAndAssert((Object)bimap);
            BiMapSpecificTests.assertEquals((Object)1, (Object)copy.get((Object)"one"));
            BiMapSpecificTests.assertEquals((String)"one", (String)((String)copy.inverse().get((Object)1)));
            BiMapSpecificTests.assertSame((Object)copy, (Object)copy.inverse().inverse());
        }

        @GwtIncompatible
        public void testInverseSerialization() {
            ImmutableBiMap bimap = ImmutableBiMap.copyOf((Map)ImmutableMap.of((Object)1, (Object)"one", (Object)2, (Object)"two")).inverse();
            ImmutableBiMap copy = (ImmutableBiMap)SerializableTester.reserializeAndAssert((Object)bimap);
            BiMapSpecificTests.assertEquals((Object)1, (Object)copy.get((Object)"one"));
            BiMapSpecificTests.assertEquals((String)"one", (String)((String)copy.inverse().get((Object)1)));
            BiMapSpecificTests.assertSame((Object)copy, (Object)copy.inverse().inverse());
        }
    }

    public static class CreationTests
    extends TestCase {
        public void testEmptyBuilder() {
            ImmutableBiMap map = new ImmutableBiMap.Builder().build();
            CreationTests.assertEquals(Collections.emptyMap(), (Object)map);
            CreationTests.assertEquals(Collections.emptyMap(), (Object)map.inverse());
            CreationTests.assertSame((Object)ImmutableBiMap.of(), (Object)map);
        }

        public void testSingletonBuilder() {
            ImmutableBiMap map = new ImmutableBiMap.Builder().put((Object)"one", (Object)1).build();
            ImmutableBiMapTest.assertMapEquals((Map)map, new Object[]{"one", 1});
            ImmutableBiMapTest.assertMapEquals((Map)map.inverse(), new Object[]{1, "one"});
        }

        public void testBuilder_withImmutableEntry() {
            ImmutableBiMap map = new ImmutableBiMap.Builder().put(Maps.immutableEntry((Object)"one", (Object)1)).build();
            ImmutableBiMapTest.assertMapEquals((Map)map, new Object[]{"one", 1});
        }

        public void testBuilder() {
            ImmutableBiMap map = ImmutableBiMap.builder().put((Object)"one", (Object)1).put((Object)"two", (Object)2).put((Object)"three", (Object)3).put((Object)"four", (Object)4).put((Object)"five", (Object)5).build();
            ImmutableBiMapTest.assertMapEquals((Map)map, new Object[]{"one", 1, "two", 2, "three", 3, "four", 4, "five", 5});
            ImmutableBiMapTest.assertMapEquals((Map)map.inverse(), new Object[]{1, "one", 2, "two", 3, "three", 4, "four", 5, "five"});
        }

        public void testBuilder_orderEntriesByValue() {
            ImmutableBiMap map = ImmutableBiMap.builder().orderEntriesByValue((Comparator)Ordering.natural()).put((Object)"three", (Object)3).put((Object)"one", (Object)1).put((Object)"five", (Object)5).put((Object)"four", (Object)4).put((Object)"two", (Object)2).build();
            ImmutableBiMapTest.assertMapEquals((Map)map, new Object[]{"one", 1, "two", 2, "three", 3, "four", 4, "five", 5});
            ImmutableBiMapTest.assertMapEquals((Map)map.inverse(), new Object[]{1, "one", 2, "two", 3, "three", 4, "four", 5, "five"});
        }

        public void testBuilder_orderEntriesByValueAfterExactSizeBuild() {
            ImmutableBiMap.Builder builder = new ImmutableBiMap.Builder(2).put((Object)"four", (Object)4).put((Object)"one", (Object)1);
            ImmutableBiMap keyOrdered = builder.build();
            ImmutableBiMap valueOrdered = builder.orderEntriesByValue((Comparator)Ordering.natural()).build();
            ImmutableBiMapTest.assertMapEquals((Map)keyOrdered, new Object[]{"four", 4, "one", 1});
            ImmutableBiMapTest.assertMapEquals((Map)valueOrdered, new Object[]{"one", 1, "four", 4});
        }

        public void testBuilder_orderEntriesByValue_usedTwiceFails() {
            ImmutableBiMap.Builder builder = new ImmutableBiMap.Builder().orderEntriesByValue((Comparator)Ordering.natural());
            try {
                builder.orderEntriesByValue((Comparator)Ordering.natural());
                CreationTests.fail((String)"Expected IllegalStateException");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }

        public void testBuilderPutAllWithEmptyMap() {
            ImmutableBiMap map = new ImmutableBiMap.Builder().putAll(Collections.emptyMap()).build();
            CreationTests.assertEquals(Collections.emptyMap(), (Object)map);
        }

        public void testBuilderPutAll() {
            LinkedHashMap<String, Integer> toPut = new LinkedHashMap<String, Integer>();
            toPut.put("one", 1);
            toPut.put("two", 2);
            toPut.put("three", 3);
            LinkedHashMap<String, Integer> moreToPut = new LinkedHashMap<String, Integer>();
            moreToPut.put("four", 4);
            moreToPut.put("five", 5);
            ImmutableBiMap map = new ImmutableBiMap.Builder().putAll(toPut).putAll(moreToPut).build();
            ImmutableBiMapTest.assertMapEquals((Map)map, new Object[]{"one", 1, "two", 2, "three", 3, "four", 4, "five", 5});
            ImmutableBiMapTest.assertMapEquals((Map)map.inverse(), new Object[]{1, "one", 2, "two", 3, "three", 4, "four", 5, "five"});
        }

        public void testBuilderReuse() {
            ImmutableBiMap.Builder builder = new ImmutableBiMap.Builder();
            ImmutableBiMap mapOne = builder.put((Object)"one", (Object)1).put((Object)"two", (Object)2).build();
            ImmutableBiMap mapTwo = builder.put((Object)"three", (Object)3).put((Object)"four", (Object)4).build();
            ImmutableBiMapTest.assertMapEquals((Map)mapOne, new Object[]{"one", 1, "two", 2});
            ImmutableBiMapTest.assertMapEquals((Map)mapOne.inverse(), new Object[]{1, "one", 2, "two"});
            ImmutableBiMapTest.assertMapEquals((Map)mapTwo, new Object[]{"one", 1, "two", 2, "three", 3, "four", 4});
            ImmutableBiMapTest.assertMapEquals((Map)mapTwo.inverse(), new Object[]{1, "one", 2, "two", 3, "three", 4, "four"});
        }

        public void testBuilderPutNullKey() {
            ImmutableBiMap.Builder builder = new ImmutableBiMap.Builder();
            try {
                builder.put(null, (Object)1);
                CreationTests.fail();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }

        public void testBuilderPutNullValue() {
            ImmutableBiMap.Builder builder = new ImmutableBiMap.Builder();
            try {
                builder.put((Object)"one", null);
                CreationTests.fail();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }

        public void testBuilderPutNullKeyViaPutAll() {
            ImmutableBiMap.Builder builder = new ImmutableBiMap.Builder();
            try {
                builder.putAll(Collections.singletonMap(null, 1));
                CreationTests.fail();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }

        public void testBuilderPutNullValueViaPutAll() {
            ImmutableBiMap.Builder builder = new ImmutableBiMap.Builder();
            try {
                builder.putAll(Collections.singletonMap("one", null));
                CreationTests.fail();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }

        public void testPuttingTheSameKeyTwiceThrowsOnBuild() {
            ImmutableBiMap.Builder builder = new ImmutableBiMap.Builder().put((Object)"one", (Object)1).put((Object)"one", (Object)1);
            try {
                builder.build();
                CreationTests.fail();
            }
            catch (IllegalArgumentException expected) {
                Truth.assertThat((String)expected.getMessage()).contains((CharSequence)"one");
            }
        }

        public void testOf() {
            ImmutableBiMapTest.assertMapEquals((Map)ImmutableBiMap.of((Object)"one", (Object)1), new Object[]{"one", 1});
            ImmutableBiMapTest.assertMapEquals((Map)ImmutableBiMap.of((Object)"one", (Object)1).inverse(), new Object[]{1, "one"});
            ImmutableBiMapTest.assertMapEquals((Map)ImmutableBiMap.of((Object)"one", (Object)1, (Object)"two", (Object)2), new Object[]{"one", 1, "two", 2});
            ImmutableBiMapTest.assertMapEquals((Map)ImmutableBiMap.of((Object)"one", (Object)1, (Object)"two", (Object)2).inverse(), new Object[]{1, "one", 2, "two"});
            ImmutableBiMapTest.assertMapEquals((Map)ImmutableBiMap.of((Object)"one", (Object)1, (Object)"two", (Object)2, (Object)"three", (Object)3), new Object[]{"one", 1, "two", 2, "three", 3});
            ImmutableBiMapTest.assertMapEquals((Map)ImmutableBiMap.of((Object)"one", (Object)1, (Object)"two", (Object)2, (Object)"three", (Object)3).inverse(), new Object[]{1, "one", 2, "two", 3, "three"});
            ImmutableBiMapTest.assertMapEquals((Map)ImmutableBiMap.of((Object)"one", (Object)1, (Object)"two", (Object)2, (Object)"three", (Object)3, (Object)"four", (Object)4), new Object[]{"one", 1, "two", 2, "three", 3, "four", 4});
            ImmutableBiMapTest.assertMapEquals((Map)ImmutableBiMap.of((Object)"one", (Object)1, (Object)"two", (Object)2, (Object)"three", (Object)3, (Object)"four", (Object)4).inverse(), new Object[]{1, "one", 2, "two", 3, "three", 4, "four"});
            ImmutableBiMapTest.assertMapEquals((Map)ImmutableBiMap.of((Object)"one", (Object)1, (Object)"two", (Object)2, (Object)"three", (Object)3, (Object)"four", (Object)4, (Object)"five", (Object)5), new Object[]{"one", 1, "two", 2, "three", 3, "four", 4, "five", 5});
            ImmutableBiMapTest.assertMapEquals((Map)ImmutableBiMap.of((Object)"one", (Object)1, (Object)"two", (Object)2, (Object)"three", (Object)3, (Object)"four", (Object)4, (Object)"five", (Object)5).inverse(), new Object[]{1, "one", 2, "two", 3, "three", 4, "four", 5, "five"});
        }

        public void testOfNullKey() {
            try {
                ImmutableBiMap.of(null, (Object)1);
                CreationTests.fail();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            try {
                ImmutableBiMap.of((Object)"one", (Object)1, null, (Object)2);
                CreationTests.fail();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }

        public void testOfNullValue() {
            try {
                ImmutableBiMap.of((Object)"one", null);
                CreationTests.fail();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            try {
                ImmutableBiMap.of((Object)"one", (Object)1, (Object)"two", null);
                CreationTests.fail();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }

        public void testOfWithDuplicateKey() {
            try {
                ImmutableBiMap.of((Object)"one", (Object)1, (Object)"one", (Object)1);
                CreationTests.fail();
            }
            catch (IllegalArgumentException expected) {
                Truth.assertThat((String)expected.getMessage()).contains((CharSequence)"one");
            }
        }

        public void testCopyOfEmptyMap() {
            ImmutableBiMap copy = ImmutableBiMap.copyOf(Collections.emptyMap());
            CreationTests.assertEquals(Collections.emptyMap(), (Object)copy);
            CreationTests.assertSame((Object)copy, (Object)ImmutableBiMap.copyOf((Map)copy));
            CreationTests.assertSame((Object)ImmutableBiMap.of(), (Object)copy);
        }

        public void testCopyOfSingletonMap() {
            ImmutableBiMap copy = ImmutableBiMap.copyOf(Collections.singletonMap("one", 1));
            ImmutableBiMapTest.assertMapEquals((Map)copy, new Object[]{"one", 1});
            CreationTests.assertSame((Object)copy, (Object)ImmutableBiMap.copyOf((Map)copy));
        }

        public void testCopyOf() {
            LinkedHashMap<String, Integer> original = new LinkedHashMap<String, Integer>();
            original.put("one", 1);
            original.put("two", 2);
            original.put("three", 3);
            ImmutableBiMap copy = ImmutableBiMap.copyOf(original);
            ImmutableBiMapTest.assertMapEquals((Map)copy, new Object[]{"one", 1, "two", 2, "three", 3});
            CreationTests.assertSame((Object)copy, (Object)ImmutableBiMap.copyOf((Map)copy));
        }

        public void testEmpty() {
            ImmutableBiMap bimap = ImmutableBiMap.of();
            CreationTests.assertEquals(Collections.emptyMap(), (Object)bimap);
            CreationTests.assertEquals(Collections.emptyMap(), (Object)bimap.inverse());
        }

        public void testFromHashMap() {
            LinkedHashMap hashMap = Maps.newLinkedHashMap();
            hashMap.put("one", 1);
            hashMap.put("two", 2);
            ImmutableBiMap bimap = ImmutableBiMap.copyOf((Map)ImmutableMap.of((Object)"one", (Object)1, (Object)"two", (Object)2));
            ImmutableBiMapTest.assertMapEquals((Map)bimap, new Object[]{"one", 1, "two", 2});
            ImmutableBiMapTest.assertMapEquals((Map)bimap.inverse(), new Object[]{1, "one", 2, "two"});
        }

        public void testFromImmutableMap() {
            ImmutableBiMap bimap = ImmutableBiMap.copyOf((Map)new ImmutableMap.Builder().put((Object)"one", (Object)1).put((Object)"two", (Object)2).put((Object)"three", (Object)3).put((Object)"four", (Object)4).put((Object)"five", (Object)5).build());
            ImmutableBiMapTest.assertMapEquals((Map)bimap, new Object[]{"one", 1, "two", 2, "three", 3, "four", 4, "five", 5});
            ImmutableBiMapTest.assertMapEquals((Map)bimap.inverse(), new Object[]{1, "one", 2, "two", 3, "three", 4, "four", 5, "five"});
        }

        public void testDuplicateValues() {
            ImmutableMap map = new ImmutableMap.Builder().put((Object)"one", (Object)1).put((Object)"two", (Object)2).put((Object)"uno", (Object)1).put((Object)"dos", (Object)2).build();
            try {
                ImmutableBiMap.copyOf((Map)map);
                CreationTests.fail();
            }
            catch (IllegalArgumentException expected) {
                Truth.assertThat((String)expected.getMessage()).contains((CharSequence)"1");
            }
        }
    }

    public static class InverseMapTests
    extends AbstractMapTests<String, Integer> {
        @Override
        protected Map<String, Integer> makeEmptyMap() {
            return ImmutableBiMap.of();
        }

        protected Map<String, Integer> makePopulatedMap() {
            return ImmutableBiMap.of((Object)1, (Object)"one", (Object)2, (Object)"two", (Object)3, (Object)"three").inverse();
        }

        protected String getKeyNotInPopulatedMap() {
            return "minus one";
        }

        protected Integer getValueNotInPopulatedMap() {
            return -1;
        }
    }

    public static class MapTests
    extends AbstractMapTests<String, Integer> {
        @Override
        protected Map<String, Integer> makeEmptyMap() {
            return ImmutableBiMap.of();
        }

        protected Map<String, Integer> makePopulatedMap() {
            return ImmutableBiMap.of((Object)"one", (Object)1, (Object)"two", (Object)2, (Object)"three", (Object)3);
        }

        protected String getKeyNotInPopulatedMap() {
            return "minus one";
        }

        protected Integer getValueNotInPopulatedMap() {
            return -1;
        }
    }

    public static abstract class AbstractMapTests<K, V>
    extends MapInterfaceTest<K, V> {
        private static final Joiner joiner = Joiner.on((String)", ");

        public AbstractMapTests() {
            super(false, false, false, false, false);
        }

        protected Map<K, V> makeEmptyMap() {
            throw new UnsupportedOperationException();
        }

        protected void assertMoreInvariants(Map<K, V> map) {
            BiMap bimap = (BiMap)map;
            for (Map.Entry<K, V> entry : map.entrySet()) {
                AbstractMapTests.assertEquals((String)(entry.getKey() + "=" + entry.getValue()), (String)entry.toString());
                AbstractMapTests.assertEquals(entry.getKey(), (Object)bimap.inverse().get(entry.getValue()));
            }
            AbstractMapTests.assertEquals((String)("{" + joiner.join(map.entrySet()) + "}"), (String)map.toString());
            AbstractMapTests.assertEquals((String)("[" + joiner.join(map.entrySet()) + "]"), (String)map.entrySet().toString());
            AbstractMapTests.assertEquals((String)("[" + joiner.join(map.keySet()) + "]"), (String)map.keySet().toString());
            AbstractMapTests.assertEquals((String)("[" + joiner.join(map.values()) + "]"), (String)map.values().toString());
            AbstractMapTests.assertEquals((Object)Sets.newHashSet(map.entrySet()), map.entrySet());
            AbstractMapTests.assertEquals((Object)Sets.newHashSet(map.keySet()), map.keySet());
        }
    }
}

