/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Function;
import com.google.common.collect.ComputationException;
import com.google.common.collect.MapMaker;
import com.google.common.testing.NullPointerTester;
import com.google.common.util.concurrent.Uninterruptibles;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;

@GwtCompatible(emulated=true)
public class MapMakerTest
extends TestCase {
    @GwtIncompatible
    public void testNullParameters() throws Exception {
        NullPointerTester tester = new NullPointerTester();
        tester.testAllPublicInstanceMethods((Object)new MapMaker());
    }

    @GwtIncompatible
    public void testRemovalNotification_clear() throws InterruptedException {
        CountDownLatch computingLatch = new CountDownLatch(1);
        DelayingIdentityLoader computingFunction = new DelayingIdentityLoader(computingLatch);
        final ConcurrentMap map = new MapMaker().concurrencyLevel(1).makeComputingMap(computingFunction);
        map.put("a", "a");
        final CountDownLatch computationStarted = new CountDownLatch(1);
        final CountDownLatch computationComplete = new CountDownLatch(1);
        new Thread(new Runnable(){

            @Override
            public void run() {
                computationStarted.countDown();
                map.get("b");
                computationComplete.countDown();
            }
        }).start();
        computationStarted.await();
        map.clear();
        computingLatch.countDown();
        computationComplete.await();
        MapMakerTest.assertEquals((int)1, (int)map.size());
        MapMakerTest.assertEquals((String)"b", (String)((String)map.get("b")));
    }

    public static class ComputingTest
    extends TestCase {
        public void testComputerThatReturnsNull() {
            ConcurrentMap map = new MapMaker().makeComputingMap((Function)new Function<Integer, String>(){

                public String apply(Integer key) {
                    return null;
                }
            });
            try {
                map.get(1);
                ComputingTest.fail();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }

        public void testRuntimeException() {
            final RuntimeException e = new RuntimeException();
            ConcurrentMap map = new MapMaker().makeComputingMap((Function)new Function<Object, Object>(){

                public Object apply(Object from) {
                    throw e;
                }
            });
            try {
                map.get(new Object());
                ComputingTest.fail();
            }
            catch (ComputationException ce) {
                ComputingTest.assertSame((Object)e, (Object)ce.getCause());
            }
        }
    }

    public static class RecursiveComputationTest
    extends TestCase {
        Function<Integer, String> recursiveComputer = new Function<Integer, String>(){

            public String apply(Integer key) {
                if (key > 0) {
                    return key + ", " + (String)RecursiveComputationTest.this.recursiveMap.get(key - 1);
                }
                return "0";
            }
        };
        ConcurrentMap<Integer, String> recursiveMap = new MapMaker().makeComputingMap(this.recursiveComputer);

        public void testRecursiveComputation() {
            RecursiveComputationTest.assertEquals((String)"3, 2, 1, 0", (String)((String)this.recursiveMap.get(3)));
        }
    }

    public static class MakerTest
    extends TestCase {
        public void testInitialCapacity_negative() {
            MapMaker maker = new MapMaker();
            try {
                maker.initialCapacity(-1);
                MakerTest.fail();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        public void xtestInitialCapacity_setTwice() {
            MapMaker maker = new MapMaker().initialCapacity(16);
            try {
                maker.initialCapacity(16);
                MakerTest.fail();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        public void testExpiration_setTwice() {
            MapMaker maker = new MapMaker().expireAfterWrite(1L, TimeUnit.HOURS);
            try {
                maker.expireAfterWrite(1L, TimeUnit.HOURS);
                MakerTest.fail();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }

        public void testReturnsPlainConcurrentHashMapWhenPossible() {
            ConcurrentMap map = new MapMaker().initialCapacity(5).makeMap();
            MakerTest.assertTrue((boolean)(map instanceof ConcurrentHashMap));
        }
    }

    @GwtIncompatible
    static final class DelayingIdentityLoader<T>
    implements Function<T, T> {
        private final CountDownLatch delayLatch;

        DelayingIdentityLoader(CountDownLatch delayLatch) {
            this.delayLatch = delayLatch;
        }

        public T apply(T key) {
            Uninterruptibles.awaitUninterruptibly((CountDownLatch)this.delayLatch);
            return key;
        }
    }
}

