/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.caliper.BeforeExperiment;
import com.google.caliper.Benchmark;
import com.google.caliper.Param;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.TreeMultiset;
import java.util.Random;

public class MultisetIteratorBenchmark {
    @Param(value={"0", "1", "16", "256", "4096", "65536"})
    int size;
    LinkedHashMultiset<Object> linkedHashMultiset;
    HashMultiset<Object> hashMultiset;
    TreeMultiset<Integer> treeMultiset;

    @BeforeExperiment
    void setUp() {
        this.hashMultiset = HashMultiset.create((int)this.size);
        this.linkedHashMultiset = LinkedHashMultiset.create((int)this.size);
        this.treeMultiset = TreeMultiset.create();
        Random random = new Random();
        int sizeRemaining = this.size;
        int i = 0;
        while (sizeRemaining > 0) {
            Integer value = random.nextInt(1000) + 128;
            int count = Math.min(random.nextInt(10) + 1, sizeRemaining);
            sizeRemaining -= count;
            this.hashMultiset.add((Object)value, count);
            this.linkedHashMultiset.add((Object)value, count);
            this.treeMultiset.add((Object)value, count);
            ++i;
        }
        Preconditions.checkState((this.hashMultiset.size() == this.size ? 1 : 0) != 0);
    }

    @Benchmark
    int hashMultiset(int reps) {
        int sum = 0;
        for (int i = 0; i < reps; ++i) {
            for (Object value : this.hashMultiset) {
                sum += value.hashCode();
            }
        }
        return sum;
    }

    @Benchmark
    int linkedHashMultiset(int reps) {
        int sum = 0;
        for (int i = 0; i < reps; ++i) {
            for (Object value : this.linkedHashMultiset) {
                sum += value.hashCode();
            }
        }
        return sum;
    }

    @Benchmark
    int treeMultiset(int reps) {
        int sum = 0;
        for (int i = 0; i < reps; ++i) {
            for (Object value : this.treeMultiset) {
                sum += value.hashCode();
            }
        }
        return sum;
    }
}

