/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.caliper.BeforeExperiment;
import com.google.caliper.Benchmark;
import com.google.caliper.Param;
import com.google.common.collect.BenchmarkHelpers;
import com.google.common.collect.CollectionBenchmarkSampleData;
import com.google.common.collect.SpecialRandom;
import java.util.Set;

public class SetContainsBenchmark {
    @Param(value={"5", "30", "180", "1100", "6900", "43000", "260000"})
    private int size;
    @Param(value={"0.2", "0.8"})
    private double hitRate;
    @Param(value={"true"})
    private boolean isUserTypeFast;
    @Param(value={""})
    private SpecialRandom random;
    @Param(value={"Hash", "Immutable"})
    private BenchmarkHelpers.SetImpl impl;
    private CollectionBenchmarkSampleData.Element[] queries;
    private Set<CollectionBenchmarkSampleData.Element> setToTest;

    @BeforeExperiment
    void setUp() {
        CollectionBenchmarkSampleData sampleData = new CollectionBenchmarkSampleData(this.isUserTypeFast, this.random, this.hitRate, this.size);
        this.setToTest = this.impl.create(sampleData.getValuesInSet());
        this.queries = sampleData.getQueries();
    }

    @Benchmark
    boolean contains(int reps) {
        Set<CollectionBenchmarkSampleData.Element> set = this.setToTest;
        CollectionBenchmarkSampleData.Element[] queries = this.queries;
        int mask = queries.length - 1;
        boolean dummy = false;
        for (int i = 0; i < reps; ++i) {
            dummy ^= set.contains(queries[i & mask]);
        }
        return dummy;
    }
}

