/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.collect.testing.SetTestSuiteBuilder;
import com.google.common.collect.testing.TestSetGenerator;
import com.google.common.collect.testing.TestStringSetGenerator;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.Feature;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

@GwtCompatible(emulated=true)
public class SetOperationsTest
extends TestCase {
    @GwtIncompatible
    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)((SetTestSuiteBuilder)((SetTestSuiteBuilder)SetTestSuiteBuilder.using((TestSetGenerator)new TestStringSetGenerator(){

            protected Set<String> create(String[] elements) {
                return Sets.union((Set)Sets.newHashSet(), (Set)Sets.newHashSet());
            }
        }).named("empty U empty")).withFeatures(new Feature[]{CollectionSize.ZERO, CollectionFeature.NONE, CollectionFeature.ALLOWS_NULL_VALUES})).createTestSuite());
        suite.addTest((Test)((SetTestSuiteBuilder)((SetTestSuiteBuilder)SetTestSuiteBuilder.using((TestSetGenerator)new TestStringSetGenerator(){

            protected Set<String> create(String[] elements) {
                Preconditions.checkArgument((elements.length == 1 ? 1 : 0) != 0);
                return Sets.union((Set)Sets.newHashSet((Object[])elements), (Set)Sets.newHashSet((Object[])elements));
            }
        }).named("singleton U itself")).withFeatures(new Feature[]{CollectionSize.ONE, CollectionFeature.ALLOWS_NULL_VALUES})).createTestSuite());
        suite.addTest((Test)((SetTestSuiteBuilder)((SetTestSuiteBuilder)SetTestSuiteBuilder.using((TestSetGenerator)new TestStringSetGenerator(){

            protected Set<String> create(String[] elements) {
                return Sets.union((Set)Sets.newHashSet(), (Set)Sets.newHashSet((Object[])elements));
            }
        }).named("empty U set")).withFeatures(new Feature[]{CollectionSize.ONE, CollectionSize.SEVERAL, CollectionFeature.ALLOWS_NULL_VALUES})).createTestSuite());
        suite.addTest((Test)((SetTestSuiteBuilder)((SetTestSuiteBuilder)SetTestSuiteBuilder.using((TestSetGenerator)new TestStringSetGenerator(){

            protected Set<String> create(String[] elements) {
                return Sets.union((Set)Sets.newHashSet((Object[])elements), (Set)Sets.newHashSet());
            }
        }).named("set U empty")).withFeatures(new Feature[]{CollectionSize.ONE, CollectionSize.SEVERAL, CollectionFeature.ALLOWS_NULL_VALUES})).createTestSuite());
        suite.addTest((Test)((SetTestSuiteBuilder)((SetTestSuiteBuilder)SetTestSuiteBuilder.using((TestSetGenerator)new TestStringSetGenerator(){

            protected Set<String> create(String[] elements) {
                Preconditions.checkArgument((elements.length == 3 ? 1 : 0) != 0);
                return Sets.union((Set)Sets.newLinkedHashSet(Arrays.asList(elements)), (Set)Sets.newLinkedHashSet(Arrays.asList(elements[1], elements[0], elements[2])));
            }
        }).named("set U itself")).withFeatures(new Feature[]{CollectionSize.SEVERAL, CollectionFeature.ALLOWS_NULL_VALUES})).createTestSuite());
        suite.addTest((Test)((SetTestSuiteBuilder)((SetTestSuiteBuilder)SetTestSuiteBuilder.using((TestSetGenerator)new TestStringSetGenerator(){

            protected Set<String> create(String[] elements) {
                Preconditions.checkArgument((elements.length == 3 ? 1 : 0) != 0);
                return Sets.union((Set)Sets.newHashSet((Object[])new String[]{elements[0]}), (Set)Sets.newHashSet((Object[])new String[]{elements[1], elements[2]}));
            }
        }).named("union of disjoint")).withFeatures(new Feature[]{CollectionSize.SEVERAL, CollectionFeature.ALLOWS_NULL_VALUES})).createTestSuite());
        suite.addTest((Test)((SetTestSuiteBuilder)((SetTestSuiteBuilder)SetTestSuiteBuilder.using((TestSetGenerator)new TestStringSetGenerator(){

            protected Set<String> create(String[] elements) {
                return Sets.union((Set)Sets.newHashSet((Object[])new String[]{elements[0], elements[1]}), (Set)Sets.newHashSet((Object[])new String[]{elements[1], elements[2]}));
            }
        }).named("venn")).withFeatures(new Feature[]{CollectionSize.SEVERAL, CollectionFeature.ALLOWS_NULL_VALUES})).createTestSuite());
        suite.addTest((Test)((SetTestSuiteBuilder)((SetTestSuiteBuilder)SetTestSuiteBuilder.using((TestSetGenerator)new TestStringSetGenerator(){

            protected Set<String> create(String[] elements) {
                return Sets.intersection((Set)Sets.newHashSet(), (Set)Sets.newHashSet());
            }
        }).named("empty & empty")).withFeatures(new Feature[]{CollectionSize.ZERO, CollectionFeature.NONE, CollectionFeature.ALLOWS_NULL_VALUES})).createTestSuite());
        suite.addTest((Test)((SetTestSuiteBuilder)((SetTestSuiteBuilder)SetTestSuiteBuilder.using((TestSetGenerator)new TestStringSetGenerator(){

            protected Set<String> create(String[] elements) {
                return Sets.intersection((Set)Sets.newHashSet(), (Set)Sets.newHashSet((Object[])new String[]{null}));
            }
        }).named("empty & singleton")).withFeatures(new Feature[]{CollectionSize.ZERO, CollectionFeature.NONE, CollectionFeature.ALLOWS_NULL_VALUES})).createTestSuite());
        suite.addTest((Test)((SetTestSuiteBuilder)((SetTestSuiteBuilder)SetTestSuiteBuilder.using((TestSetGenerator)new TestStringSetGenerator(){

            protected Set<String> create(String[] elements) {
                return Sets.intersection((Set)Sets.newHashSet((Object[])new String[]{"a", "b"}), (Set)Sets.newHashSet((Object[])new String[]{"c", "d"}));
            }
        }).named("intersection of disjoint")).withFeatures(new Feature[]{CollectionSize.ZERO, CollectionFeature.NONE, CollectionFeature.ALLOWS_NULL_VALUES})).createTestSuite());
        suite.addTest((Test)((SetTestSuiteBuilder)((SetTestSuiteBuilder)SetTestSuiteBuilder.using((TestSetGenerator)new TestStringSetGenerator(){

            protected Set<String> create(String[] elements) {
                return Sets.intersection((Set)Sets.newHashSet((Object[])elements), (Set)Sets.newHashSet((Object[])elements));
            }
        }).named("set & itself")).withFeatures(new Feature[]{CollectionSize.ONE, CollectionSize.SEVERAL, CollectionFeature.ALLOWS_NULL_VALUES})).createTestSuite());
        suite.addTest((Test)((SetTestSuiteBuilder)((SetTestSuiteBuilder)SetTestSuiteBuilder.using((TestSetGenerator)new TestStringSetGenerator(){

            protected Set<String> create(String[] elements) {
                return Sets.intersection((Set)Sets.newHashSet((Object[])new String[]{"a", elements[0], "b"}), (Set)Sets.newHashSet((Object[])new String[]{"c", elements[0], "d"}));
            }
        }).named("intersection with overlap of one")).withFeatures(new Feature[]{CollectionSize.ONE, CollectionFeature.ALLOWS_NULL_VALUES})).createTestSuite());
        suite.addTest((Test)((SetTestSuiteBuilder)((SetTestSuiteBuilder)SetTestSuiteBuilder.using((TestSetGenerator)new TestStringSetGenerator(){

            protected Set<String> create(String[] elements) {
                return Sets.difference((Set)Sets.newHashSet(), (Set)Sets.newHashSet());
            }
        }).named("empty - empty")).withFeatures(new Feature[]{CollectionSize.ZERO, CollectionFeature.NONE, CollectionFeature.ALLOWS_NULL_VALUES})).createTestSuite());
        suite.addTest((Test)((SetTestSuiteBuilder)((SetTestSuiteBuilder)SetTestSuiteBuilder.using((TestSetGenerator)new TestStringSetGenerator(){

            protected Set<String> create(String[] elements) {
                return Sets.difference((Set)Sets.newHashSet((Object[])new String[]{"a"}), (Set)Sets.newHashSet((Object[])new String[]{"a"}));
            }
        }).named("singleton - itself")).withFeatures(new Feature[]{CollectionSize.ZERO, CollectionFeature.NONE, CollectionFeature.ALLOWS_NULL_VALUES})).createTestSuite());
        suite.addTest((Test)((SetTestSuiteBuilder)((SetTestSuiteBuilder)SetTestSuiteBuilder.using((TestSetGenerator)new TestStringSetGenerator(){

            protected Set<String> create(String[] elements) {
                HashSet set = Sets.newHashSet((Object[])new String[]{"b", "c"});
                HashSet other = Sets.newHashSet((Object[])new String[]{"a", "b", "c", "d"});
                return Sets.difference((Set)set, (Set)other);
            }
        }).named("set - superset")).withFeatures(new Feature[]{CollectionSize.ZERO, CollectionFeature.NONE, CollectionFeature.ALLOWS_NULL_VALUES})).createTestSuite());
        suite.addTest((Test)((SetTestSuiteBuilder)((SetTestSuiteBuilder)SetTestSuiteBuilder.using((TestSetGenerator)new TestStringSetGenerator(){

            protected Set<String> create(String[] elements) {
                HashSet set = Sets.newHashSet((Object[])elements);
                HashSet other = Sets.newHashSet((Object[])new String[]{"wz", "xq"});
                set.addAll(other);
                other.add("pq");
                return Sets.difference((Set)set, (Set)other);
            }
        }).named("set - set")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.ALLOWS_NULL_VALUES, CollectionFeature.ALLOWS_NULL_VALUES})).createTestSuite());
        suite.addTest((Test)((SetTestSuiteBuilder)((SetTestSuiteBuilder)SetTestSuiteBuilder.using((TestSetGenerator)new TestStringSetGenerator(){

            protected Set<String> create(String[] elements) {
                return Sets.difference((Set)Sets.newHashSet((Object[])elements), (Set)Sets.newHashSet());
            }
        }).named("set - empty")).withFeatures(new Feature[]{CollectionSize.ONE, CollectionSize.SEVERAL, CollectionFeature.ALLOWS_NULL_VALUES})).createTestSuite());
        suite.addTest((Test)((SetTestSuiteBuilder)((SetTestSuiteBuilder)SetTestSuiteBuilder.using((TestSetGenerator)new TestStringSetGenerator(){

            protected Set<String> create(String[] elements) {
                return Sets.difference((Set)Sets.newHashSet((Object[])elements), (Set)Sets.newHashSet((Object[])new String[]{"xx", "xq"}));
            }
        }).named("set - disjoint")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.ALLOWS_NULL_VALUES})).createTestSuite());
        suite.addTestSuite(MoreTests.class);
        return suite;
    }

    public static class MoreTests
    extends TestCase {
        Set<String> friends;
        Set<String> enemies;

        public void setUp() {
            this.friends = Sets.newHashSet((Object[])new String[]{"Tom", "Joe", "Dave"});
            this.enemies = Sets.newHashSet((Object[])new String[]{"Dick", "Harry", "Tom"});
        }

        public void testUnion() {
            Sets.SetView all = Sets.union(this.friends, this.enemies);
            MoreTests.assertEquals((int)5, (int)all.size());
            ImmutableSet immut = Sets.union(this.friends, this.enemies).immutableCopy();
            HashSet mut = (HashSet)Sets.union(this.friends, this.enemies).copyInto(new HashSet());
            this.enemies.add("Buck");
            MoreTests.assertEquals((int)6, (int)all.size());
            MoreTests.assertEquals((int)5, (int)immut.size());
            MoreTests.assertEquals((int)5, (int)mut.size());
        }

        public void testIntersection() {
            HashSet friends = Sets.newHashSet((Object[])new String[]{"Tom", "Joe", "Dave"});
            HashSet enemies = Sets.newHashSet((Object[])new String[]{"Dick", "Harry", "Tom"});
            Sets.SetView frenemies = Sets.intersection((Set)friends, (Set)enemies);
            MoreTests.assertEquals((int)1, (int)frenemies.size());
            ImmutableSet immut = Sets.intersection((Set)friends, (Set)enemies).immutableCopy();
            HashSet mut = (HashSet)Sets.intersection((Set)friends, (Set)enemies).copyInto(new HashSet());
            enemies.add("Joe");
            MoreTests.assertEquals((int)2, (int)frenemies.size());
            MoreTests.assertEquals((int)1, (int)immut.size());
            MoreTests.assertEquals((int)1, (int)mut.size());
        }

        public void testDifference() {
            HashSet friends = Sets.newHashSet((Object[])new String[]{"Tom", "Joe", "Dave"});
            HashSet enemies = Sets.newHashSet((Object[])new String[]{"Dick", "Harry", "Tom"});
            Sets.SetView goodFriends = Sets.difference((Set)friends, (Set)enemies);
            MoreTests.assertEquals((int)2, (int)goodFriends.size());
            ImmutableSet immut = Sets.difference((Set)friends, (Set)enemies).immutableCopy();
            HashSet mut = (HashSet)Sets.difference((Set)friends, (Set)enemies).copyInto(new HashSet());
            enemies.add("Dave");
            MoreTests.assertEquals((int)1, (int)goodFriends.size());
            MoreTests.assertEquals((int)2, (int)immut.size());
            MoreTests.assertEquals((int)2, (int)mut.size());
        }

        public void testSymmetricDifference() {
            HashSet friends = Sets.newHashSet((Object[])new String[]{"Tom", "Joe", "Dave"});
            HashSet enemies = Sets.newHashSet((Object[])new String[]{"Dick", "Harry", "Tom"});
            Sets.SetView symmetricDifferenceFriendsFirst = Sets.symmetricDifference((Set)friends, (Set)enemies);
            MoreTests.assertEquals((int)4, (int)symmetricDifferenceFriendsFirst.size());
            Sets.SetView symmetricDifferenceEnemiesFirst = Sets.symmetricDifference((Set)enemies, (Set)friends);
            MoreTests.assertEquals((int)4, (int)symmetricDifferenceEnemiesFirst.size());
            MoreTests.assertEquals((Object)symmetricDifferenceFriendsFirst, (Object)symmetricDifferenceEnemiesFirst);
            ImmutableSet immut = Sets.symmetricDifference((Set)friends, (Set)enemies).immutableCopy();
            HashSet mut = (HashSet)Sets.symmetricDifference((Set)friends, (Set)enemies).copyInto(new HashSet());
            enemies.add("Dave");
            MoreTests.assertEquals((int)3, (int)symmetricDifferenceFriendsFirst.size());
            MoreTests.assertEquals((int)4, (int)immut.size());
            MoreTests.assertEquals((int)4, (int)mut.size());
            immut = Sets.symmetricDifference((Set)enemies, (Set)friends).immutableCopy();
            mut = (HashSet)Sets.symmetricDifference((Set)enemies, (Set)friends).copyInto(new HashSet());
            friends.add("Harry");
            MoreTests.assertEquals((int)2, (int)symmetricDifferenceEnemiesFirst.size());
            MoreTests.assertEquals((int)3, (int)immut.size());
            MoreTests.assertEquals((int)3, (int)mut.size());
        }
    }
}

