/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.escape;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.ImmutableMap;
import com.google.common.escape.CharEscaper;
import com.google.common.escape.Escaper;
import com.google.common.escape.Escapers;
import com.google.common.escape.UnicodeEscaper;
import com.google.common.escape.testing.EscaperAsserts;
import java.io.IOException;
import junit.framework.TestCase;

@GwtCompatible
public class EscapersTest
extends TestCase {
    public void testNullEscaper() throws IOException {
        Escaper escaper = Escapers.nullEscaper();
        EscaperAsserts.assertBasic((Escaper)escaper);
        String s = "\u0000\n\t\\az09~\ud800\udc00\uffff";
        EscapersTest.assertEquals((String)"null escaper should have no effect", (String)s, (String)escaper.escape(s));
    }

    public void testBuilderInitialStateNoReplacement() {
        Escaper escaper = Escapers.builder().setSafeRange('a', 'z').build();
        EscapersTest.assertEquals((String)"The Quick Brown Fox", (String)escaper.escape("The Quick Brown Fox"));
    }

    public void testBuilderInitialStateNoneUnsafe() {
        Escaper escaper = Escapers.builder().setUnsafeReplacement("X").build();
        EscapersTest.assertEquals((String)"\u0000\uffff", (String)escaper.escape("\u0000\uffff"));
    }

    public void testBuilderRetainsState() {
        Escapers.Builder builder = Escapers.builder();
        builder.setSafeRange('a', 'z');
        builder.setUnsafeReplacement("X");
        EscapersTest.assertEquals((String)"XheXXuickXXrownXXoxX", (String)builder.build().escape("The Quick Brown Fox!"));
        builder.addEscape(' ', "_");
        builder.addEscape('!', "_");
        EscapersTest.assertEquals((String)"Xhe_Xuick_Xrown_Xox_", (String)builder.build().escape("The Quick Brown Fox!"));
        builder.setSafeRange(' ', '~');
        EscapersTest.assertEquals((String)"The_Quick_Brown_Fox_", (String)builder.build().escape("The Quick Brown Fox!"));
    }

    public void testBuilderCreatesIndependentEscapers() {
        Escapers.Builder builder = Escapers.builder();
        builder.setSafeRange('a', 'z');
        builder.setUnsafeReplacement("X");
        builder.addEscape(' ', "_");
        Escaper first = builder.build();
        builder.addEscape(' ', "-");
        builder.addEscape('!', "$");
        Escaper second = builder.build();
        builder.addEscape(' ', "*");
        EscapersTest.assertEquals((String)"Xhe_Xuick_Xrown_XoxX", (String)first.escape("The Quick Brown Fox!"));
        EscapersTest.assertEquals((String)"Xhe-Xuick-Xrown-Xox$", (String)second.escape("The Quick Brown Fox!"));
    }

    public void testAsUnicodeEscaper() throws IOException {
        CharEscaper charEscaper = EscapersTest.createSimpleCharEscaper((ImmutableMap<Character, char[]>)ImmutableMap.builder().put((Object)Character.valueOf('x'), (Object)"<hello>".toCharArray()).put((Object)Character.valueOf('\ud800'), (Object)"<hi>".toCharArray()).put((Object)Character.valueOf('\udc00'), (Object)"<lo>".toCharArray()).build());
        UnicodeEscaper unicodeEscaper = Escapers.asUnicodeEscaper((Escaper)charEscaper);
        EscaperAsserts.assertBasic((Escaper)unicodeEscaper);
        EscapersTest.assertEquals((String)"<hello><hi><lo>", (String)charEscaper.escape("x\ud800\udc00"));
        EscapersTest.assertEquals((String)"<hello><hi><lo>", (String)unicodeEscaper.escape("x\ud800\udc00"));
        EscapersTest.assertEquals((String)"<hi><hello><lo>", (String)charEscaper.escape("\ud800x\udc00"));
        try {
            unicodeEscaper.escape("\ud800x\udc00");
            EscapersTest.fail((String)"should have failed for bad Unicode input");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        EscapersTest.assertEquals((String)"<lo><hi>", (String)charEscaper.escape("\udc00\ud800"));
        try {
            unicodeEscaper.escape("\udc00\ud800");
            EscapersTest.fail((String)"should have failed for bad Unicode input");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    static CharEscaper createSimpleCharEscaper(final ImmutableMap<Character, char[]> replacementMap) {
        return new CharEscaper(){

            protected char[] escape(char c) {
                return (char[])replacementMap.get((Object)Character.valueOf(c));
            }
        };
    }

    static UnicodeEscaper createSimpleUnicodeEscaper(final ImmutableMap<Integer, char[]> replacementMap) {
        return new UnicodeEscaper(){

            protected char[] escape(int cp) {
                return (char[])replacementMap.get((Object)cp);
            }
        };
    }
}

