/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.graph.AbstractGraphTest;
import com.google.common.truth.Truth;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractDirectedGraphTest
extends AbstractGraphTest {
    @Test
    public void predecessors_oneEdge() {
        this.addEdge(N1, N2);
        Truth.assertThat((Iterable)this.graph.predecessors((Object)N2)).containsExactly(new Object[]{N1});
        Truth.assertThat((Iterable)this.graph.predecessors((Object)N1)).isEmpty();
    }

    @Test
    public void successors_oneEdge() {
        this.addEdge(N1, N2);
        Truth.assertThat((Iterable)this.graph.successors((Object)N1)).containsExactly(new Object[]{N2});
        Truth.assertThat((Iterable)this.graph.successors((Object)N2)).isEmpty();
    }

    @Test
    public void inDegree_oneEdge() {
        this.addEdge(N1, N2);
        Assert.assertEquals((long)1L, (long)this.graph.inDegree((Object)N2));
        Assert.assertEquals((long)0L, (long)this.graph.inDegree((Object)N1));
    }

    @Test
    public void outDegree_oneEdge() {
        this.addEdge(N1, N2);
        Assert.assertEquals((long)1L, (long)this.graph.outDegree((Object)N1));
        Assert.assertEquals((long)0L, (long)this.graph.outDegree((Object)N2));
    }

    @Test
    public void addEdge_existingNodes() {
        this.addNode(N1);
        this.addNode(N2);
        Assert.assertTrue((boolean)this.addEdge(N1, N2));
    }

    @Test
    public void addEdge_existingEdgeBetweenSameNodes() {
        this.addEdge(N1, N2);
        Assert.assertFalse((boolean)this.addEdge(N1, N2));
    }

    @Test
    public void removeEdge_existingEdge() {
        this.addEdge(N1, N2);
        Truth.assertThat((Iterable)this.graph.successors((Object)N1)).containsExactly(new Object[]{N2});
        Truth.assertThat((Iterable)this.graph.predecessors((Object)N2)).containsExactly(new Object[]{N1});
        Assert.assertTrue((boolean)this.graph.removeEdge((Object)N1, (Object)N2));
        Truth.assertThat((Iterable)this.graph.successors((Object)N1)).isEmpty();
        Truth.assertThat((Iterable)this.graph.predecessors((Object)N2)).isEmpty();
    }
}

