/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.collect.ImmutableSet;
import com.google.common.graph.AbstractNetworkTest;
import com.google.common.graph.Graphs;
import com.google.common.graph.Network;
import com.google.common.truth.Truth;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractDirectedNetworkTest
extends AbstractNetworkTest {
    @After
    public void validateSourceAndTarget() {
        for (Integer node : this.graph.nodes()) {
            Integer oppositeNode;
            for (String inEdge : this.graph.inEdges((Object)node)) {
                oppositeNode = (Integer)Graphs.oppositeNode((Network)this.graph, (Object)inEdge, (Object)node);
                Truth.assertThat((Integer)((Integer)this.graph.source((Object)inEdge))).isEqualTo((Object)oppositeNode);
                Truth.assertThat((Integer)((Integer)this.graph.target((Object)inEdge))).isEqualTo((Object)node);
            }
            for (String outEdge : this.graph.outEdges((Object)node)) {
                oppositeNode = (Integer)Graphs.oppositeNode((Network)this.graph, (Object)outEdge, (Object)node);
                Truth.assertThat((Integer)((Integer)this.graph.source((Object)outEdge))).isEqualTo((Object)node);
                Truth.assertThat((Integer)((Integer)this.graph.target((Object)outEdge))).isEqualTo((Object)oppositeNode);
            }
            for (Integer adjacentNode : this.graph.adjacentNodes((Object)node)) {
                Set edges = this.graph.edgesConnecting((Object)node, (Object)adjacentNode);
                Set antiParallelEdges = this.graph.edgesConnecting((Object)adjacentNode, (Object)node);
                Assert.assertTrue((node.equals(adjacentNode) || Collections.disjoint(edges, antiParallelEdges) ? 1 : 0) != 0);
            }
        }
    }

    @Override
    @Test
    public void incidentNodes_oneEdge() {
        this.addEdge("1-2", N1, N2);
        Truth.assertThat((Iterable)this.graph.incidentNodes((Object)"1-2")).containsExactly(new Object[]{N1, N2}).inOrder();
    }

    @Test
    public void edgesConnecting_oneEdge() {
        this.addEdge("1-2", N1, N2);
        Truth.assertThat((Iterable)this.graph.edgesConnecting((Object)N1, (Object)N2)).containsExactly(new Object[]{"1-2"});
        Truth.assertThat((Iterable)this.graph.edgesConnecting((Object)N2, (Object)N1)).isEmpty();
    }

    @Test
    public void inEdges_oneEdge() {
        this.addEdge("1-2", N1, N2);
        Truth.assertThat((Iterable)this.graph.inEdges((Object)N2)).containsExactly(new Object[]{"1-2"});
        Truth.assertThat((Iterable)this.graph.inEdges((Object)N1)).isEmpty();
    }

    @Test
    public void outEdges_oneEdge() {
        this.addEdge("1-2", N1, N2);
        Truth.assertThat((Iterable)this.graph.outEdges((Object)N1)).containsExactly(new Object[]{"1-2"});
        Truth.assertThat((Iterable)this.graph.outEdges((Object)N2)).isEmpty();
    }

    @Test
    public void predecessors_oneEdge() {
        this.addEdge("1-2", N1, N2);
        Truth.assertThat((Iterable)this.graph.predecessors((Object)N2)).containsExactly(new Object[]{N1});
        Truth.assertThat((Iterable)this.graph.predecessors((Object)N1)).isEmpty();
    }

    @Test
    public void successors_oneEdge() {
        this.addEdge("1-2", N1, N2);
        Truth.assertThat((Iterable)this.graph.successors((Object)N1)).containsExactly(new Object[]{N2});
        Truth.assertThat((Iterable)this.graph.successors((Object)N2)).isEmpty();
    }

    @Test
    public void inDegree_oneEdge() {
        this.addEdge("1-2", N1, N2);
        Assert.assertEquals((long)1L, (long)this.graph.inDegree((Object)N2));
        Assert.assertEquals((long)0L, (long)this.graph.inDegree((Object)N1));
    }

    @Test
    public void outDegree_oneEdge() {
        this.addEdge("1-2", N1, N2);
        Assert.assertEquals((long)1L, (long)this.graph.outDegree((Object)N1));
        Assert.assertEquals((long)0L, (long)this.graph.outDegree((Object)N2));
    }

    @Test
    public void source_oneEdge() {
        this.addEdge("1-2", N1, N2);
        Assert.assertEquals((Object)N1, (Object)this.graph.source((Object)"1-2"));
    }

    @Test
    public void source_edgeNotInGraph() {
        try {
            this.graph.source((Object)"edgeNotInGraph");
            Assert.fail((String)"Should not be allowed to pass an edge that is not an element of the graph.");
        }
        catch (IllegalArgumentException e) {
            AbstractDirectedNetworkTest.assertEdgeNotInGraphErrorMessage(e);
        }
    }

    @Test
    public void target_oneEdge() {
        this.addEdge("1-2", N1, N2);
        Assert.assertEquals((Object)N2, (Object)this.graph.target((Object)"1-2"));
    }

    @Test
    public void target_edgeNotInGraph() {
        try {
            this.graph.target((Object)"edgeNotInGraph");
            Assert.fail((String)"Should not be allowed to pass an edge that is not an element of the graph.");
        }
        catch (IllegalArgumentException e) {
            AbstractDirectedNetworkTest.assertEdgeNotInGraphErrorMessage(e);
        }
    }

    @Test
    public void addEdge_existingNodes() {
        this.addNode(N1);
        this.addNode(N2);
        Assert.assertTrue((boolean)this.addEdge("1-2", N1, N2));
        Truth.assertThat((Iterable)this.graph.edges()).contains((Object)"1-2");
        Truth.assertThat((Iterable)this.graph.edgesConnecting((Object)N1, (Object)N2)).containsExactly(new Object[]{"1-2"});
        Truth.assertThat((Iterable)this.graph.edgesConnecting((Object)N2, (Object)N1)).isEmpty();
    }

    @Test
    public void addEdge_existingEdgeBetweenSameNodes() {
        this.addEdge("1-2", N1, N2);
        ImmutableSet edges = ImmutableSet.copyOf((Collection)this.graph.edges());
        Assert.assertFalse((boolean)this.addEdge("1-2", N1, N2));
        Truth.assertThat((Iterable)this.graph.edges()).containsExactlyElementsIn((Iterable)edges);
    }

    @Test
    public void addEdge_existingEdgeBetweenDifferentNodes() {
        this.addEdge("1-2", N1, N2);
        try {
            this.addEdge("1-2", N4, N5);
            Assert.fail((String)"Reusing an existing edge to connect different nodes succeeded");
        }
        catch (IllegalArgumentException e) {
            Truth.assertThat((String)e.getMessage()).contains((CharSequence)"it can't be reused to connect");
        }
        try {
            this.addEdge("1-2", N2, N1);
            Assert.fail((String)"Reusing an existing edge to connect different nodes succeeded");
        }
        catch (IllegalArgumentException e) {
            Truth.assertThat((String)e.getMessage()).contains((CharSequence)"it can't be reused to connect");
        }
    }

    @Test
    public void addEdge_parallelEdge() {
        this.addEdge("1-2", N1, N2);
        try {
            this.addEdge("edgeNotInGraph", N1, N2);
            Assert.fail((String)"Should not be allowed to add a parallel edge.");
        }
        catch (IllegalArgumentException e) {
            Truth.assertThat((String)e.getMessage()).contains((CharSequence)"connected by a different edge");
        }
    }

    @Test
    public void removeEdge_existingEdge() {
        this.addEdge("1-2", N1, N2);
        Assert.assertTrue((boolean)this.graph.removeEdge((Object)"1-2"));
        Truth.assertThat((Iterable)this.graph.edges()).doesNotContain((Object)"1-2");
        Truth.assertThat((Iterable)this.graph.edgesConnecting((Object)N1, (Object)N2)).isEmpty();
    }
}

