/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.collect.ImmutableSet;
import com.google.common.graph.Graphs;
import com.google.common.graph.ImmutableGraph;
import com.google.common.graph.MutableGraph;
import com.google.common.testing.EqualsTester;
import com.google.common.truth.Truth;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Collection;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractGraphTest {
    MutableGraph<Integer> graph;
    static final Integer N1 = 1;
    static final Integer N2 = 2;
    static final Integer N3 = 3;
    static final Integer N4 = 4;
    static final Integer N5 = 5;
    static final Integer NODE_NOT_IN_GRAPH = 1000;
    static final String ERROR_ELEMENT_NOT_IN_GRAPH = "not an element of this graph";
    static final String NODE_STRING = "Node";
    static final String EDGE_STRING = "Edge";
    static final String ERROR_MODIFIABLE_SET = "Set returned is unexpectedly modifiable";
    static final String ERROR_SELF_LOOP = "self-loops are not allowed";
    static final String ERROR_NODE_NOT_IN_GRAPH = "Should not be allowed to pass a node that is not an element of the graph.";
    static final String ERROR_ADDED_SELF_LOOP = "Should not be allowed to add a self-loop edge.";
    static final String ERROR_ADDED_PARALLEL_EDGE = "Should not be allowed to add a parallel edge.";

    public abstract MutableGraph<Integer> createGraph();

    @CanIgnoreReturnValue
    boolean addNode(Integer n) {
        return this.graph.addNode((Object)n);
    }

    @CanIgnoreReturnValue
    boolean addEdge(Integer n1, Integer n2) {
        this.graph.addNode((Object)n1);
        this.graph.addNode((Object)n2);
        return this.graph.addEdge((Object)n1, (Object)n2);
    }

    @Before
    public void init() {
        this.graph = this.createGraph();
    }

    @After
    public void validateGraphState() {
        new EqualsTester().addEqualityGroup(new Object[]{this.graph, Graphs.copyOf(this.graph), ImmutableGraph.copyOf(this.graph)}).testEquals();
        String graphString = this.graph.toString();
        Truth.assertThat((String)graphString).contains((CharSequence)("isDirected: " + this.graph.isDirected()));
        Truth.assertThat((String)graphString).contains((CharSequence)("allowsSelfLoops: " + this.graph.allowsSelfLoops()));
        int nodeStart = graphString.indexOf("nodes:");
        int edgeStart = graphString.indexOf("edges:");
        String nodeString = graphString.substring(nodeStart, edgeStart);
        for (Integer node : this.graph.nodes()) {
            Truth.assertThat((String)nodeString).contains((CharSequence)node.toString());
            for (Integer adjacentNode : this.graph.adjacentNodes((Object)node)) {
                Assert.assertTrue((this.graph.predecessors((Object)node).contains(adjacentNode) || this.graph.successors((Object)node).contains(adjacentNode) ? 1 : 0) != 0);
            }
            for (Integer predecessor : this.graph.predecessors((Object)node)) {
                Truth.assertThat((Iterable)this.graph.successors((Object)predecessor)).contains((Object)node);
            }
            for (Integer successor : this.graph.successors((Object)node)) {
                Truth.assertThat((Iterable)this.graph.predecessors((Object)successor)).contains((Object)node);
            }
        }
    }

    @Test
    public abstract void nodes_checkReturnedSetMutability();

    @Test
    public abstract void adjacentNodes_checkReturnedSetMutability();

    @Test
    public abstract void predecessors_checkReturnedSetMutability();

    @Test
    public abstract void successors_checkReturnedSetMutability();

    @Test
    public void nodes_oneNode() {
        this.addNode(N1);
        Truth.assertThat((Iterable)this.graph.nodes()).containsExactly(new Object[]{N1});
    }

    @Test
    public void nodes_noNodes() {
        Truth.assertThat((Iterable)this.graph.nodes()).isEmpty();
    }

    @Test
    public void adjacentNodes_oneEdge() {
        this.addEdge(N1, N2);
        Truth.assertThat((Iterable)this.graph.adjacentNodes((Object)N1)).containsExactly(new Object[]{N2});
        Truth.assertThat((Iterable)this.graph.adjacentNodes((Object)N2)).containsExactly(new Object[]{N1});
    }

    @Test
    public void adjacentNodes_noAdjacentNodes() {
        this.addNode(N1);
        Truth.assertThat((Iterable)this.graph.adjacentNodes((Object)N1)).isEmpty();
    }

    @Test
    public void adjacentNodes_nodeNotInGraph() {
        try {
            this.graph.adjacentNodes((Object)NODE_NOT_IN_GRAPH);
            Assert.fail((String)ERROR_NODE_NOT_IN_GRAPH);
        }
        catch (IllegalArgumentException e) {
            AbstractGraphTest.assertNodeNotInGraphErrorMessage(e);
        }
    }

    @Test
    public void predecessors_noPredecessors() {
        this.addNode(N1);
        Truth.assertThat((Iterable)this.graph.predecessors((Object)N1)).isEmpty();
    }

    @Test
    public void predecessors_nodeNotInGraph() {
        try {
            this.graph.predecessors((Object)NODE_NOT_IN_GRAPH);
            Assert.fail((String)ERROR_NODE_NOT_IN_GRAPH);
        }
        catch (IllegalArgumentException e) {
            AbstractGraphTest.assertNodeNotInGraphErrorMessage(e);
        }
    }

    @Test
    public void successors_noSuccessors() {
        this.addNode(N1);
        Truth.assertThat((Iterable)this.graph.successors((Object)N1)).isEmpty();
    }

    @Test
    public void successors_nodeNotInGraph() {
        try {
            this.graph.successors((Object)NODE_NOT_IN_GRAPH);
            Assert.fail((String)ERROR_NODE_NOT_IN_GRAPH);
        }
        catch (IllegalArgumentException e) {
            AbstractGraphTest.assertNodeNotInGraphErrorMessage(e);
        }
    }

    @Test
    public void degree_oneEdge() {
        this.addEdge(N1, N2);
        Assert.assertEquals((long)1L, (long)this.graph.degree((Object)N1));
        Assert.assertEquals((long)1L, (long)this.graph.degree((Object)N2));
    }

    @Test
    public void degree_isolatedNode() {
        this.addNode(N1);
        Assert.assertEquals((long)0L, (long)this.graph.degree((Object)N1));
    }

    @Test
    public void degree_nodeNotInGraph() {
        try {
            this.graph.degree((Object)NODE_NOT_IN_GRAPH);
            Assert.fail((String)ERROR_NODE_NOT_IN_GRAPH);
        }
        catch (IllegalArgumentException e) {
            AbstractGraphTest.assertNodeNotInGraphErrorMessage(e);
        }
    }

    @Test
    public void inDegree_isolatedNode() {
        this.addNode(N1);
        Assert.assertEquals((long)0L, (long)this.graph.inDegree((Object)N1));
    }

    @Test
    public void inDegree_nodeNotInGraph() {
        try {
            this.graph.inDegree((Object)NODE_NOT_IN_GRAPH);
            Assert.fail((String)ERROR_NODE_NOT_IN_GRAPH);
        }
        catch (IllegalArgumentException e) {
            AbstractGraphTest.assertNodeNotInGraphErrorMessage(e);
        }
    }

    @Test
    public void outDegree_isolatedNode() {
        this.addNode(N1);
        Assert.assertEquals((long)0L, (long)this.graph.outDegree((Object)N1));
    }

    @Test
    public void outDegree_nodeNotInGraph() {
        try {
            this.graph.outDegree((Object)NODE_NOT_IN_GRAPH);
            Assert.fail((String)ERROR_NODE_NOT_IN_GRAPH);
        }
        catch (IllegalArgumentException e) {
            AbstractGraphTest.assertNodeNotInGraphErrorMessage(e);
        }
    }

    @Test
    public void addNode_newNode() {
        Assert.assertTrue((boolean)this.addNode(N1));
        Truth.assertThat((Iterable)this.graph.nodes()).contains((Object)N1);
    }

    @Test
    public void addNode_existingNode() {
        this.addNode(N1);
        ImmutableSet nodes = ImmutableSet.copyOf((Collection)this.graph.nodes());
        Assert.assertFalse((boolean)this.addNode(N1));
        Truth.assertThat((Iterable)this.graph.nodes()).containsExactlyElementsIn((Iterable)nodes);
    }

    @Test
    public void removeNode_existingNode() {
        this.addEdge(N1, N2);
        this.addEdge(N4, N1);
        Assert.assertTrue((boolean)this.graph.removeNode((Object)N1));
        Truth.assertThat((Iterable)this.graph.nodes()).containsExactly(new Object[]{N2, N4});
        Truth.assertThat((Iterable)this.graph.adjacentNodes((Object)N2)).isEmpty();
        Truth.assertThat((Iterable)this.graph.adjacentNodes((Object)N4)).isEmpty();
    }

    @Test
    public void removeNode_invalidArgument() {
        ImmutableSet nodes = ImmutableSet.copyOf((Collection)this.graph.nodes());
        Assert.assertFalse((boolean)this.graph.removeNode((Object)NODE_NOT_IN_GRAPH));
        Truth.assertThat((Iterable)this.graph.nodes()).containsExactlyElementsIn((Iterable)nodes);
    }

    @Test
    public void removeEdge_oneOfMany() {
        this.addEdge(N1, N2);
        this.addEdge(N1, N3);
        this.addEdge(N1, N4);
        Assert.assertTrue((boolean)this.graph.removeEdge((Object)N1, (Object)N3));
        Truth.assertThat((Iterable)this.graph.adjacentNodes((Object)N1)).containsExactly(new Object[]{N2, N4});
    }

    static void assertNodeNotInGraphErrorMessage(Throwable throwable) {
        Truth.assertThat((String)throwable.getMessage()).startsWith(NODE_STRING);
        Truth.assertThat((String)throwable.getMessage()).contains((CharSequence)ERROR_ELEMENT_NOT_IN_GRAPH);
    }

    static void assertEdgeNotInGraphErrorMessage(Throwable throwable) {
        Truth.assertThat((String)throwable.getMessage()).startsWith(EDGE_STRING);
        Truth.assertThat((String)throwable.getMessage()).contains((CharSequence)ERROR_ELEMENT_NOT_IN_GRAPH);
    }
}

